/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlUnusedSubqueryItemInspection;
import com.intellij.sql.inspections.SqlUnusedVariableInspection;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlUnusedSubqueryItemInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "getDisplayName", "", "intellij.database.sql.impl"})
public final class SqlUnusedSubqueryItemInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.unused.subquery.item", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SqlMessages.message(\"ins\u2026me.unused.subquery.item\")");
        return string;
    }

    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<? extends ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            /*
             * WARNING - void declaration
             */
            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                void fromExpression;
                SqlExpression expression;
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                SqlSelectClause selectClause = o.getSelectClause();
                if (selectClause == null) {
                    return;
                }
                boolean hasNoArgCall = false;
                boolean hasAggregate = false;
                Iterator<E> iterator = selectClause.getExpressions().iterator();
                while (iterator.hasNext()) {
                    BuiltinFunction builtinFunction;
                    SqlExpressionList parameterList;
                    SqlExpression sqlExpression = expression = (SqlExpression)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression, (String)"expression");
                    if (this.isStarReference(sqlExpression)) {
                        return;
                    }
                    if (!(expression instanceof SqlFunctionCallExpression)) continue;
                    if (((SqlFunctionCallExpression)expression).getParameterList() == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)parameterList, (String)"expression.parameterList ?: continue");
                    if (parameterList.getExpressionList().size() == 0) {
                        hasNoArgCall = true;
                    }
                    if (!((builtinFunction = ((SqlFunctionCallExpression)expression).getFunctionDefinition()) instanceof SqlFunctionDefinition)) {
                        builtinFunction = null;
                    }
                    SqlFunctionDefinition sqlFunctionDefinition = (SqlFunctionDefinition)builtinFunction;
                    if (sqlFunctionDefinition == null) continue;
                    if (!SqlPsiUtilKt.isAggregate(sqlFunctionDefinition)) continue;
                    hasAggregate = true;
                }
                expression = new Ref.ObjectRef();
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                Object object = sqlTableExpression != null && (sqlTableExpression = sqlTableExpression.getFromClause()) != null ? sqlTableExpression.getFromExpression() : (expression.element = null);
                if ((SqlExpression)fromExpression.element instanceof SqlAsExpression && !SqlUnusedVariableInspection.foundAnyRefs((PsiElement)((SqlExpression)fromExpression.element), (Condition<? super SqlElement>)((Condition)new Condition<SqlElement>(this, (Ref.ObjectRef)fromExpression){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $fromExpression;

                    public final boolean value(SqlElement it) {
                        return it == (SqlExpression)this.$fromExpression.element ? true : it instanceof SqlReferenceExpression && createAnnotationVisitor.1.access$isQualifier(this.this$0, (SqlReferenceExpression)it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fromExpression = objectRef;
                    }
                }), o.getUseScope())) {
                    fromExpression.element = ((SqlAsExpression)((SqlExpression)fromExpression.element)).getExpression();
                }
                while ((SqlExpression)fromExpression.element instanceof SqlParenthesizedExpression) {
                    List expressionList;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((SqlParenthesizedExpression)((SqlExpression)fromExpression.element)).getExpressionList(), (String)"fromExpression.expressionList");
                    if (expressionList.size() != 1) break;
                    fromExpression.element = (SqlExpression)expressionList.get(0);
                }
                List list = ContainerUtil.emptyList();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.emptyList<SqlExpression>()");
                List expressionBranches = list;
                while ((SqlExpression)fromExpression.element instanceof SqlNAryExpression) {
                    if (expressionBranches.isEmpty()) {
                        ArrayList arrayList = ContainerUtil.newArrayList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayList()");
                        expressionBranches = arrayList;
                    }
                    List list2 = ((SqlNAryExpression)((SqlExpression)fromExpression.element)).getOperands();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"fromExpression.operands");
                    expressionBranches.addAll(list2);
                    fromExpression.element = ((SqlNAryExpression)((SqlExpression)fromExpression.element)).getLOperand();
                }
                if ((SqlExpression)fromExpression.element instanceof SqlQueryExpression) {
                    this.inspectQueryExpression((SqlQueryExpression)((SqlExpression)fromExpression.element), (SearchScope)new LocalSearchScope((PsiElement)o), expressionBranches, hasNoArgCall, hasAggregate);
                }
                super.visitSqlQueryExpression(o);
            }

            private final SqlExpression skipParenthesized(SqlExpression expression) {
                PsiElement parent2;
                while ((parent2 = SqlImplUtil.sqlParent((PsiElement)expression)) instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)parent2).getExpressionList().size() == 1) {
                    expression = (SqlExpression)parent2;
                }
                return expression;
            }

            private final boolean isQualifier(SqlReferenceExpression expression) {
                SqlExpression baseExpression = this.skipParenthesized((SqlExpression)expression);
                PsiElement psiElement = baseExpression.getParent();
                if (!(psiElement instanceof SqlReferenceExpression)) {
                    psiElement = null;
                }
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement;
                return Intrinsics.areEqual((Object)(sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null), (Object)baseExpression);
            }

            private final boolean isStarReference(SqlExpression expression) {
                boolean bl;
                block3: {
                    JBIterable jBIterable = SqlImplUtil.sqlTraverser((PsiElement)expression).filter(SqlReferenceExpression.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil.sqlTraverser\u2026ceExpression::class.java)");
                    Iterable $receiver$iv = (Iterable)jBIterable;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            SqlReferenceExpression e;
                            SqlReferenceExpression sqlReferenceExpression = e = (SqlReferenceExpression)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression, (String)"e");
                            if (!Intrinsics.areEqual((Object)"*", (Object)sqlReferenceExpression.getName())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final void inspectQueryExpression(SqlQueryExpression o, SearchScope searchScope, List<? extends SqlExpression> expressionBranches, boolean hasNoArgCall, boolean hasAggregate) {
                boolean hasDistinct;
                List expressions;
                block10: {
                    boolean bl;
                    SqlSelectClause sqlSelectClause = o.getSelectClause();
                    if (sqlSelectClause == null) {
                        return;
                    }
                    SqlSelectClause selectClause = sqlSelectClause;
                    List list = selectClause.getExpressions();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"selectClause.expressions");
                    expressions = list;
                    if (expressions.size() == 1 && hasNoArgCall && hasAggregate) {
                        return;
                    }
                    List list2 = selectClause.getOptions();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"selectClause.options");
                    Iterable $receiver$iv = list2;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            SqlSelectOption it;
                            SqlSelectOption sqlSelectOption = it = (SqlSelectOption)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlSelectOption, (String)"it");
                            String string = sqlSelectOption.getOptionName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.optionName");
                            if (!StringsKt.startsWith((String)string, (String)"DISTINCT", (boolean)true)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = hasDistinct = false;
                    }
                }
                if (hasDistinct && hasAggregate) {
                    return;
                }
                for (SqlExpression expression : expressions) {
                    SqlElement element2;
                    if (expression instanceof SqlAsExpression) {
                        this.reportErrorForName(expression, this.getErrorElementName(o, (SqlAsExpression)expression, expressionBranches, searchScope));
                    }
                    if (!(expression instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expression).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) continue;
                    if (this.isStarReference(expression)) {
                        this.validateStarReference(o, expression, expressionBranches, searchScope);
                        continue;
                    }
                    PsiElement psiElement = ((SqlReferenceExpression)expression).resolve();
                    if (!(psiElement instanceof SqlElement)) {
                        psiElement = null;
                    }
                    if ((element2 = (SqlElement)psiElement) == null) continue;
                    this.reportErrorForName(expression, this.getErrorElementName(o, element2, (SqlElement)expression, expressionBranches, searchScope, false));
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void validateStarReference(SqlQueryExpression o, SqlExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope searchScope) {
                SqlTableType sqlType;
                SqlTableExpression sqlTableExpression = o.getTableExpression();
                Object object = sqlType = sqlTableExpression != null ? sqlTableExpression.getSqlType() : null;
                if (sqlType == null || sqlType instanceof SqlTableTypeBase.Empty) {
                    return;
                }
                HashSet hashSet = ContainerUtil.newHashSet((int)sqlType.getColumnCount());
                Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"ContainerUtil.newHashSet\u2026ing>(sqlType.columnCount)");
                HashSet unusedNames = hashSet;
                HashSet hashSet2 = ContainerUtil.newHashSet((int)sqlType.getColumnCount());
                Intrinsics.checkExpressionValueIsNotNull((Object)hashSet2, (String)"ContainerUtil.newHashSet\u2026ing>(sqlType.columnCount)");
                HashSet usedNames = hashSet2;
                int n = 0;
                int n2 = sqlType.getColumnCount();
                if (n <= n2) {
                    while (true) {
                        void index2;
                        try {
                            SqlElement element2;
                            String name;
                            PsiElement psiElement = sqlType.getColumnElement((int)index2);
                            if (!(psiElement instanceof SqlElement)) {
                                psiElement = null;
                            }
                            if ((name = this.getErrorElementName(o, element2 = (SqlElement)psiElement, (SqlElement)expression, expressionBranches, searchScope, false)) != null) {
                                unusedNames.add(name);
                            } else {
                                usedNames.add(sqlType.getColumnName((int)index2));
                            }
                        }
                        catch (Throwable e) {
                            return;
                        }
                        if (index2 == n2) break;
                        ++index2;
                    }
                }
                if (unusedNames.isEmpty()) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlMessages.message("subquery.item.star.includes.unused", unusedNames.stream().map(createAnnotationVisitor.validateStarReference.1.INSTANCE).collect(Collectors.joining(", ")), "select " + StringUtil.join((Collection)usedNames, (String)", ")), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final String getErrorElementName(SqlQueryExpression inspected, SqlAsExpression expression, List<? extends SqlExpression> expressionBranches, SearchScope scope) {
                List list = expression.getColumnAliasList();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"expression.columnAliasList");
                Iterable $receiver$iv = list;
                for (T element$iv : $receiver$iv) {
                    SqlColumnAliasDefinition colAlias = (SqlColumnAliasDefinition)element$iv;
                    SqlElement sqlElement = (SqlElement)colAlias;
                    SqlColumnAliasDefinition sqlColumnAliasDefinition = colAlias;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlColumnAliasDefinition, (String)"colAlias");
                    if (this.getErrorElementName(inspected, sqlElement, (SqlElement)sqlColumnAliasDefinition, expressionBranches, scope, true) != null) continue;
                    return null;
                }
                if (this.getErrorElementName(inspected, (SqlElement)expression, (SqlElement)expression, expressionBranches, scope, true) == null) {
                    return null;
                }
                Object object = expression.getNameElement();
                if (object == null || (object = object.getName()) == null) {
                    object = expression.getText();
                }
                return object;
            }

            private final String getErrorElementName(SqlQueryExpression inspected, SqlElement element2, SqlElement originalElement, List<? extends SqlExpression> expressionBranches, SearchScope scope, boolean isAlias) {
                if (SqlUnusedVariableInspection.foundAnyRefs((PsiElement)element2, (Condition<? super SqlElement>)((Condition)new Condition<SqlElement>(this, originalElement, expressionBranches, inspected, isAlias){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ SqlElement $originalElement;
                    final /* synthetic */ List $expressionBranches;
                    final /* synthetic */ SqlQueryExpression $inspected;
                    final /* synthetic */ boolean $isAlias;

                    public final boolean value(SqlElement it) {
                        SqlElement sqlElement = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlElement, (String)"it");
                        return createAnnotationVisitor.1.access$hasOnlyLocalRefs(this.this$0, sqlElement, this.$originalElement, this.$expressionBranches) ? true : createAnnotationVisitor.1.access$hasOnlyInnerUsages(this.this$0, this.$inspected, (PsiElement)it, this.$isAlias);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$originalElement = sqlElement;
                        this.$expressionBranches = list;
                        this.$inspected = sqlQueryExpression;
                        this.$isAlias = bl;
                    }
                }), scope)) {
                    return null;
                }
                SqlElement sqlElement = element2;
                if (!(sqlElement instanceof PsiNamedElement)) {
                    sqlElement = null;
                }
                PsiNamedElement psiNamedElement = (PsiNamedElement)sqlElement;
                return psiNamedElement != null ? psiNamedElement.getName() : null;
            }

            private final void reportErrorForName(SqlExpression expression, String name) {
                if (name == null) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlMessages.message("subquery.item.never.used", name), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final boolean hasOnlyInnerUsages(SqlQueryExpression inspected, PsiElement it, boolean isAlias) {
                if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)inspected), (PsiElement)it, (boolean)true)) {
                    return false;
                }
                SqlSelectClause selectClause = inspected.getSelectClause();
                if (selectClause == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)it, (boolean)true)) {
                    return !isAlias;
                }
                return PsiTreeUtil.getParentOfType((PsiElement)it, SqlAsExpression.class, (boolean)true, (Class[])new Class[]{SqlSelectClause.class}) == null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasOnlyLocalRefs(SqlElement e, SqlElement originalElement, List<? extends SqlExpression> expressionBranches) {
                T element$iv;
                SqlExpression b2;
                if (e == originalElement) return true;
                Iterable $receiver$iv = expressionBranches;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $receiver$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)(b2 = (SqlExpression)(element$iv = iterator.next()))), (PsiElement)((PsiElement)e), (boolean)true));
                return true;
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public static final /* synthetic */ boolean access$isQualifier(createAnnotationVisitor.1 $this, @NotNull SqlReferenceExpression expression) {
                return $this.isQualifier(expression);
            }

            public static final /* synthetic */ boolean access$hasOnlyLocalRefs(createAnnotationVisitor.1 $this, @NotNull SqlElement e, @NotNull SqlElement originalElement, @NotNull List expressionBranches) {
                return $this.hasOnlyLocalRefs(e, originalElement, expressionBranches);
            }

            public static final /* synthetic */ boolean access$hasOnlyInnerUsages(createAnnotationVisitor.1 $this, @NotNull SqlQueryExpression inspected, @NotNull PsiElement it, boolean isAlias) {
                return $this.hasOnlyInnerUsages(inspected, it, isAlias);
            }
        };
    }
}

