/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;

public class FileGrouper {
    private static <T> MultiMap<P4Connection, T> distributeByConnection(Collection<T> files, NullableFunction<T, P4Connection> fun) {
        MultiMap sortedFiles = MultiMap.create((TObjectHashingStrategy)new TObjectHashingStrategy<P4Connection>(){

            public int computeHashCode(P4Connection object) {
                return object.getConnectionKey().hashCode();
            }

            public boolean equals(P4Connection o1, P4Connection o2) {
                return Comparing.equal((Object)o1.getConnectionKey(), (Object)o2.getConnectionKey());
            }
        });
        for (T dir : files) {
            P4Connection connection = (P4Connection)fun.fun(dir);
            if (connection == null) continue;
            sortedFiles.putValue((Object)connection, dir);
        }
        return sortedFiles;
    }

    public static MultiMap<P4Connection, VirtualFile> distributeFilesByConnection(Collection<VirtualFile> files, Project project) {
        PerforceConnectionManagerI mgr = PerforceConnectionManager.getInstance(project);
        return FileGrouper.distributeByConnection(files, file -> mgr.getConnectionForFile((VirtualFile)file));
    }

    public static MultiMap<P4Connection, FilePath> distributePathsByConnection(Collection<FilePath> files, Project project) {
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(project);
        return FileGrouper.distributeByConnection(files, path -> connectionManager.getConnectionForFile(P4File.create(path)));
    }

    public static MultiMap<P4Connection, File> distributeIoFilesByConnection(Collection<File> files, Project project) {
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(project);
        return FileGrouper.distributeByConnection(files, file -> connectionManager.getConnectionForFile((File)file));
    }
}

