/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonRequiredPropsReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JsonRequiredPropsReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JsonRequiredPropsReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JsonRequiredPropReference((JsonStringLiteral)element)};
        if (psiReferenceArray == null) {
            JsonRequiredPropsReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static JsonObject findPropertiesObject(PsiElement element) {
        JsonValue value;
        PsiElement parent = JsonRequiredPropsReferenceProvider.getParentSafe(JsonRequiredPropsReferenceProvider.getParentSafe(JsonRequiredPropsReferenceProvider.getParentSafe(element)));
        if (!(parent instanceof JsonObject)) {
            return null;
        }
        Optional<JsonProperty> propertiesProp = ((JsonObject)parent).getPropertyList().stream().filter(p -> "properties".equals(p.getName())).findFirst();
        if (propertiesProp.isPresent() && (value = propertiesProp.get().getValue()) instanceof JsonObject) {
            return (JsonObject)value;
        }
        return null;
    }

    private static PsiElement getParentSafe(@Nullable PsiElement element) {
        return element == null ? null : element.getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonRequiredPropsReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonRequiredPropsReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JsonRequiredPropReference
    extends JsonSchemaBaseReference<JsonStringLiteral> {
        JsonRequiredPropReference(JsonStringLiteral element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            JsonObject propertiesObject = JsonRequiredPropsReferenceProvider.findPropertiesObject(this.getElement());
            if (propertiesObject != null) {
                String name = ((JsonStringLiteral)this.getElement()).getValue();
                for (JsonProperty property : propertiesObject.getPropertyList()) {
                    if (!name.equals(property.getName())) continue;
                    return property;
                }
            }
            return null;
        }
    }
}

