/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common.debugConsole;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugCommentCommand;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugConsoleCommand;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugEvalCommand;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugSimpleCommand;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugCommandFactory {
    @NotNull
    public static PhpDebugConsoleCommand createCommand(@NotNull PsiFile file, @Nullable XSourcePosition position) {
        XSourcePosition newPosition;
        if (file == null) {
            PhpDebugCommandFactory.$$$reportNull$$$0(0);
        }
        if (PhpDebugCommandFactory.isComment(file)) {
            PhpDebugCommentCommand phpDebugCommentCommand = new PhpDebugCommentCommand();
            if (phpDebugCommentCommand == null) {
                PhpDebugCommandFactory.$$$reportNull$$$0(1);
            }
            return phpDebugCommentCommand;
        }
        final Ref wrapIntoEval = new Ref((Object)false);
        final Ref importContext = new Ref((Object)true);
        final Ref hasAssignment = new Ref((Object)false);
        file.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                this.setWrapIntoEval();
            }

            public void visitPhpGroupStatement(GroupStatement groupStatement) {
                PsiElement[] statements = groupStatement.getStatements();
                if (statements != null && statements.length > 1) {
                    this.setWrapIntoEval();
                }
                super.visitPhpGroupStatement(groupStatement);
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                this.setWrapIntoEval();
                importContext.set((Object)false);
            }

            public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                hasAssignment.set((Object)true);
            }

            public void visitPhpClass(PhpClass clazz) {
                this.setWrapIntoEval();
            }

            public void visitPhpTry(Try tryStatement2) {
                this.setWrapIntoEval();
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                this.setWrapIntoEval();
            }

            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpWhile(While whileStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpFor(For forStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpIf(If ifStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpFunction(Function function) {
                this.setWrapIntoEval();
            }

            private void setWrapIntoEval() {
                wrapIntoEval.set((Object)true);
            }
        });
        Object object = newPosition = (Boolean)importContext.get() != false ? position : null;
        if (((Boolean)wrapIntoEval.get()).booleanValue()) {
            PhpDebugEvalCommand phpDebugEvalCommand = new PhpDebugEvalCommand(file.getProject(), newPosition, (Boolean)hasAssignment.get());
            if (phpDebugEvalCommand == null) {
                PhpDebugCommandFactory.$$$reportNull$$$0(2);
            }
            return phpDebugEvalCommand;
        }
        PhpDebugSimpleCommand phpDebugSimpleCommand = new PhpDebugSimpleCommand(file.getProject(), newPosition, (Boolean)hasAssignment.get());
        if (phpDebugSimpleCommand == null) {
            PhpDebugCommandFactory.$$$reportNull$$$0(3);
        }
        return phpDebugSimpleCommand;
    }

    private static boolean isComment(@NotNull PsiFile file) {
        PsiElement[] children;
        if (file == null) {
            PhpDebugCommandFactory.$$$reportNull$$$0(4);
        }
        if ((children = file.getChildren()).length == 1) {
            if (children[0] instanceof GroupStatement) {
                PsiElement[] statements = ((GroupStatement)children[0]).getStatements();
                return statements.length == 1 && statements[0] instanceof PsiComment;
            }
        } else if (children.length == 2 && children[0] instanceof PsiComment && children[1] instanceof GroupStatement) {
            PsiElement[] statements = ((GroupStatement)children[1]).getStatements();
            return statements.length == 0;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/debugConsole/PhpDebugCommandFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/debugConsole/PhpDebugCommandFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

