/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import com.jetbrains.php.lang.parser.parsing.functions.Function;
import com.jetbrains.php.lang.parser.parsing.functions.IsReference;
import com.jetbrains.php.lang.parser.parsing.functions.ParameterList;

public class ClassMethod {
    public static IElementType parse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.tsMODIFIERS) && !builder.compare(PhpTokenTypes.kwFUNCTION)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker method = builder.mark();
        ClassMemberModifiers.parseMethodModifiers(builder);
        if (!builder.compare(PhpTokenTypes.kwFUNCTION)) {
            method.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.match(PhpTokenTypes.kwFUNCTION);
        IsReference.parse(builder);
        if (builder.compare(PhpTokenTypes.tsKEYWORDS) || builder.compare(PhpTokenTypes.IDENTIFIER)) {
            builder.advanceLexer();
        } else {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.IDENTIFIER));
        }
        if (builder.compareAndEat(PhpTokenTypes.chLPAREN)) {
            ParameterList.parse(builder, false);
            builder.match(PhpTokenTypes.chRPAREN);
        } else {
            builder.match(PhpTokenTypes.chLPAREN);
        }
        Function.parseReturnType(builder);
        IElementType result = ClassMethod.parseMethodBody(builder);
        builder.compareAndEat(PhpTokenTypes.opSEMICOLON);
        method.done(result);
        return result;
    }

    private static IElementType parseMethodBody(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.opSEMICOLON)) {
            return PhpStubElementTypes.CLASS_METHOD;
        }
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
        } else {
            builder.match(PhpTokenTypes.chLBRACE);
        }
        return PhpStubElementTypes.CLASS_METHOD;
    }
}

