/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpCSFixer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.tools.quality.CustomRulesSetupDialog;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSFixerCustomRulesSetupDialog
extends CustomRulesSetupDialog {
    private static final String PHP_CS = ".php_cs";
    private static final String PHP_CS_DIST = ".php_cs.dist";

    protected PhpCSFixerCustomRulesSetupDialog(@Nullable Project project, @Nullable PhpInterpreter interpreter, @NotNull Component parent, @NotNull String rulesetPath) {
        if (parent == null) {
            PhpCSFixerCustomRulesSetupDialog.$$$reportNull$$$0(0);
        }
        if (rulesetPath == null) {
            PhpCSFixerCustomRulesSetupDialog.$$$reportNull$$$0(1);
        }
        super(project, interpreter, parent, rulesetPath, true);
    }

    @Override
    protected boolean containsRulesetXml(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (!file.isDirectory()) {
            return PhpCSFixerCustomRulesSetupDialog.isCodingStandardFile(file.getPath());
        }
        return Arrays.stream(file.getChildren()).anyMatch(folderChild -> PHP_CS.equals(folderChild.getName()) || PHP_CS_DIST.equals(folderChild.getName()));
    }

    @Override
    @Nullable
    protected ValidationInfo validatePath(String path) {
        if (path == null || path.isEmpty()) {
            return new ValidationInfo(PhpBundle.message("quality.tool.path.must.not.be.empty", new Object[0]), (JComponent)this.myTopPanel);
        }
        if (!this.myIsRemote) {
            File physicalFile = new File(path);
            if (!physicalFile.exists()) {
                return new ValidationInfo(PhpBundle.message("quality.tool.file.not.found", new Object[0]), (JComponent)this.myTopPanel);
            }
            if (physicalFile.isDirectory()) {
                if (!this.containsRulesetXml(VfsUtil.findFileByIoFile((File)physicalFile, (boolean)true))) {
                    return new ValidationInfo(PhpBundle.message("quality.tool.php_cs.dir.does.not.contain.custom", PHP_CS, PHP_CS_DIST));
                }
            } else if (!PhpCSFixerCustomRulesSetupDialog.isCodingStandardFile(path)) {
                return new ValidationInfo(PhpBundle.message("quality.tool.php_cs.custom.rules.validation.not.php_cs", new Object[0]));
            }
        }
        return null;
    }

    public static boolean isCodingStandardFile(@NotNull String path) {
        String extension;
        if (path == null) {
            PhpCSFixerCustomRulesSetupDialog.$$$reportNull$$$0(2);
        }
        return StringUtil.equalsIgnoreCase((CharSequence)(extension = FileUtilRt.getExtension((String)path)), (CharSequence)"php_cs") || StringUtil.equalsIgnoreCase((CharSequence)extension, (CharSequence)"dist");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesetPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerCustomRulesSetupDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCodingStandardFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

