/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.bean;

import java.util.Objects;
import org.wiztools.restclient.bean.SSLHostnameVerifier;
import org.wiztools.restclient.bean.SSLKeyStore;
import org.wiztools.restclient.bean.SSLReq;

public class SSLReqBean
implements SSLReq {
    private SSLKeyStore trustStore;
    private SSLKeyStore keyStore;
    private SSLHostnameVerifier hostNameVerifier = SSLHostnameVerifier.STRICT;
    private boolean trustAllCerts = false;

    public void setHostNameVerifier(SSLHostnameVerifier sslHostNameVerifier) {
        this.hostNameVerifier = sslHostNameVerifier;
    }

    public void setTrustAllCerts(boolean sslTrustSelfSignedCert) {
        this.trustAllCerts = sslTrustSelfSignedCert;
    }

    public void setKeyStore(SSLKeyStore sslKeyStore) {
        this.keyStore = sslKeyStore;
    }

    public void setTrustStore(SSLKeyStore sslTrustStore) {
        this.trustStore = sslTrustStore;
    }

    @Override
    public SSLHostnameVerifier getHostNameVerifier() {
        return this.hostNameVerifier;
    }

    @Override
    public SSLKeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public SSLKeyStore getTrustStore() {
        return this.trustStore;
    }

    @Override
    public boolean isTrustAllCerts() {
        return this.trustAllCerts;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.trustStore);
        hash = 29 * hash + Objects.hashCode(this.keyStore);
        hash = 29 * hash + Objects.hashCode((Object)this.hostNameVerifier);
        hash = 29 * hash + (this.trustAllCerts ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSLReqBean other = (SSLReqBean)obj;
        if (!Objects.equals(this.trustStore, other.trustStore)) {
            return false;
        }
        if (!Objects.equals(this.keyStore, other.keyStore)) {
            return false;
        }
        if (this.hostNameVerifier != other.hostNameVerifier) {
            return false;
        }
        return this.trustAllCerts == other.trustAllCerts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@SSL[");
        sb.append("trustSelfSignedCert=").append(this.trustAllCerts).append(", ");
        sb.append("hostNameVerifier=").append((Object)this.hostNameVerifier).append(", ");
        sb.append("trustStore=").append(this.trustStore).append(", ");
        sb.append("keyStore=").append(this.keyStore).append(", ");
        sb.append("]");
        return sb.toString();
    }
}

