/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectSettings;

public class HgExecutableManager {
    @NonNls
    private static final String[] DEFAULT_WINDOWS_PATHS = new String[]{"C:\\Program Files\\Mercurial", "C:\\Program Files (x86)\\Mercurial", "C:\\cygwin\\bin"};
    @NonNls
    private static final String[] DEFAULT_UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/mercurial"};
    @NonNls
    private static final String DEFAULT_WINDOWS_HG = "hg.exe";
    @NonNls
    private static final String DEFAULT_UNIX_HG = "hg";
    @NotNull
    private final HgGlobalSettings myGlobalSettings;
    @NotNull
    private final AtomicNotNullLazyValue<String> myDetectedExecutable;

    public static HgExecutableManager getInstance() {
        return (HgExecutableManager)ServiceManager.getService(HgExecutableManager.class);
    }

    public HgExecutableManager(@NotNull HgGlobalSettings globalSettings) {
        if (globalSettings == null) {
            HgExecutableManager.$$$reportNull$$$0(0);
        }
        this.myGlobalSettings = globalSettings;
        this.myDetectedExecutable = AtomicNotNullLazyValue.createValue(HgExecutableManager::identifyDefaultHgExecutable);
    }

    @NotNull
    public String getHgExecutable() {
        String path = this.myGlobalSettings.getHgExecutable();
        String string = path == null ? this.getDefaultExecutable() : path;
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getHgExecutable(@NotNull Project project) {
        HgProjectSettings projectSettings;
        if (project == null) {
            HgExecutableManager.$$$reportNull$$$0(2);
        }
        if (!(projectSettings = HgProjectSettings.getInstance(project)).isHgExecutableOverridden()) {
            String string = this.getHgExecutable();
            if (string == null) {
                HgExecutableManager.$$$reportNull$$$0(3);
            }
            return string;
        }
        String path = projectSettings.getHgExecutable();
        String string = path == null ? this.getDefaultExecutable() : path;
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getDefaultExecutable() {
        String string = (String)this.myDetectedExecutable.getValue();
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String identifyDefaultHgExecutable() {
        String[] paths;
        String programName;
        if (SystemInfo.isWindows) {
            programName = DEFAULT_WINDOWS_HG;
            paths = DEFAULT_WINDOWS_PATHS;
        } else {
            programName = DEFAULT_UNIX_HG;
            paths = DEFAULT_UNIX_PATHS;
        }
        for (String p : paths) {
            Path programPath = Paths.get(p, programName);
            if (!Files.isExecutable(programPath)) continue;
            String string = programPath.toAbsolutePath().toString();
            if (string == null) {
                HgExecutableManager.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = programName;
        if (string == null) {
            HgExecutableManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSettings";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgExecutableManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgExecutableManager";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHgExecutable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExecutable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyDefaultHgExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHgExecutable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

