/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationParams;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandler;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RAbstractTestsCommandLineState;

public class CucumberRunCommandLineState
extends RAbstractTestsCommandLineState {
    @NonNls
    public static final String CUCUMBER_FRAMEWORK_PROPERTY = "Cucumber";
    @NonNls
    public static final String CUCUMBER_RUNNER_OPTIONS_NAME_FILTER_KEY = "--name";
    @NonNls
    public static final String CUCUMBER_RUNNER_OPTIONS_TAGS_FILTER_KEY = "--tags";
    @NonNls
    public static final String CUCUMBER_RUNNER_OPTIONS_EXPAND_KEY = "--expand";
    @NonNls
    public static final String CUCUMBER_FULL_BACKTRACE_KEY = "--backtrace";
    @NonNls
    public static final String CUCUMBER_VERBOSE_KEY = "--verbose";
    @NonNls
    public static final String CUCUMBER_DRB_KEY = "--drb";
    @NonNls
    public static final String CUCUMBER_RUNNER_OPTIONS_FORMAT_KEY = "--format";
    @NonNls
    public static final String CUCUMBER_RUNNER_OPTIONS_FORMAT_SHORT_KEY = "-f";
    @NonNls
    public static final String CUCUMBER_RUNNER_OPTIONS_FORMAT_CLASS = "Teamcity::Cucumber::Formatter";
    @NonNls
    public static final String CUCUMBER_RUNNER_OPTIONS_CUCUMBER_FORMAT = "CUCUMBER_FORMAT";
    @NonNls
    public static final String CUCUMBER_RUNNER_PARAMS_GROUP_ID = "ruby.tests.cucumber.runner";
    @NonNls
    private static final String EXTERNAL_ENCODING_PARAM = "-E";
    private static final Predicate<String> IS_EXTERNAL_ENCODING_PARAM = input -> input != null && input.startsWith(EXTERNAL_ENCODING_PARAM);

    public CucumberRunCommandLineState(CucumberRunConfiguration configuration, ExecutionEnvironment env) {
        super((AbstractRubyRunConfiguration)configuration, env);
    }

    public CucumberRunConfiguration getConfig() {
        return (CucumberRunConfiguration)super.getConfig();
    }

    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        String springExecutable;
        String zeusExecutable;
        CucumberRunConfiguration config = this.getConfig();
        String runnerId = this.getRunnerId();
        RubyCommandLineData data = CucumberRunCommandLineState.createDefaultCommandLine((AbstractRubyRunConfiguration)config, (String)runnerId);
        RubyCommandLine commandLine = data.getCommandLine();
        Map envMap = commandLine.getEnvironment();
        Sdk sdk = config.getSdk();
        assert (sdk != null);
        Module module = config.getModule();
        CucumberRunCommandLineState.specifyExternalEncodingIfNeeded((GeneralCommandLine)commandLine, sdk);
        PathMappingSettings mappingSettings = RubySdkUtil.getRubySdkAdditionalData((Sdk)sdk).getRunnerMappings((AbstractRubyRunConfiguration)config);
        if (this.isGUIRunnerEnabled()) {
            CucumberRunCommandLineState.configureTestFrameworkSupport(envMap, sdk, module, mappingSettings);
        }
        String cucumberRunnerScriptPath = this.determineRSpecRunnerScriptPath(module);
        assert (cucumberRunnerScriptPath != null);
        if (config.getPreloadServer() == PreLoadUtil.PreLoadServer.Zeus && this.preLoaderAllowed() && (zeusExecutable = ZeusUtil.getZeusExecutable((Module)module, (Sdk)sdk)) != null) {
            commandLine.addParameter(mappingSettings.convertToRemote(zeusExecutable));
            cucumberRunnerScriptPath = "cucumber";
        }
        if (config.getPreloadServer() == PreLoadUtil.PreLoadServer.Spring && this.preLoaderAllowed() && (springExecutable = SpringUtil.getSpringExecutable((Module)module, (Sdk)sdk)) != null) {
            commandLine.addParameter(mappingSettings.convertToRemote(springExecutable));
            cucumberRunnerScriptPath = "cucumber";
        }
        ParamsGroup runnerParamsGroup = this.addExecutionScriptGroup(CUCUMBER_RUNNER_PARAMS_GROUP_ID, data, (GeneralCommandLine)commandLine, cucumberRunnerScriptPath);
        String runnerVersion = config.getRunnerGemVersion();
        if (!StringUtil.isEmpty((String)runnerVersion)) {
            runnerParamsGroup.addParameter(CucumberRunCommandLineState.asGemVersionCmdlineArgument((String)runnerVersion));
        }
        CucumberRunCommandLineState.passRunnerOptions(runnerParamsGroup, config, runnerId, this.isGUIRunnerEnabled(), mappingSettings);
        return data;
    }

    private static void specifyExternalEncodingIfNeeded(@NotNull GeneralCommandLine commandLine, @NotNull Sdk sdk) {
        ParametersList parameters;
        if (commandLine == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(1);
        }
        if (RubySdkUtil.isMRISdk((Sdk)sdk) && !RubySdkUtil.isRuby18((Sdk)sdk) && !Iterables.any((Iterable)(parameters = commandLine.getParametersList()).getList(), IS_EXTERNAL_ENCODING_PARAM)) {
            parameters.prepend(EXTERNAL_ENCODING_PARAM + RubyProcessHandler.getOutputEncoding().name());
        }
    }

    public static void passRunnerOptions(@NotNull ParamsGroup runnerParamsGroup, @NotNull CucumberRunConfigurationParams config, @Nullable String runnerId, boolean guiRunnerEnabled, @NotNull PathMappingSettings mappingSettings) {
        if (runnerParamsGroup == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(2);
        }
        if (config == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(3);
        }
        if (mappingSettings == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(4);
        }
        switch (config.getTestType()) {
            case ALL_IN_FOLDER: {
                runnerParamsGroup.addParameter(mappingSettings.convertToRemote(config.getTestsFolderPath()));
                break;
            }
            case TEST_SCRIPT: {
                String testScriptPaths = config.getTestScriptPath();
                List paths = StringUtil.split((String)testScriptPaths, (String)"\n");
                if (paths.size() == 1) {
                    runnerParamsGroup.addParameter(mappingSettings.convertToRemote(testScriptPaths));
                    break;
                }
                paths.stream().map(arg_0 -> ((PathMappingSettings)mappingSettings).convertToRemote(arg_0)).forEach(arg_0 -> ((ParamsGroup)runnerParamsGroup).addParameter(arg_0));
                break;
            }
            case TEST_METHOD: {
                throw new UnsupportedOperationException("Not implemented");
            }
        }
        if (guiRunnerEnabled) {
            runnerParamsGroup.addParameter(CUCUMBER_RUNNER_OPTIONS_FORMAT_KEY);
            runnerParamsGroup.addParameter(CUCUMBER_RUNNER_OPTIONS_FORMAT_CLASS);
            runnerParamsGroup.addParameter(CUCUMBER_RUNNER_OPTIONS_EXPAND_KEY);
        }
        CucumberRunCommandLineState.addElementNameFilterOptions(config, runnerParamsGroup);
        String tagsNameFilter = config.getTagsFilters();
        if (!StringUtil.isEmpty((String)tagsNameFilter)) {
            runnerParamsGroup.addParameter(CUCUMBER_RUNNER_OPTIONS_TAGS_FILTER_KEY);
            runnerParamsGroup.addParameter(tagsNameFilter);
        }
        if (config.getPreloadServer() == PreLoadUtil.PreLoadServer.DRb && CucumberRunCommandLineState.preLoaderAllowed((String)runnerId)) {
            runnerParamsGroup.addParameter(CUCUMBER_DRB_KEY);
        }
        if (!CucumberRunCommandLineState.preLoaderAllowed((String)runnerId)) {
            PreLoadUtil.showDebuggingInfo((Project)config.getProject(), (PreLoadUtil.PreLoadServer)config.getPreloadServer());
        }
        if (config.isBacktraceEnabled()) {
            runnerParamsGroup.addParameter(CUCUMBER_FULL_BACKTRACE_KEY);
        }
        if (config.isVerboseEnabled()) {
            runnerParamsGroup.addParameter(CUCUMBER_VERBOSE_KEY);
        }
        String specArgs = config.getRunnerOptions();
        CucumberRunCommandLineState.addParams((ParamsGroup)runnerParamsGroup, (String)specArgs);
    }

    public static void configureTestFrameworkSupport(@NotNull Map<String, String> envMap, @NotNull Sdk sdk, @Nullable Module module, @NotNull PathMappingSettings mappingSettings) throws ExecutionException {
        if (envMap == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(6);
        }
        if (mappingSettings == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(7);
        }
        RakeRunConfigurationUtil.configureTestFrameworksSupport(envMap, (Sdk)sdk, (Module)module, Collections.singletonList(SupportedTestFramework.CUCUMBER), (PathMappingSettings)mappingSettings);
        if (!envMap.containsKey(CUCUMBER_RUNNER_OPTIONS_CUCUMBER_FORMAT)) {
            envMap.put(CUCUMBER_RUNNER_OPTIONS_CUCUMBER_FORMAT, CUCUMBER_RUNNER_OPTIONS_FORMAT_CLASS);
        }
    }

    protected boolean shouldAttachTestRunnerConsole() {
        return this.isGUIRunnerEnabled();
    }

    @NotNull
    protected SupportedTestFramework getTestFramework() {
        SupportedTestFramework supportedTestFramework = SupportedTestFramework.CUCUMBER;
        if (supportedTestFramework == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(8);
        }
        return supportedTestFramework;
    }

    private boolean isGUIRunnerEnabled() {
        CucumberRunConfiguration config = this.getConfig();
        return CucumberRunCommandLineState.isGUIRunnerEnabled(config);
    }

    public static boolean isGUIRunnerEnabled(@NotNull CucumberRunConfiguration config) {
        String options;
        if (config == null) {
            CucumberRunCommandLineState.$$$reportNull$$$0(9);
        }
        return !CucumberRunCommandLineState.containsOptionKey((String)(options = config.getRunnerOptions()), (String)CUCUMBER_RUNNER_OPTIONS_FORMAT_KEY) && !CucumberRunCommandLineState.containsOptionKey((String)options, (String)CUCUMBER_RUNNER_OPTIONS_FORMAT_SHORT_KEY) && !CucumberRunCommandLineState.containsOptionKey((String)options, (String)CUCUMBER_DRB_KEY);
    }

    private static void addElementNameFilterOptions(CucumberRunConfigurationParams config, ParamsGroup group) {
        String elementNameFilter = config.getFeatureElementNameFilter();
        if (!StringUtil.isEmptyOrSpaces((String)elementNameFilter)) {
            group.addParameter(CUCUMBER_RUNNER_OPTIONS_NAME_FILTER_KEY);
            group.addParameter(elementNameFilter.trim());
        }
    }

    @Nullable
    private String determineRSpecRunnerScriptPath(Module module) {
        CucumberRunConfiguration config = this.getConfig();
        String cucumberScriptPath = config.shouldUseCustomCucumberRunner() ? config.getCustomCucumberRunnerPath() : CucumberUtil.determinePreferredCucumberExecutablePath(module, config.getAlternativeSdk());
        return cucumberScriptPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerParamsGroup";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunCommandLineState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "specifyExternalEncodingIfNeeded";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "passRunnerOptions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureTestFrameworkSupport";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isGUIRunnerEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

