/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import b.h.la;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyCodeExecutor;
import org.jetbrains.plugins.ruby.console.RubyConsoleRootType;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsole;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.ReloadAction;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleProcessHandlerEx;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;

final class IrbRubyLanguageConsoleView
extends RubyLanguageConsole
implements RubyCodeExecutor {
    private final ProcessBackedConsoleExecuteActionHandler d;
    private final String e;
    private final PathMappingSettings a;
    private ProcessHandler b;
    private final String f;
    @Nullable
    private final Module c;
    private static final long h = la.a(1043517699554974419L, -8780214011698403435L, MethodHandles.lookup().lookupClass()).a(158734488780810L);

    IrbRubyLanguageConsoleView(Project project, @NotNull IrbRunConfiguration config) {
        if (config == null) {
            IrbRubyLanguageConsoleView.b(0);
        }
        super(project, config.getName());
        this.c = config.getModule();
        this.f = config.getScriptPath();
        this.e = config.getScriptArgs();
        this.d = this.a(config.isRailsConsole());
        ConsoleExecuteAction consoleExecuteAction = new ConsoleExecuteAction((LanguageConsoleView)this, (BaseConsoleExecuteActionHandler)this.d);
        this.addCustomConsoleAction((AnAction)consoleExecuteAction);
        consoleExecuteAction.registerCustomShortcutSet(consoleExecuteAction.getShortcutSet(), this.getConsoleEditor().getComponent());
        Sdk sdk = config.getSdk();
        assert (sdk != null);
        this.a = RunnerUtil.getRunner(sdk, this.c).addDefaultMappings(config.getMappingSettings());
        if (config.isRailsConsole()) {
            ReloadAction reloadAction = new ReloadAction(this.d);
            this.addCustomConsoleAction(reloadAction);
            reloadAction.registerAt(this.getConsoleEditor().getComponent());
        }
        new UiNotifyConnector.Once((Component)((Object)this), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                new ConsoleHistoryController((ConsoleRootType)RubyConsoleRootType.getInstance(), "", (LanguageConsoleView)IrbRubyLanguageConsoleView.this).install();
                IdeFocusManager.getInstance((Project)IrbRubyLanguageConsoleView.this.getProject()).requestFocus((Component)IrbRubyLanguageConsoleView.this.getCurrentEditor().getContentComponent(), true);
            }
        });
    }

    public boolean canPause() {
        return false;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        super.attachToProcess(processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = la.a(4107846257781695348L, -8408072779227891209L, MethodHandles.lookup().lookupClass()).a(166925021861824L);

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.a(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (IrbRubyLanguageConsoleView.this.getProject().isDisposed()) {
                        return;
                    }
                    IrbRubyLanguageConsoleView.this.setConsoleEditorEnabled(false);
                });
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x35D5591B6FE5L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/console/config/IrbRubyLanguageConsoleView$2", "processTerminated"));
            }
        });
        if (processHandler instanceof RubyConsoleProcessHandlerEx) {
            ((RubyConsoleProcessHandlerEx)processHandler).setConsole(this);
        }
        this.d.setProcessHandler(processHandler);
        this.b = processHandler;
    }

    private ProcessBackedConsoleExecuteActionHandler a(final boolean bl2) {
        return new ProcessBackedConsoleExecuteActionHandler(null, false){
            private static final long a = la.a(-5327466814543439501L, 8617436195962564693L, MethodHandles.lookup().lookupClass()).a(210730451717758L);

            public void processLine(@NotNull String line) {
                long l2 = a ^ 0x210CDE84E615L;
                if (line == null) {
                    3.a(0);
                }
                if (bl2 && "reload!\n".startsWith(line)) {
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                super.processLine(line);
                IrbRubyLanguageConsoleView.this.inputSent(line + "\n");
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1A5E438D104EL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/ruby/console/config/IrbRubyLanguageConsoleView$3", "processLine"));
            }
        };
    }

    @Override
    public boolean isIrbConsole(@NotNull Module module, @NotNull String irbExecutable) {
        long l2 = h ^ 0x5BADE58AD7C2L;
        if (module == null) {
            IrbRubyLanguageConsoleView.b(1);
        }
        if (irbExecutable == null) {
            IrbRubyLanguageConsoleView.b(2);
        }
        if (!module.equals(this.c)) {
            return false;
        }
        return this.f.equalsIgnoreCase(irbExecutable) && (this.e.contains("--irb") || this.e.contains("--prompt")) || this.f.endsWith("/rails") && this.e.contains("console");
    }

    @Override
    public void executeCode(@NotNull Module module, @NotNull Editor editor, @NotNull VirtualFile file) throws IOException {
        String string;
        SelectionModel selectionModel;
        String string2;
        long l2 = h ^ 0x37C9E8226147L;
        if (module == null) {
            IrbRubyLanguageConsoleView.b(3);
        }
        if (editor == null) {
            IrbRubyLanguageConsoleView.b(4);
        }
        if (file == null) {
            IrbRubyLanguageConsoleView.b(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)(string2 = (selectionModel = editor.getSelectionModel()).getSelectedText()))) {
            FileDocumentManager.getInstance().saveDocument(editor.getDocument());
            string = "load \"" + this.a.convertToRemote(file.getPath()) + "\"";
        } else {
            string = string2;
        }
        ProcessHandler processHandler = this.b;
        assert (processHandler != null);
        OutputStream outputStream = processHandler.getProcessInput();
        if (outputStream != null) {
            outputStream.write((string + "\n").getBytes());
            outputStream.flush();
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = h ^ 0x4558583937C7L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "irbExecutable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/console/config/IrbRubyLanguageConsoleView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isIrbConsole";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

