/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.suppress;

import b.h.la;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressAllForClassCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressForClassCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressForMethodCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressForStatementCommentFix;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySuppressionHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RControlStructureStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RArgumentListNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RGroupedExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RCodeBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RubySuppressionUtil {
    @NonNls
    public static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN;
    private static final long a;

    private RubySuppressionUtil() {
    }

    @NotNull
    public static SuppressQuickFix[] getDefaultSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            RubySuppressionUtil.a(0);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new RubySuppressForStatementCommentFix(toolId), new RubySuppressForMethodCommentFix(toolId), new RubySuppressForClassCommentFix(toolId), new RubySuppressAllForClassCommentFix()};
        if (suppressQuickFixArray == null) {
            RubySuppressionUtil.a(1);
        }
        return suppressQuickFixArray;
    }

    public static boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            RubySuppressionUtil.a(2);
        }
        if (toolId == null) {
            RubySuppressionUtil.a(3);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (element == null) {
                RubySuppressionUtil.a(11);
            }
            if (toolId == null) {
                RubySuppressionUtil.a(12);
            }
            if (RubySuppressionUtil.c(element, toolId) != null) {
                return true;
            }
            if (RubySuppressionUtil.d(element, toolId) != null) {
                return true;
            }
            return RubySuppressionUtil.a(element, toolId) != null;
        });
    }

    @Nullable
    private static PsiComment d(@NotNull PsiElement psiElement, @NotNull String string) {
        if (psiElement == null) {
            RubySuppressionUtil.a(4);
        }
        if (string == null) {
            RubySuppressionUtil.a(5);
        }
        RContainer rContainer = RubyPsiUtil.getParentContainerOrSelf(psiElement);
        while (rContainer instanceof RMethod) {
            PsiComment psiComment = RubySuppressionUtil.a(string, (PsiElement)rContainer);
            if (psiComment != null) {
                return psiComment;
            }
            rContainer = (RContainer)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)rContainer, RContainer.class);
        }
        return null;
    }

    @Nullable
    private static PsiComment a(@NotNull PsiElement psiElement, @NotNull String string) {
        if (psiElement == null) {
            RubySuppressionUtil.a(6);
        }
        if (string == null) {
            RubySuppressionUtil.a(7);
        }
        RContainer rContainer = RubyPsiUtil.getParentContainerOrSelf(psiElement);
        while (rContainer instanceof RModule || rContainer instanceof RClass || rContainer instanceof RMethod) {
            PsiComment psiComment;
            if (!(rContainer instanceof RMethod) && (psiComment = RubySuppressionUtil.a(string, (PsiElement)rContainer)) != null) {
                return psiComment;
            }
            rContainer = rContainer.getParentContainer();
        }
        return null;
    }

    @Nullable
    private static PsiComment c(@NotNull PsiElement psiElement, @NotNull String string) {
        PsiElement psiElement2;
        PsiElement psiElement3;
        PsiComment psiComment;
        if (psiElement == null) {
            RubySuppressionUtil.a(8);
        }
        if (string == null) {
            RubySuppressionUtil.a(9);
        }
        if ((psiComment = RubySuppressionUtil.a(string, psiElement3 = RubySuppressionUtil.findEnclosingSuppressibleStatement(psiElement))) != null) {
            return psiComment;
        }
        RControlStructureStatement rControlStructureStatement = (RControlStructureStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RControlStructureStatement.class);
        if (rControlStructureStatement != null && (psiComment = RubySuppressionUtil.a(string, psiElement2 = RubySuppressionUtil.findEnclosingSuppressibleStatement((PsiElement)rControlStructureStatement))) != null) {
            return psiComment;
        }
        return null;
    }

    @Nullable
    private static PsiComment a(@NotNull String string, @Nullable PsiElement psiElement) {
        if (string == null) {
            RubySuppressionUtil.a(10);
        }
        if (psiElement != null) {
            List<PsiComment> list2 = RubyCommentsUtil.getPsiComments(psiElement);
            for (PsiComment psiComment : list2) {
                String string2 = psiComment.getText();
                Matcher matcher = SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(string2);
                if (!matcher.matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)string)) continue;
                return psiComment;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findEnclosingSuppressibleStatement(@Nullable PsiElement element) {
        long l2 = a ^ 0x40D161B2EF9CL;
        if (element == null) {
            return null;
        }
        PsiElement psiElement = element;
        psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, RubySuppressionHolder.class, (boolean)false);
        while (psiElement != null) {
            RGroupedExpression rGroupedExpression;
            RArgumentList rArgumentList;
            RBlockCall rBlockCall;
            if (psiElement instanceof RIdentifier && ((RIdentifier)psiElement).isBlockParameterDeclaration() && (rBlockCall = RBlockCallNavigator.getByBlockParameters(rArgumentList = Objects.requireNonNull(RArgumentListNavigator.getByArgumentContents((RPsiElement)psiElement), "Guaranteed by UsageAnalyzer.isBlockParameter"))) != null) {
                return rBlockCall;
            }
            rArgumentList = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{RArgumentList.class, RArray.class, RAssoc.class});
            if (rArgumentList != null) {
                psiElement = PsiTreeUtil.getParentOfType((PsiElement)rArgumentList, RubySuppressionHolder.class, (boolean)true);
                continue;
            }
            rBlockCall = psiElement.getParent();
            if (rBlockCall instanceof RCompoundStatement && (rGroupedExpression = RCodeBlockNavigator.getByBlockCmsSt((RCompoundStatement)rBlockCall)) instanceof RBraceCodeBlock && !rGroupedExpression.getText().contains("\n")) {
                psiElement = rGroupedExpression;
                continue;
            }
            rGroupedExpression = RGroupedExpressionNavigator.getByExpression((PsiElement)rBlockCall);
            if (rGroupedExpression == null && !(rBlockCall instanceof RubySuppressionHolder)) {
                return psiElement;
            }
            psiElement = rBlockCall;
        }
        return psiElement;
    }

    static {
        a = la.a(-4112886646158100557L, 2053134467889678580L, MethodHandles.lookup().lookupClass()).a(138544265831838L);
        long l2 = a ^ 0x23405CD8FAC7L;
        SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("#\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6F3487C501BFL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/suppress/RubySuppressionUtil";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/suppress/RubySuppressionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSuppressActions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSuppressActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInModuleOrClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionComment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSuppressedFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

