/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPathMappingsUtil {
    public static String replaceStarForMapping(@NotNull String mapping, @Nullable String matchedStar) {
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(0);
        }
        return matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
    }

    @Nullable
    public static <T extends JSModulePattern> Pair<T, String> findMaxElementByPaths(@NotNull String textToMatch, @NotNull Collection<? extends T> paths) {
        if (textToMatch == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(1);
        }
        if (paths == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(2);
        }
        Pair matchedElement = null;
        int longestMatchPrefixLength = -1;
        for (JSModulePattern path : paths) {
            String suffix;
            String pattern = path.getPattern();
            int prefixMatchIndex = pattern.indexOf("*");
            int suffixMatchIndex = prefixMatchIndex + 1;
            if (path.canStartWith()) {
                suffixMatchIndex = prefixMatchIndex = pattern.length();
            }
            if (prefixMatchIndex == -1) {
                if (!pattern.equals(textToMatch)) continue;
                return Pair.create((Object)path, null);
            }
            String prefix = pattern.substring(0, prefixMatchIndex);
            if (!JSPathMappingsUtil.checkPrefix(textToMatch, prefix, suffix = pattern.substring(suffixMatchIndex)) || prefix.length() <= longestMatchPrefixLength) continue;
            longestMatchPrefixLength = prefix.length();
            matchedElement = Pair.create((Object)path, (Object)textToMatch.substring(prefix.length(), textToMatch.length() - suffix.length()));
        }
        return matchedElement;
    }

    private static boolean checkPrefix(@NotNull String unquotedRefText, @NotNull String prefix, @NotNull String suffix) {
        if (unquotedRefText == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(5);
        }
        return unquotedRefText.length() >= prefix.length() + suffix.length() && unquotedRefText.startsWith(prefix) && unquotedRefText.endsWith(suffix);
    }

    public static boolean isPatternOrMappingEndsWithStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(6);
        }
        return patternOrMapping.endsWith("/*") || patternOrMapping.endsWith("\\*");
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(7);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(8);
        }
        if (FileUtil.isAbsolute((String)mapping)) {
            return LocalFileSystem.getInstance().findFileByPath(mapping);
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrl(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(9);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(10);
        }
        String path = FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)mapping), (char)'/');
        return baseUrl.isValid() ? VfsUtil.findRelativeFile((VirtualFile)baseUrl, (String[])ArrayUtil.toStringArray((Collection)StringUtil.split((String)path, (String)"/"))) : null;
    }

    public static String getPatternOrMappingWithoutStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(11);
        }
        int length = patternOrMapping.length();
        return patternOrMapping.endsWith("*") ? patternOrMapping.substring(0, patternOrMapping.length() > 2 ? length - 2 : 1) : patternOrMapping;
    }

    public static Collection<String> getMappings(@NotNull JSModulePathSubstitution matchedPattern, String matchedStar, boolean endsWithStar) {
        if (matchedPattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(12);
        }
        String pattern = matchedPattern.getPattern();
        boolean patternEndsWithStart = matchedStar != null && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || matchedPattern.canStartWith());
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String mapping : matchedPattern.getMappings()) {
            boolean mappingEndsWithStar = patternEndsWithStart && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(mapping) || matchedPattern.canStartWith());
            if (mappingEndsWithStar != endsWithStar) continue;
            result2.add(mapping);
        }
        return result2;
    }

    @NotNull
    public static String getStringPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(13);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(14);
        }
        if (FileUtil.isAbsolute((String)mapping)) {
            String string = mapping;
            if (string == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        String canonicalUrl = baseUrl.getPath();
        String canonicalMapping = FileUtil.toSystemIndependentName((String)mapping);
        String string = FileUtil.toCanonicalPath((String)(canonicalUrl + "/" + (canonicalMapping.startsWith("/") ? canonicalMapping.substring(1) : canonicalMapping)), (char)'/');
        if (string == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static VirtualFile getRelativeOrAbsoluteFilePath(@NotNull String path, VirtualFile baseDir) {
        if (path == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return baseDir;
        }
        String normalizedPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path));
        if (StringUtil.isEmpty((String)normalizedPath)) {
            return baseDir;
        }
        if (!FileUtil.isAbsolute((String)path)) {
            return VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])ArrayUtil.toStringArray((Collection)StringUtil.split((String)normalizedPath, (String)"/")));
        }
        return LocalFileSystem.getInstance().findFileByPath(normalizedPath);
    }

    @NotNull
    public static JSModulePattern createPatternForString(final @NotNull String partOfString) {
        if (partOfString == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(18);
        }
        JSModulePattern jSModulePattern = new JSModulePattern(){

            @Override
            @NotNull
            public String getPattern() {
                String string = partOfString;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean canStartWith() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil$1", "getPattern"));
            }
        };
        if (jSModulePattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(19);
        }
        return jSModulePattern;
    }

    public static AsteriskCount hasZeroOrOneAsteriskCharacter(String str) {
        boolean seenAsterisk = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '*') continue;
            if (!seenAsterisk) {
                seenAsterisk = true;
                continue;
            }
            return AsteriskCount.MORE;
        }
        return seenAsterisk ? AsteriskCount.ONE : AsteriskCount.ZERO;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToMatch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternOrMapping";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedPattern";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partOfString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternForString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceStarForMapping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findMaxElementByPaths";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPatternOrMappingEndsWithStar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrMappingWithoutStar";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeOrAbsoluteFilePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createPatternForString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AsteriskCount {
        ZERO,
        ONE,
        MORE;

    }
}

