/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericApplyingContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Getter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSGenericTypesEvaluatorBase
implements JSGenericTypesEvaluator {
    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExplicitThisParameterType(@NotNull Getter<? extends JSType> qualifierType, @Nullable PsiElement resolvedFunction) {
        if (qualifierType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(0);
        }
        if (!(resolvedFunction instanceof TypeScriptFunction)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(1);
            }
            return jSTypeSubstitutor;
        }
        JSType definedType = ((TypeScriptFunction)resolvedFunction).getExplicitThisType();
        if (JSTypeUtils.hasForeignGenericParameter(definedType)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues((JSType)qualifierType.get(), definedType, resolvedFunction);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(2);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(3);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected Function.Mono<JSType> getJSQualifierGenericsRemapper(@Nullable JSExpression methodExpression) {
        JSExpression qualifier;
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            Function.Mono mono = type -> JSGenericTypesEvaluatorBase.evaluateJSGenericsFromQualifier(type, qualifier);
            if (mono == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(4);
            }
            return mono;
        }
        Function.Mono mono = Functions.id();
        if (mono == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(5);
        }
        return mono;
    }

    @NotNull
    protected static JSTypeSubstitutor getDefaultTypeSubstitutor(@NotNull PsiElement typeParametersOwner, @NotNull JSCallExpression expression) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(7);
        }
        if (JSTypeUtils.hasTypeArguments(expression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(8);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters(typeParametersOwner);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(9);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected static JSTypeSubstitutor getSubstitutorForDefaultParameters(@NotNull PsiElement typeParametersOwner) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(10);
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(11);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(12);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name = parameter.getName();
            if (name == null) continue;
            JSTypeSubstitutor.JSTypeGenericId id = TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter);
            JSType type = JSGenericTypesEvaluatorBase.getTypeParameterDefaultType(parameter);
            substitutor.put(id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(13);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected static Set<JSTypeSubstitutor.JSTypeGenericId> getGenericNames(@Nullable PsiElement resolvedFunction) {
        if (resolvedFunction instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(resolvedFunction);
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Arrays.stream(parameters).map(p -> TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)p)).collect(Collectors.toSet());
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(14);
            }
            return set;
        }
        Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
        if (set == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(15);
        }
        return set;
    }

    protected static void addGenericDependencyFromType(final @NotNull Set<JSTypeSubstitutor.JSTypeGenericId> generics, final @NotNull MultiMap<Integer, JSTypeSubstitutor.JSTypeGenericId> results, final int ownName, @Nullable JSType type) {
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(16);
        }
        if (results == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(17);
        }
        if (type == null) {
            return;
        }
        type.accept(new JSRecursiveTypeVisitor(){

            public void visitJSType(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type instanceof JSGenericParameterImpl && generics.contains(((JSGenericParameterImpl)type).getGenericId())) {
                    results.putValue((Object)ownName, (Object)((JSGenericParameterImpl)type).getGenericId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase$1", "visitJSType"));
            }
        });
    }

    @NotNull
    protected static Integer[] reorderByDependencies(int argumentsLength, @NotNull List<? extends JSType> parameterTypes, @NotNull Set<JSTypeSubstitutor.JSTypeGenericId> generics) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(18);
        }
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(19);
        }
        Integer[] result2 = new Integer[argumentsLength];
        MultiMap results = new MultiMap();
        for (int i = 0; i < argumentsLength; ++i) {
            result2[i] = i;
            if (i >= parameterTypes.size()) continue;
            JSGenericTypesEvaluatorBase.addGenericDependencyFromType(generics, (MultiMap<Integer, JSTypeSubstitutor.JSTypeGenericId>)results, i, parameterTypes.get(i));
        }
        Arrays.sort(result2, (r1, r2) -> {
            Collection all2;
            Collection all1 = results.get(r1);
            if (all1 == (all2 = results.get(r2))) {
                return 0;
            }
            return all1.stream().anyMatch(i -> all2.contains(i)) ? -1 : 1;
        });
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(20);
        }
        return result2;
    }

    @NotNull
    protected static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        TypeScriptType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(21);
        }
        if ((defaultType = parameter.getDefault()) == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSType jSType = defaultType == null ? JSAnyType.get((PsiElement)parameter, true) : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)defaultType);
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @Contract(value="null->false")
    protected static boolean canHaveGenericParameters(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSUtilType) {
            return type instanceof JSArrayType || type instanceof JSFunctionType;
        }
        return true;
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, @NotNull Collection<JSTypeSubstitutor.JSTypeGenericId> explicitArguments, int paramToSkip) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(23);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(24);
        }
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(25);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        if (paramToSkip == -1) {
            result2.putAll(JSGenericTypesEvaluatorBase.getDefaultTypeSubstitutor(resolvedFunction, callExpression));
        }
        if (resolvedFunction instanceof JSFunctionItem) {
            JSExpression[] arguments = callExpression.getArguments();
            List<JSType> parameterTypes = JSGenericTypesEvaluatorBase.getParameterTypesForInference(((JSFunctionItem)resolvedFunction).getParameters(), 0, arguments.length);
            Condition<JSType> condition = JSGenericTypesEvaluatorBase.getExcludeExplicitArgumentsCondition(explicitArguments);
            result2.putAll(this.getTypeSubstitutorForReturnType(resolvedFunction, callExpression, condition));
            MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, arguments, paramToSkip, resolvedFunction, condition);
            result2.putAll(JSGenericTypesEvaluatorBase.intersectGenericsForCall(genericArguments, resolvedFunction, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(26);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static Condition<JSType> getExcludeExplicitArgumentsCondition(@NotNull Collection<JSTypeSubstitutor.JSTypeGenericId> explicitArguments) {
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(27);
        }
        Condition condition = type -> {
            if (explicitArguments == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(96);
            }
            return type instanceof JSGenericParameterImpl && !explicitArguments.contains(((JSGenericParameterImpl)type).getGenericId());
        };
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(28);
        }
        return condition;
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutorForReturnType(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @NotNull Condition<? super JSType> condition) {
        JSType returnType;
        JSFunction function;
        PsiElement typeElement;
        if (resolvedFunction == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(29);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(30);
        }
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(31);
        }
        if (resolvedFunction instanceof JSFunction && (typeElement = (function = (JSFunction)resolvedFunction).getReturnTypeElement()) != null && JSTypeUtils.hasTypes(returnType = function.getReturnType(), false, condition)) {
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)callExpression, JSExpectedTypeKind.CONTEXTUAL);
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues(expectedType, returnType, resolvedFunction);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(32);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(33);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForTaggedTemplateCall(@NotNull PsiElement resolvedFunction, @NotNull ES6TaggedTemplateExpression template, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, @NotNull Collection<JSTypeSubstitutor.JSTypeGenericId> explicitArguments, int paramToSkip) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(34);
        }
        if (template == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(35);
        }
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(36);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        result2.putAll(JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters(resolvedFunction));
        if (resolvedFunction instanceof JSFunctionItem) {
            JSStringTemplateExpression templateExpression = template.getTemplateExpression();
            JSExpression[] arguments = templateExpression != null ? templateExpression.getArguments() : JSExpression.EMPTY_ARRAY;
            List<JSType> parameterTypes = JSGenericTypesEvaluatorBase.getParameterTypesForInference(((JSFunctionItem)resolvedFunction).getParameters(), 1, arguments.length);
            int callArgumentToSkip = paramToSkip == -1 ? -1 : paramToSkip - 1;
            Condition<JSType> condition = JSGenericTypesEvaluatorBase.getExcludeExplicitArgumentsCondition(explicitArguments);
            MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, arguments, callArgumentToSkip, resolvedFunction, condition);
            result2.putAll(JSGenericTypesEvaluatorBase.intersectGenericsForCall(genericArguments, resolvedFunction, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(37);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getParameterTypesForInference(@NotNull JSParameterItem[] parameters, int formalParametersToSkip, int argumentsLength) {
        int i;
        if (parameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(38);
        }
        List parameterTypes = ContainerUtil.newSmartList();
        JSType restParameterType = null;
        for (i = 0; i < parameters.length; ++i) {
            if (i < formalParametersToSkip) continue;
            JSParameterItem parameter = parameters[i];
            JSType parameterType = parameter.getType();
            parameterTypes.add(parameterType);
            if (!parameter.isRest()) continue;
            restParameterType = parameterType;
        }
        if (restParameterType != null && argumentsLength > parameterTypes.size()) {
            for (i = parameterTypes.size(); i < argumentsLength; ++i) {
                parameterTypes.add(restParameterType);
            }
        }
        List list = parameterTypes;
        if (list == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(39);
        }
        return list;
    }

    private static JSTypeSubstitutor intersectGenericsForCall(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> map, @NotNull PsiElement context, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (map == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(40);
        }
        if (context == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(41);
        }
        JSTypeSubstitutor result2 = JSGenericTypesEvaluatorBase.intersectGenerics(map, context, reporter);
        for (Map.Entry entry : map.entrySet()) {
            Collection types;
            JSTypeSubstitutor.JSTypeGenericId key = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            if (!result2.containsId(key) || (types = (Collection)entry.getValue()) == null || !types.stream().allMatch(t -> t instanceof JSLiteralType)) continue;
            result2.put(key, (JSType)(types.size() == 1 ? (JSType)types.iterator().next() : new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource(context, true), ContainerUtil.newArrayList((Iterable)types))));
        }
        return result2;
    }

    @NotNull
    protected static JSTypeSubstitutor intersectGenerics(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> map, @Nullable PsiElement context, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (map == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(42);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        ProcessingContext processingContext = context == null ? null : JSTypeComparingContextService.getProcessingContextWithCache(context);
        for (Map.Entry entry : map.entrySet()) {
            Collection rawTypes = (Collection)entry.getValue();
            assert (rawTypes.size() > 0);
            JSTypeSubstitutor.JSTypeGenericId parameterName = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            JSGenericTypesEvaluatorBase.addTypesForParameter(rawTypes, parameterName, result2, processingContext, reporter);
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(43);
        }
        return jSTypeSubstitutor;
    }

    private static void addTypesForParameter(@NotNull Collection<JSType> rawTypes, @NotNull JSTypeSubstitutor.JSTypeGenericId parameterId, @NotNull JSTypeSubstitutor result2, @Nullable ProcessingContext processingContext, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (rawTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(44);
        }
        if (parameterId == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(45);
        }
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(46);
        }
        if (rawTypes.size() == 0) {
            return;
        }
        if (rawTypes.size() == 1) {
            result2.put(parameterId, (JSType)ContainerUtil.getFirstItem(rawTypes));
            return;
        }
        boolean hasImplicitly = JSGenericTypesEvaluatorBase.checkImplicitFlags(rawTypes);
        List typesWithoutGenerics = ContainerUtil.filter(rawTypes, el -> !(el instanceof JSGenericParameterImpl) && el != null && !JSCompositeTypeBaseImpl.isNullOrUndefinedType(el));
        List typesToIntersect = typesWithoutGenerics.isEmpty() ? rawTypes : typesWithoutGenerics;
        JSType type = JSGenericTypesEvaluatorBase.intersectTypes(typesToIntersect, processingContext);
        if (type != null) {
            result2.put(parameterId, type);
            return;
        }
        if (hasImplicitly) {
            return;
        }
        if (typesWithoutGenerics.size() > 0) {
            result2.put(parameterId, (JSType)typesWithoutGenerics.get(0));
            if (reporter != null && typesWithoutGenerics.size() > 1) {
                reporter.error("typescript.validation.cannot.find.best.common.type");
            }
        }
    }

    private static boolean checkImplicitFlags(@NotNull Collection<JSType> types) {
        if (types == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(47);
        }
        boolean hasImplicitly = false;
        for (JSType type : types) {
            JSType valuableType = JSTypeUtils.getValuableType(type);
            if (valuableType != null && valuableType.isSourceStrict()) continue;
            hasImplicitly = true;
            break;
        }
        return hasImplicitly;
    }

    @Nullable
    private static JSType intersectTypes(@NotNull Collection<JSType> types, @Nullable ProcessingContext context) {
        if (types == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(48);
        }
        ArrayList sortedTypes = ContainerUtil.newArrayList(types);
        ContainerUtil.sort((List)sortedTypes, Comparator.comparing(el -> el instanceof JSLiteralType && ((JSLiteralType)el).allowWidening() ? 1 : 0));
        JSType firstNamed = null;
        for (JSType type : sortedTypes) {
            JSType currentType;
            JSTypeSource source;
            if (firstNamed == null && type instanceof JSNamedType) {
                firstNamed = type;
            }
            if (type == null || (source = type.getSource()).isTypeScript() && !(currentType = JSTypeUtils.getValuableType(type)).getSource().isStrict()) continue;
            boolean result2 = true;
            for (JSType jsType : types) {
                if (jsType == type || type.isDirectlyAssignableType(jsType, context)) continue;
                result2 = false;
                break;
            }
            if (!result2) continue;
            return type;
        }
        return null;
    }

    @NotNull
    protected final MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> inferGenericArgumentsFromCall(@NotNull List<? extends JSType> parameterTypes, @NotNull JSExpression[] arguments, int callArgumentToSkip, @Nullable PsiElement resolvedFunction, @NotNull Condition<? super JSType> acceptableGenericArguments) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(49);
        }
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(50);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(51);
        }
        List argumentProviders = Arrays.stream(arguments).map(el -> () -> callArgumentToSkip == -1 ? TypeScriptGenericTypesEvaluator.getParameterExpressionType(el, false) : JSGenericTypesEvaluatorBase.getContextualParameterType(el, resolvedFunction)).collect(Collectors.toList());
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> multiMap = this.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, callArgumentToSkip, resolvedFunction, acceptableGenericArguments);
        if (multiMap == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(52);
        }
        return multiMap;
    }

    private static JSType getContextualParameterType(@NotNull JSExpression expression, @Nullable PsiElement resolvedFunction) {
        if (expression == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(53);
        }
        if (resolvedFunction == null) {
            return TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression, false);
        }
        return TypeScriptSignatureChooser.mapContextualTypeForOverload(TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression, true), resolvedFunction);
    }

    @NotNull
    public final MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> inferGenericArgumentsFromCall(@NotNull List<? extends JSType> parameterTypes, @NotNull List<? extends Supplier<JSType>> arguments, int callArgumentToSkip, @Nullable PsiElement resolvedFunction, @NotNull Condition<? super JSType> acceptableGenericArguments) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(54);
        }
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(55);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(56);
        }
        Set<JSTypeSubstitutor.JSTypeGenericId> generics = JSGenericTypesEvaluatorBase.getGenericNames(resolvedFunction);
        Integer[] newIndices = JSGenericTypesEvaluatorBase.reorderByDependencies(arguments.size(), parameterTypes, generics);
        MultiMap genericArguments = MultiMap.createSmart();
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(resolvedFunction);
        for (int i = 0; i < arguments.size(); ++i) {
            JSType constraintType;
            int j = newIndices[i];
            if (j == callArgumentToSkip) continue;
            if (j >= parameterTypes.size()) break;
            JSType paramType = parameterTypes.get(j);
            if (paramType instanceof JSTypeofTypeImpl) {
                paramType = paramType.substitute();
            }
            if (!JSTypeUtils.hasTypes(paramType, false, acceptableGenericArguments)) continue;
            JSType exprType = JSGenericTypesEvaluatorBase.getArgType(arguments, j);
            boolean matchedTuples = false;
            if (paramType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)paramType).getConstraintType()) != null && JSTypeUtils.isIterableCollectionType(constraintType)) {
                ArrayList types = ContainerUtil.newArrayList();
                for (int k = i; k < arguments.size(); ++k) {
                    types.add(0, JSTypeUtils.widenLiteralTypes(JSGenericTypesEvaluatorBase.getArgType(arguments, newIndices[k])));
                }
                JSTupleTypeImpl tupleType = new JSTupleTypeImpl(paramType.getSource(), types, true, -1);
                JSGenericTypesEvaluatorBase.matchGenericTypes((MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType>)genericArguments, processingContext, tupleType, paramType, resolvedFunction, acceptableGenericArguments);
                matchedTuples = true;
            }
            if (!matchedTuples) {
                JSGenericTypesEvaluatorBase.matchGenericTypes((MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType>)genericArguments, processingContext, exprType, paramType, resolvedFunction, acceptableGenericArguments);
            }
            for (Map.Entry entry : genericArguments.entrySet()) {
                JSTypeSubstitutor.JSTypeGenericId key = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
                Collection types = (Collection)entry.getValue();
                if (types.size() != 1) continue;
                substitutor.put(key, (JSType)types.iterator().next());
            }
            if (matchedTuples) break;
        }
        MultiMap multiMap = genericArguments;
        if (multiMap == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(57);
        }
        return multiMap;
    }

    @Nullable
    private static JSType getArgType(@NotNull List<? extends Supplier<JSType>> arguments, int index) {
        JSType exprType;
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(58);
        }
        if ((exprType = arguments.get(index).get()) != null && exprType.isTypeScript()) {
            PsiElement sourceElement = exprType.getSource().getSourceElement();
            exprType = sourceElement != null ? TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(sourceElement, exprType) : exprType;
        }
        return exprType;
    }

    @NotNull
    protected static JSTypeSubstitutor findAndIntersectGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> generics = JSGenericTypesEvaluatorBase.findGenericsTypeValues(exprType, paramType, context);
        if (!generics.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.intersectGenerics(generics, context, null);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(59);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(60);
        }
        return jSTypeSubstitutor;
    }

    protected static MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        if (exprType == null || paramType == null) {
            return MultiMap.empty();
        }
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(context);
        JSGenericTypesEvaluatorBase.matchGenericTypes((MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType>)genericArguments, processingContext, exprType, paramType, null);
        return genericArguments;
    }

    public static void matchGenericTypes(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType, @Nullable PsiElement invokedElement) {
        if (genericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(61);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(62);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(63);
        }
        JSGenericTypesEvaluatorBase.matchGenericTypes(genericArguments, processingContext, exprType, paramType, invokedElement, (Condition<? super JSType>)Conditions.alwaysTrue());
    }

    public static void matchGenericTypes(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType, @Nullable PsiElement invokedElement, @NotNull Condition<? super JSType> acceptableGenericArguments) {
        THashSet withWidening;
        List<JSGenericParameterImpl> topLevelReturnGenerics;
        List<JSGenericParameterImpl> topLevelParamGenerics;
        JSType toCheck;
        if (genericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(64);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(65);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(66);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(67);
        }
        JSType returnType = null;
        if (invokedElement instanceof JSFunctionItem) {
            returnType = ((JSFunctionItem)invokedElement).getReturnType();
        }
        if (paramType == (toCheck = paramType.transformTypeHierarchy(arg_0 -> JSGenericTypesEvaluatorBase.lambda$matchGenericTypes$12(acceptableGenericArguments, topLevelParamGenerics = JSGenericTypesEvaluatorBase.getTopLevelGenerics(paramType), topLevelReturnGenerics = JSGenericTypesEvaluatorBase.getTopLevelGenerics(returnType), (Set)(withWidening = ContainerUtil.newTroveSet()), arg_0)))) {
            return;
        }
        JSGenericApplyingContext applyingContext = new JSGenericApplyingContext(genericArguments, (Set<JSResolvedTypeId>)withWidening);
        processingContext.put(ourGenericArgumentsMapKey, (Object)applyingContext);
        toCheck.isDirectlyAssignableType(exprType, processingContext);
        processingContext.put(ourGenericArgumentsMapKey, null);
    }

    @NotNull
    private static List<JSGenericParameterImpl> getTopLevelGenerics(@Nullable JSType paramType) {
        ArrayList topLevelGenerics = ContainerUtil.newArrayList();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (t instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)t);
            }
            return true;
        }), paramType);
        ArrayList arrayList = topLevelGenerics;
        if (arrayList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(68);
        }
        return arrayList;
    }

    @NotNull
    private static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier) {
        JSType qualifierType;
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(69);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(70);
        }
        if (type.getSource().isTypeScript()) {
            JSType jSType = type;
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(71);
            }
            return jSType;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSDocComment) {
            namespaceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)namespaceElement);
        }
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file2 = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file2)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                type = JSGenericTypesEvaluatorBase.convertNamedTypesToGenericParameters(type, javaScriptGenericParameters);
            }
        }
        if (JSTypeUtils.hasForeignGenericParameter(type) && javaScriptGenericParameters != null && (qualifierType = JSResolveUtil.getElementJSType((PsiElement)qualifier, JSEvaluateContext.JSEvaluationPlace.QUALIFIER)) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluatorBase.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            JSType jSType = JSTypeUtils.applyGenericArguments(type, typeArguments);
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(72);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(73);
        }
        return jSType;
    }

    @NotNull
    private static JSType convertNamedTypesToGenericParameters(@NotNull JSType type, @NotNull List<String> javaScriptGenericParameters) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(74);
        }
        if (javaScriptGenericParameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(75);
        }
        List<String> genericParameters = javaScriptGenericParameters;
        JSType jSType = type = JSTypeUtils.applyCompositeMapping(type, (Function<JSType, JSType>)((Function)type1 -> {
            if (type1 instanceof JSTypeImpl && genericParameters.contains(type1.getTypeText())) {
                return new JSGenericParameterImpl(type1.getTypeText(), type1.getSource());
            }
            return type1;
        }));
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(76);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        String qName;
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(77);
        }
        if (parentClassNamespace == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(78);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(79);
        }
        if ((qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(80);
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(81);
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(82);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(83);
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(genericType, scope);
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(84);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(85);
        }
        if (parentClassName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(86);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(87);
        }
        if (typeArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(88);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<Object> pathToSuperClass = new ArrayList<Object>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String string : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(string, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(89);
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, typeArguments);
            typeArguments = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(90);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeArgumentsMap(@NotNull JSType genericType, @NotNull GlobalSearchScope scope) {
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(91);
        }
        if (scope == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(92);
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(93);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(94);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ JSType lambda$matchGenericTypes$12(@NotNull Condition acceptableGenericArguments, List topLevelParamGenerics, List topLevelReturnGenerics, Set withWidening, JSType type) {
        JSType constraintType;
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(95);
        }
        if (!(type instanceof JSGenericParameterImpl)) {
            return type;
        }
        JSGenericParameterImpl genericParameter = (JSGenericParameterImpl)type;
        if (!acceptableGenericArguments.value((Object)genericParameter)) {
            return genericParameter;
        }
        genericParameter = genericParameter.copyWithSourceAndApplying(genericParameter.getSource(), true);
        if (topLevelParamGenerics.stream().anyMatch(p -> p.isEquivalentTo(type, null)) && topLevelReturnGenerics.stream().noneMatch(p -> p.isEquivalentTo(type, null)) && !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType = genericParameter.getConstraintType())) {
            withWidening.add(genericParameter.getResolvedTypeId());
        }
        return genericParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersOwner";
                break;
            }
            case 7: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 18: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 23: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunction";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 25: 
            case 27: 
            case 36: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitArguments";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTypes";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 50: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 51: 
            case 56: 
            case 67: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableGenericArguments";
                break;
            }
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 69: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaScriptGenericParameters";
                break;
            }
            case 77: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassNamespace";
                break;
            }
            case 79: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSQualifierGenericsRemapper";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSubstitutor";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "reorderByDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDefaultType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForCall";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForTaggedTemplateCall";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypesForInference";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 52: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndIntersectGenericsTypeValues";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelGenerics";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeSubstitutor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addGenericDependencyFromType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reorderByDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDefaultType";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForCall";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForTaggedTemplateCall";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesForInference";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenericsForCall";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenerics";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addTypesForParameter";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitFlags";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "intersectTypes";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericArgumentsFromCall";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getContextualParameterType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getArgType";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericTypes";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsMap";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lambda$matchGenericTypes$12";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExcludeExplicitArgumentsCondition$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

