/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListTemplatesHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(ListTemplatesHandler.class);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ListTemplatesHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ListTemplatesHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(2);
        }
        EditorUtil.fillVirtualSpaceUntilCaret(editor);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int offset = editor.getCaretModel().getOffset();
        List<TemplateImpl> applicableTemplates = TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(editor, file2, false);
        Map<TemplateImpl, String> matchingTemplates = ListTemplatesHandler.filterTemplatesByPrefix(applicableTemplates, editor, offset, false, true);
        MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements = ListTemplatesHandler.getCustomTemplatesLookupItems(editor, file2, offset);
        if (matchingTemplates.isEmpty()) {
            for (TemplateImpl template : applicableTemplates) {
                matchingTemplates.put(template, null);
            }
        }
        if (matchingTemplates.isEmpty() && customTemplatesLookupElements.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"templates.no.defined", (Object[])new Object[0]));
            }
            return;
        }
        ListTemplatesHandler.showTemplatesLookup(project, editor, file2, matchingTemplates, customTemplatesLookupElements);
    }

    public static Map<TemplateImpl, String> filterTemplatesByPrefix(@NotNull Collection<? extends TemplateImpl> templates, @NotNull Editor editor, int offset, boolean fullMatch, boolean searchInDescription) {
        if (templates == null) {
            ListTemplatesHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ListTemplatesHandler.$$$reportNull$$$0(4);
        }
        if (offset > editor.getDocument().getTextLength()) {
            LOG.error("Cannot filter templates, index out of bounds. Offset: " + offset, new Attachment[]{AttachmentFactory.createAttachment(editor.getDocument())});
        }
        CharSequence documentText = editor.getDocument().getCharsSequence().subSequence(0, offset);
        String prefixWithoutDots = ListTemplatesHandler.computeDescriptionMatchingPrefix(editor.getDocument(), offset);
        Pattern prefixSearchPattern = Pattern.compile(".*\\b" + prefixWithoutDots + ".*");
        TreeMap<TemplateImpl, String> matchingTemplates = new TreeMap<TemplateImpl, String>(TemplateListPanel.TEMPLATE_COMPARATOR);
        for (TemplateImpl templateImpl : templates) {
            block6: {
                String templateKey;
                block5: {
                    ProgressManager.checkCanceled();
                    templateKey = templateImpl.getKey();
                    if (!fullMatch) break block5;
                    int startOffset = documentText.length() - templateKey.length();
                    if (startOffset > 0 && Character.isJavaIdentifierPart(documentText.charAt(startOffset - 1)) || !StringUtil.endsWith((CharSequence)documentText, (CharSequence)templateKey)) break block6;
                    matchingTemplates.put(templateImpl, templateKey);
                    break block6;
                }
                for (int i = templateKey.length(); i > 0; --i) {
                    ProgressManager.checkCanceled();
                    String prefix = templateKey.substring(0, i);
                    int startOffset = documentText.length() - i;
                    if (startOffset > 0 && Character.isJavaIdentifierPart(documentText.charAt(startOffset - 1)) || !StringUtil.endsWith((CharSequence)documentText, (CharSequence)prefix)) continue;
                    matchingTemplates.put(templateImpl, prefix);
                    break;
                }
            }
            if (!searchInDescription || matchingTemplates.containsKey(templateImpl)) continue;
            String templateDescription = templateImpl.getDescription();
            if (prefixWithoutDots.isEmpty() || templateDescription == null || !prefixSearchPattern.matcher(templateDescription).matches()) continue;
            matchingTemplates.put(templateImpl, prefixWithoutDots);
        }
        return matchingTemplates;
    }

    private static void showTemplatesLookup(Project project, Editor editor, PsiFile file2, @NotNull Map<TemplateImpl, String> matchingTemplates, @NotNull MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements) {
        if (matchingTemplates == null) {
            ListTemplatesHandler.$$$reportNull$$$0(5);
        }
        if (customTemplatesLookupElements == null) {
            ListTemplatesHandler.$$$reportNull$$$0(6);
        }
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new TemplatesArranger());
        for (Map.Entry<TemplateImpl, String> entry : matchingTemplates.entrySet()) {
            TemplateImpl template = entry.getKey();
            lookup.addItem(ListTemplatesHandler.createTemplateElement(template), (PrefixMatcher)new PlainPrefixMatcher(StringUtil.notNullize((String)entry.getValue())));
        }
        for (Map.Entry<TemplateImpl, String> entry : customTemplatesLookupElements.entrySet()) {
            for (CustomLiveTemplateLookupElement lookupElement : (Collection)((Object)entry.getValue())) {
                lookup.addItem(lookupElement, (PrefixMatcher)new PlainPrefixMatcher((String)((Object)entry.getKey())));
            }
        }
        ListTemplatesHandler.showLookup(lookup, file2);
    }

    public static MultiMap<String, CustomLiveTemplateLookupElement> getCustomTemplatesLookupItems(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        if (editor == null) {
            ListTemplatesHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(8);
        }
        MultiMap result2 = MultiMap.create();
        CustomTemplateCallback customTemplateCallback = new CustomTemplateCallback(editor, file2);
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(editor, file2, false)) {
            String customTemplatePrefix;
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || (customTemplatePrefix = ((CustomLiveTemplateBase)customLiveTemplate).computeTemplateKeyWithoutContextChecking(customTemplateCallback)) == null) continue;
            result2.putValues((Object)customTemplatePrefix, ((CustomLiveTemplateBase)customLiveTemplate).getLookupElements(file2, editor, offset));
        }
        return result2;
    }

    private static LiveTemplateLookupElement createTemplateElement(final TemplateImpl template) {
        return new LiveTemplateLookupElementImpl(template, false){

            public Set<String> getAllLookupStrings() {
                String description = template.getDescription();
                if (description == null) {
                    return super.getAllLookupStrings();
                }
                return ContainerUtil.newHashSet((Object[])new String[]{this.getLookupString(), description});
            }
        };
    }

    private static String computePrefix(TemplateImpl template, String argument) {
        String key = template.getKey();
        if (argument == null) {
            return key;
        }
        if (key.length() > 0 && Character.isJavaIdentifierPart(key.charAt(key.length() - 1))) {
            return key + ' ' + argument;
        }
        return key + argument;
    }

    public static void showTemplatesLookup(Project project, Editor editor, Map<TemplateImpl, String> template2Argument) {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        for (TemplateImpl template : template2Argument.keySet()) {
            String prefix = ListTemplatesHandler.computePrefix(template, template2Argument.get(template));
            lookup.addItem(ListTemplatesHandler.createTemplateElement(template), (PrefixMatcher)new PlainPrefixMatcher(prefix));
        }
        ListTemplatesHandler.showLookup(lookup, template2Argument);
    }

    private static void showLookup(LookupImpl lookup, @Nullable Map<TemplateImpl, String> template2Argument) {
        lookup.addLookupListener(new MyLookupAdapter(template2Argument));
        lookup.refreshUi(false, true);
        lookup.showLookup();
    }

    private static void showLookup(LookupImpl lookup, @NotNull PsiFile file2) {
        if (file2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(9);
        }
        lookup.addLookupListener(new MyLookupAdapter(file2));
        lookup.refreshUi(false, true);
        lookup.showLookup();
    }

    private static String computeDescriptionMatchingPrefix(Document document, int offset) {
        CharSequence chars = document.getCharsSequence();
        int start2 = offset;
        while (true) {
            char c;
            ProgressManager.checkCanceled();
            if (start2 == 0 || !Character.isJavaIdentifierPart(c = chars.charAt(start2 - 1))) break;
            --start2;
        }
        return chars.subSequence(start2, offset).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingTemplates";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customTemplatesLookupElements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/ListTemplatesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "filterTemplatesByPrefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showTemplatesLookup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomTemplatesLookupItems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showLookup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TemplatesArranger
    extends LookupArranger {
        private TemplatesArranger() {
        }

        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                TemplatesArranger.$$$reportNull$$$0(0);
            }
            LinkedHashSet<LookupElement> result2 = new LinkedHashSet<LookupElement>();
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!item.getLookupString().startsWith(lookup.itemPattern(item))) continue;
                result2.add(item);
            }
            result2.addAll(items);
            ArrayList list2 = new ArrayList(result2);
            int selected = lookup.isSelectionTouched() ? list2.indexOf(lookup.getCurrentItem()) : 0;
            return new Pair(list2, (Object)(selected >= 0 ? selected : 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new TemplatesArranger();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$TemplatesArranger", "arrangeItems"));
        }
    }

    private static class MyLookupAdapter
    implements LookupListener {
        private final Map<TemplateImpl, String> myTemplate2Argument;
        private final PsiFile myFile;

        MyLookupAdapter(@Nullable Map<TemplateImpl, String> template2Argument) {
            this.myTemplate2Argument = template2Argument;
            this.myFile = null;
        }

        MyLookupAdapter(@Nullable PsiFile file2) {
            this.myTemplate2Argument = null;
            this.myFile = file2;
        }

        public void itemSelected(@NotNull LookupEvent event) {
            if (event == null) {
                MyLookupAdapter.$$$reportNull$$$0(0);
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.liveTemplates");
            LookupElement item = event.getItem();
            Lookup lookup = event.getLookup();
            Project project = lookup.getProject();
            if (item instanceof LiveTemplateLookupElementImpl) {
                TemplateImpl template = ((LiveTemplateLookupElementImpl)item).getTemplate();
                String argument = this.myTemplate2Argument != null ? this.myTemplate2Argument.get(template) : null;
                WriteCommandAction.writeCommandAction((Project)project).run(() -> ((TemplateManagerImpl)TemplateManager.getInstance(project)).startTemplateWithPrefix(lookup.getEditor(), template, null, argument));
            } else if (item instanceof CustomLiveTemplateLookupElement && this.myFile != null) {
                WriteCommandAction.writeCommandAction((Project)project).run(() -> ((CustomLiveTemplateLookupElement)item).expandTemplate(lookup.getEditor(), this.myFile));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$MyLookupAdapter", "itemSelected"));
        }
    }
}

