/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectFileTreeModel
extends BaseTreeModel<ProjectFileNode>
implements InvokerSupplier {
    private final Invoker invoker;
    private final ProjectFileNodeUpdater updater;
    private final ProjectNode root;

    public ProjectFileTreeModel(@NotNull Project project) {
        if (project == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(0);
        }
        this.invoker = new Invoker.BackgroundThread((Disposable)this);
        this.root = new ProjectNode(project);
        this.updater = new ProjectFileNodeUpdater(project, this.invoker){

            @Override
            protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
                if (updatedFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean filtered = ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.filter != null;
                SmartHashSet nodes = fromRoot || filtered ? null : new SmartHashSet();
                ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.children.forEach(child2 -> {
                    if (updatedFiles == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    child2.invalidateChildren(node -> {
                        Node n;
                        if (updatedFiles == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (!updatedFiles.contains(node.file)) {
                            return true;
                        }
                        if (filtered) {
                            node.resetParentVisibility();
                        }
                        if (nodes == null) {
                            return false;
                        }
                        Node node2 = n = node.file.isDirectory() ? node : node.parent;
                        if (n == null) {
                            return false;
                        }
                        Node p = n.parent;
                        while (p != null) {
                            if (nodes.contains((Object)p)) {
                                return false;
                            }
                            p = p.parent;
                        }
                        nodes.add((Object)n);
                        return false;
                    });
                });
                if (nodes != null) {
                    nodes.forEach(node -> {
                        TreePath path = TreePathUtil.pathToCustomNode(node, child2 -> child2.parent);
                        if (path != null) {
                            ProjectFileTreeModel.this.pathChanged(path);
                        }
                    });
                } else {
                    if (fromRoot) {
                        ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.valid = false;
                    }
                    ProjectFileTreeModel.this.pathChanged(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "updatedFiles";
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateStructure";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$updateStructure$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    public boolean isValidThread() {
        return this.invoker.isValidThread();
    }

    public void onValidThread(@NotNull Runnable task) {
        if (task == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(2);
        }
        this.invoker.runOrInvokeLater(task);
    }

    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getIndexOfChild(Object parent, Object object) {
        Node node = object instanceof Node ? (Node)object : null;
        return node == null || node.parent != parent ? -1 : super.getIndexOfChild(parent, object);
    }

    @Override
    @NotNull
    public List<ProjectFileNode> getChildren(Object object) {
        Node node;
        Node node2 = node = object instanceof Node && this.isValidThread() ? (Node)object : null;
        if (node == null) {
            List<ProjectFileNode> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectFileTreeModel.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<FileNode> children2 = node.getChildren();
        if (children2.isEmpty()) {
            List<ProjectFileNode> list3 = Collections.emptyList();
            if (list3 == null) {
                ProjectFileTreeModel.$$$reportNull$$$0(4);
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        VirtualFileFilter filter = this.root.filter;
        for (FileNode child2 : children2) {
            if (!(child2 instanceof FileNode) || !this.isVisible(child2, filter)) continue;
            result2.add(child2);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private boolean isVisible(@NotNull FileNode node, @Nullable VirtualFileFilter filter) {
        if (node == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(6);
        }
        if (!node.file.isValid() || this.root.project.isDisposed()) {
            return false;
        }
        if (!this.root.showExcludedFiles && ProjectFileIndex.getInstance((Project)this.root.project).isExcluded(node.file)) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        ThreeState visibility = node.visibility;
        if (visibility == ThreeState.NO) {
            return false;
        }
        if (visibility == ThreeState.YES) {
            return true;
        }
        boolean visible = filter.accept(node.file);
        if (!visible && node.file.isDirectory()) {
            List<FileNode> children2 = node.getChildren();
            visible = !children2.stream().allMatch(child2 -> child2.visibility == ThreeState.NO) && (children2.stream().anyMatch(child2 -> child2.visibility == ThreeState.YES) || children2.stream().anyMatch(child2 -> this.isVisible((FileNode)child2, filter)));
        }
        node.visibility = ThreeState.fromBoolean((boolean)visible);
        return visible;
    }

    public void setFilter(@Nullable VirtualFileFilter filter) {
        this.onValidThread(() -> {
            if (this.root.filter == null && filter == null) {
                return;
            }
            this.root.filter = filter;
            this.root.resetVisibility();
            this.pathChanged(null);
        });
    }

    public void setSettings(boolean showExcludedFiles, boolean showModules) {
        this.onValidThread(() -> {
            if (this.root.showExcludedFiles != showExcludedFiles) {
                if (this.root.filter != null) {
                    this.root.resetVisibility();
                }
                this.root.showExcludedFiles = showExcludedFiles;
                this.root.valid = false;
            }
            if (this.root.showModules != showModules) {
                this.root.showModules = showModules;
                this.root.valid = false;
            }
        });
    }

    private void pathChanged(@Nullable TreePath path) {
        this.onValidThread(() -> this.treeStructureChanged(path, null, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileNode
    extends Node
    implements ProjectFileNode {
        final VirtualFile file;
        final Object id;

        FileNode(@NotNull VirtualFile file2, @NotNull Object id) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (id == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            this.file = file2;
            this.id = id;
        }

        @Override
        @NotNull
        public Object getRootID() {
            Object object = this.id;
            if (object == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            return object;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                FileNode.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        public String toString() {
            return this.parent instanceof ProjectNode ? this.file.getPath() : this.file.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<FileNode> oldList) {
            if (oldList == null) {
                FileNode.$$$reportNull$$$0(4);
            }
            this.visibility = ThreeState.NO;
            VirtualFile file2 = this.getVirtualFile();
            if (!file2.isValid()) {
                List<FileNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileNode.$$$reportNull$$$0(5);
                }
                return list2;
            }
            ProjectNode parent = this.findParent(ProjectNode.class);
            if (parent == null) {
                List<FileNode> list3 = Collections.emptyList();
                if (list3 == null) {
                    FileNode.$$$reportNull$$$0(6);
                }
                return list3;
            }
            this.visibility = ThreeState.UNSURE;
            VirtualFile[] children2 = file2.getChildren();
            if (children2 == null || children2.length == 0) {
                List<FileNode> list4 = Collections.emptyList();
                if (list4 == null) {
                    FileNode.$$$reportNull$$$0(7);
                }
                return list4;
            }
            SmartList list5 = new SmartList();
            Mapper mapper = new Mapper(oldList);
            for (VirtualFile child2 : children2) {
                if (child2.is(VFileProperty.SYMLINK) && VfsUtilCore.isInvalidLink((VirtualFile)child2)) continue;
                Object id = this.getRootID();
                AreaInstance area = ProjectFileNode.findArea(child2, parent.project);
                if (area == null || !(id instanceof VirtualFile) && !area.equals(id)) continue;
                list5.add(mapper.apply(child2, id));
            }
            SmartList smartList = list5;
            if (smartList == null) {
                FileNode.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        void invalidateChildren(Predicate<FileNode> validator) {
            if (this.valid || !this.file.isDirectory()) {
                if (validator == null || !validator.test(this)) {
                    validator = null;
                    this.valid = false;
                }
                for (FileNode node : this.children) {
                    node.invalidateChildren(validator);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$FileNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$FileNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootID";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProjectNode
    extends Node {
        volatile VirtualFileFilter filter;
        volatile boolean showExcludedFiles;
        volatile boolean showModules;
        final Project project;

        ProjectNode(@NotNull Project project) {
            if (project == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            this.project = project;
        }

        public String toString() {
            return this.project.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<FileNode> oldList) {
            if (oldList == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            SmartList list2 = new SmartList();
            Mapper mapper = new Mapper(oldList);
            if (this.showModules) {
                ProjectNode.visitContentRoots(this.project, (arg_0, arg_1) -> ProjectNode.lambda$getChildren$0((List)list2, mapper, arg_0, arg_1));
            } else {
                TreeCollector<VirtualFile> collector = TreeCollector.createFileRootsCollector();
                ProjectNode.visitContentRoots(this.project, (file2, area) -> collector.add((VirtualFile)file2));
                collector.get().forEach(arg_0 -> ProjectNode.lambda$getChildren$2((List)list2, mapper, arg_0));
            }
            SmartList smartList = list2;
            if (smartList == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static void visitContentRoots(@Nullable Project project, @NotNull BiConsumer<? super VirtualFile, ? super AreaInstance> consumer) {
            VirtualFile ancestor;
            if (consumer == null) {
                ProjectNode.$$$reportNull$$$0(3);
            }
            if ((ancestor = ProjectFileNode.findBaseDir(project)) != null && project == ProjectFileNode.findArea(ancestor, project)) {
                consumer.accept((VirtualFile)ancestor, (AreaInstance)project);
            }
            if (project != null && !project.isDisposed()) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (module.isDisposed()) continue;
                    for (VirtualFile file2 : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                        consumer.accept((VirtualFile)file2, (AreaInstance)module);
                    }
                }
            }
        }

        private static /* synthetic */ void lambda$getChildren$2(List list2, Mapper mapper, VirtualFile file2) {
            list2.add(mapper.apply(file2, (Object)file2));
        }

        private static /* synthetic */ void lambda$getChildren$0(List list2, Mapper mapper, VirtualFile file2, AreaInstance area) {
            list2.add(mapper.apply(file2, (Object)area));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$ProjectNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$ProjectNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitContentRoots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Node {
        volatile Node parent;
        volatile ThreeState visibility;
        volatile List<FileNode> children = Collections.emptyList();
        volatile boolean valid;

        private Node() {
        }

        @NotNull
        abstract List<FileNode> getChildren(@NotNull List<FileNode> var1);

        final List<FileNode> getChildren() {
            List<FileNode> oldList = this.children;
            if (this.valid) {
                return oldList;
            }
            List<FileNode> newList = this.getChildren(oldList);
            oldList.forEach(node -> {
                node.parent = null;
            });
            newList.forEach(node -> {
                node.parent = this;
            });
            this.children = newList;
            this.valid = true;
            return newList;
        }

        final void resetVisibility() {
            this.visibility = null;
            this.children.forEach(Node::resetVisibility);
        }

        final void resetParentVisibility() {
            Node node = this.parent;
            while (node != null) {
                node.visibility = null;
                node = node.parent;
            }
        }

        final <N> N findParent(Class<N> type) {
            Node node = this;
            while (node != null) {
                if (type.isInstance(node)) {
                    return type.cast(node);
                }
                node = node.parent;
            }
            return null;
        }
    }

    private static final class Mapper
    implements BiFunction<VirtualFile, Object, FileNode> {
        private final HashMap<VirtualFile, FileNode> map;

        Mapper(@NotNull List<? extends FileNode> list2) {
            if (list2 == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            this.map = new HashMap();
            list2.forEach(node -> this.map.put(node.file, (FileNode)node));
        }

        @Override
        @NotNull
        public FileNode apply(VirtualFile file2, Object id) {
            FileNode node = this.map.isEmpty() ? null : this.map.remove(file2);
            FileNode fileNode = node != null && node.id.equals(id) ? node : new FileNode(file2, id);
            if (fileNode == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            return fileNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/project/ProjectFileTreeModel$Mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileTreeModel$Mapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

