/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.GIOP.v1_2;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.GIOP.ServiceContext;

public class ReplyHeader
extends gnu.CORBA.GIOP.v1_0.ReplyHeader {
    public String getStatusString() {
        String s = super.getStatusString();
        if (s != null) {
            return s;
        }
        switch (this.reply_status) {
            case 4: {
                return "moved permanently";
            }
            case 5: {
                return "the alternative addressing mode required";
            }
        }
        return null;
    }

    public void read(AbstractCdrInput in) {
        this.request_id = in.read_ulong();
        this.reply_status = in.read_ulong();
        this.service_context = ServiceContext.readSequence(in);
        in.setCodeSet(CodeSetServiceContext.find(this.service_context));
    }

    public void write(AbstractCdrOutput out) {
        out.write_ulong(this.request_id);
        out.write_ulong(this.reply_status);
        ServiceContext.writeSequence(out, this.service_context);
        out.setCodeSet(CodeSetServiceContext.find(this.service_context));
    }

    public ReplyHeader() {
        this.service_context = new ServiceContext[]{CodeSetServiceContext.STANDARD};
    }
}

