/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.html2.DomHTMLDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLOptionsCollection;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

class DomHTMLCollection
implements HTMLCollection,
HTMLOptionsCollection,
NodeList,
NodeFilter {
    final DomHTMLDocument doc;
    final Node root;
    List nodeNames;
    List attributeNames;
    List results;

    void addNodeName(String name) {
        if (this.nodeNames == null) {
            this.nodeNames = new LinkedList();
        }
        this.nodeNames.add(name);
    }

    void addAttributeName(String name) {
        if (this.attributeNames == null) {
            this.attributeNames = new LinkedList();
        }
        this.attributeNames.add(name);
    }

    public short acceptNode(Node n) {
        if (n.getNodeType() != 1) {
            return 3;
        }
        String localName = n.getLocalName();
        if (localName == null) {
            localName = n.getNodeName();
        }
        if (this.nodeNames != null && !this.acceptName(localName)) {
            return 3;
        }
        if (this.attributeNames != null && !this.acceptAttributes(n.getAttributes())) {
            return 3;
        }
        return 1;
    }

    private final boolean acceptName(String name) {
        Iterator i = this.nodeNames.iterator();
        while (i.hasNext()) {
            String nodeName = (String)i.next();
            if (!nodeName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private final boolean acceptAttributes(NamedNodeMap attrs) {
        Iterator i = this.attributeNames.iterator();
        while (i.hasNext()) {
            String nodeValue;
            String attributeName = (String)i.next();
            Node attr = this.getNamedItem(attrs, attributeName);
            if (attr == null || (nodeValue = attr.getNodeValue()) == null || nodeValue.length() <= 0) continue;
            return true;
        }
        return false;
    }

    private final Node getNamedItem(NamedNodeMap attrs, String name) {
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            Node attr = attrs.item(i);
            String attrName = attr.getLocalName();
            if (attrName == null) {
                attrName = attr.getNodeName();
            }
            if (name.equalsIgnoreCase(attrName)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    void evaluate() {
        NodeIterator i = this.doc.createNodeIterator(this.root, 1, this, true);
        this.results = new ArrayList();
        Node node2 = i.nextNode();
        while (node2 != null) {
            this.results.add(node2);
            node2 = i.nextNode();
        }
    }

    public int getLength() {
        return this.results.size();
    }

    public void setLength(int length) {
        throw new DomDOMException(9);
    }

    public Node item(int index) {
        return (Node)this.results.get(index);
    }

    public Node namedItem(String name) {
        boolean xhtml = false;
        Iterator i = this.results.iterator();
        while (i.hasNext()) {
            Node node2 = (Node)i.next();
            NamedNodeMap attrs = node2.getAttributes();
            Node attr = this.getNamedItem(attrs, "id");
            if (name.equals(attr.getTextContent())) {
                return node2;
            }
            if (xhtml || !name.equals((attr = this.getNamedItem(attrs, "name")).getTextContent())) continue;
            return node2;
        }
        return null;
    }

    DomHTMLCollection(DomHTMLDocument doc, Node root) {
        this.doc = doc;
        this.root = root;
    }
}

