/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class DragSourceContext
implements DragSourceListener,
DragSourceMotionListener,
Serializable {
    static final long serialVersionUID = -115407898692194719L;
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 1;
    protected static final int OVER = 2;
    protected static final int CHANGED = 3;
    private DragSourceContextPeer peer;
    private Cursor cursor;
    private Transferable transferable;
    private DragGestureEvent trigger;
    private DragSourceListener dragSourceListener;
    private boolean useCustomCursor;
    private int sourceActions;
    private Image image;
    private Point offset;

    public DragSource getDragSource() {
        return this.trigger.getDragSource();
    }

    public Component getComponent() {
        return this.trigger.getComponent();
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        return this.trigger.getSourceAsDragGestureRecognizer().getSourceActions();
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void addDragSourceListener(DragSourceListener dsl) throws TooManyListenersException {
        if (this.dragSourceListener != null) {
            throw new TooManyListenersException();
        }
        this.dragSourceListener = dsl;
    }

    public void removeDragSourceListener(DragSourceListener dsl) {
        if (this.dragSourceListener == dsl) {
            this.dragSourceListener = null;
        }
    }

    public void transferablesFlavorsChanged() {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragMouseMoved(DragSourceDragEvent e) {
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected void updateCurrentCursor(int dropOp, int targetAct, int status) {
    }

    public DragSourceContext(DragSourceContextPeer peer, DragGestureEvent trigger, Cursor cursor, Image image, Point offset, Transferable trans, DragSourceListener dsl) {
        if (peer == null || trigger == null) {
            throw new NullPointerException();
        }
        if (trigger.getComponent() == null || trigger.getDragSource() == null || trigger.getDragAction() == 0 || trigger.getSourceAsDragGestureRecognizer().getSourceActions() == 0) {
            throw new IllegalArgumentException();
        }
        this.peer = peer;
        this.trigger = trigger;
        this.cursor = cursor;
        this.image = image;
        this.offset = offset;
        this.transferable = trans;
        this.dragSourceListener = dsl;
        throw new Error("not implemented");
    }
}

