/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.UnsupportedEncodingException;

public class URLEncoder {
    private static final String hex = "0123456789ABCDEF";

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public static String encode(String s, String encoding) throws UnsupportedEncodingException {
        int length = s.length();
        int start = 0;
        int i = 0;
        StringBuffer result = new StringBuffer(length);
        while (true) {
            if (i < length && URLEncoder.isSafe(s.charAt(i))) {
                ++i;
                continue;
            }
            result.append(s.substring(start, i));
            if (i >= length) {
                return result.toString();
            }
            if (s.charAt(i) == ' ') {
                result.append('+');
            } else {
                char c;
                start = i;
                while (i < length && (c = s.charAt(i)) != ' ' && !URLEncoder.isSafe(c)) {
                    ++i;
                }
                String unsafe = s.substring(start, i);
                byte[] bytes = unsafe.getBytes(encoding);
                int j = 0;
                while (j < bytes.length) {
                    result.append('%');
                    byte val = bytes[j];
                    result.append(hex.charAt((val & 0xF0) >> 4));
                    result.append(hex.charAt(val & 0xF));
                    ++j;
                }
            }
            start = ++i;
        }
    }

    private static final boolean isSafe(char c) {
        boolean bl = false;
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*') {
            bl = true;
        }
        return bl;
    }

    private URLEncoder() {
    }
}

