/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMap
implements Map {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    Set keys;
    Collection values;

    public abstract Set entrySet();

    public void clear() {
        this.entrySet().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractMap copy = (AbstractMap)super.clone();
        copy.keys = null;
        copy.values = null;
        return copy;
    }

    public boolean containsKey(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(key, ((Map.Entry)entries.next()).getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(value, ((Map.Entry)entries.next()).getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        boolean bl = false;
        if (o == this || o instanceof Map && this.entrySet().equals(((Map)o).entrySet())) {
            bl = true;
        }
        return bl;
    }

    public Object get(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public final int size() {
                    return AbstractMap.this.size();
                }

                public final boolean contains(Object key) {
                    return AbstractMap.this.containsKey(key);
                }

                public final Iterator iterator() {
                    return new Iterator(){
                        private final Iterator map_iterator;

                        public final boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public final Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getKey();
                        }

                        public final void remove() {
                            this.map_iterator.remove();
                        }

                        private final /* synthetic */ void this() {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }
                        {
                            this.this();
                        }
                    };
                }
            };
        }
        return this.keys;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        Iterator entries = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            Object r = entry.getValue();
            entries.remove();
            return r;
        }
        return null;
    }

    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuffer r = new StringBuffer("{");
        int pos = this.size();
        while (pos > 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            r.append(entry.getKey());
            r.append('=');
            r.append(entry.getValue());
            if (pos > 1) {
                r.append(", ");
            }
            --pos;
        }
        r.append("}");
        return r.toString();
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public final int size() {
                    return AbstractMap.this.size();
                }

                public final boolean contains(Object value) {
                    return AbstractMap.this.containsValue(value);
                }

                public final Iterator iterator() {
                    return new Iterator(){
                        private final Iterator map_iterator;

                        public final boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public final Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getValue();
                        }

                        public final void remove() {
                            this.map_iterator.remove();
                        }

                        private final /* synthetic */ void this() {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }
                        {
                            this.this();
                        }
                    };
                }
            };
        }
        return this.values;
    }

    static final boolean equals(Object o1, Object o2) {
        boolean bl;
        if (o1 == null) {
            bl = false;
            if (o2 == null) {
                bl = true;
            }
        } else {
            bl = o1.equals(o2);
        }
        return bl;
    }

    static final int hashCode(Object o) {
        int n = 0;
        if (o != null) {
            n = o.hashCode();
        }
        return n;
    }

    protected AbstractMap() {
    }

    static class BasicMapEntry
    implements Map.Entry {
        Object key;
        Object value;

        public final boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof BasicMapEntry) {
                BasicMapEntry e = (BasicMapEntry)o;
                boolean bl = false;
                if (AbstractMap.equals(this.key, e.key) && AbstractMap.equals(this.value, e.value)) {
                    bl = true;
                }
                return bl;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = false;
            if (AbstractMap.equals(this.key, e.getKey()) && AbstractMap.equals(this.value, e.getValue())) {
                bl = true;
            }
            return bl;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final int hashCode() {
            return AbstractMap.hashCode(this.key) ^ AbstractMap.hashCode(this.value);
        }

        public Object setValue(Object newVal) {
            Object r = this.value;
            this.value = newVal;
            return r;
        }

        public final String toString() {
            return "" + this.key + '=' + this.value;
        }

        BasicMapEntry(Object newKey, Object newValue) {
            this.key = newKey;
            this.value = newValue;
        }
    }
}

