/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.ShortBufferException;

final class NullCipherImpl
extends CipherSpi {
    protected final void engineSetMode(String mode) {
    }

    protected final void engineSetPadding(String padding) {
    }

    protected final int engineGetBlockSize() {
        return 1;
    }

    protected final int engineGetOutputSize(int inputLen) {
        return inputLen;
    }

    protected final byte[] engineGetIV() {
        return null;
    }

    protected final AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected final void engineInit(int mode, Key key, SecureRandom random) {
    }

    protected final void engineInit(int mode, Key key, AlgorithmParameterSpec spec, SecureRandom random) {
    }

    protected final void engineInit(int mode, Key key, AlgorithmParameters params, SecureRandom random) {
    }

    protected final byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (input == null) {
            return new byte[0];
        }
        if (inputOffset < 0 || inputLen < 0 || inputOffset + inputLen > input.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] output = new byte[inputLen];
        System.arraycopy(input, inputOffset, output, 0, inputLen);
        return output;
    }

    protected final int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (input == null) {
            return 0;
        }
        if (inputOffset < 0 || inputLen < 0 || inputOffset + inputLen > input.length || outputOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (output.length - outputOffset < inputLen) {
            throw new ShortBufferException();
        }
        System.arraycopy(input, inputOffset, output, outputOffset, inputLen);
        return inputLen;
    }

    protected final byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) {
        return this.engineUpdate(input, inputOffset, inputLen);
    }

    protected final int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    NullCipherImpl() {
    }
}

