/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.AttributeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    private static final long serialVersionUID = -937921345538462020L;
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String CONTENT_AREA_FILLED_CHANGED_PROPERTY = "contentAreaFilled";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";
    Icon default_icon;
    Icon pressed_icon;
    Icon disabeldIcon;
    Icon selectedIcon;
    Icon disabledSelectedIcon;
    Icon rolloverIcon;
    Icon rolloverSelectedIcon;
    Icon current_icon;
    String text;
    int iconTextGap;
    int verticalAlignment;
    int horizontalAlignment;
    int horizontalTextPosition;
    int verticalTextPosition;
    boolean borderPainted;
    boolean focusPainted;
    boolean contentAreaFilled;
    boolean rollOverEnabled;
    Action action;
    protected ButtonModel model;
    Insets margin;
    int mnemonicIndex;
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected ChangeListener changeListener;
    long multiClickThreshhold;
    PropertyChangeListener actionPropertyChangeListener;
    protected ChangeEvent changeEvent;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel newModel) {
        if (newModel == this.model) {
            return;
        }
        if (this.model != null) {
            this.model.removeActionListener(this.actionListener);
            this.model.removeChangeListener(this.changeListener);
            this.model.removeItemListener(this.itemListener);
        }
        ButtonModel old = this.model;
        this.model = newModel;
        if (this.model != null) {
            this.model.addActionListener(this.actionListener);
            this.model.addChangeListener(this.changeListener);
            this.model.addItemListener(this.itemListener);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, old, this.model);
        this.revalidate();
        this.repaint();
    }

    protected void init(String text, Icon icon) {
        if (text != null) {
            this.text = text;
        }
        if (icon != null) {
            this.default_icon = icon;
        }
    }

    public String getActionCommand() {
        String ac = this.model.getActionCommand();
        if (ac != null) {
            return ac;
        }
        return this.text;
    }

    public void setActionCommand(String actionCommand) {
        if (this.model != null) {
            this.model.setActionCommand(actionCommand);
        }
    }

    public void addActionListener(ActionListener l) {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = AbstractButton.class("[Ljava.awt.event.ActionListener;", false);
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = AbstractButton.class("[Ljava.awt.event.ActionListener;", false);
        }
        this.listenerList.remove(clazz, l);
    }

    public ActionListener[] getActionListeners() {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = AbstractButton.class("[Ljava.awt.event.ActionListener;", false);
        }
        return (ActionListener[])this.listenerList.getListeners(clazz);
    }

    public void addItemListener(ItemListener l) {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = AbstractButton.class("[Ljava.awt.event.ItemListener;", false);
        }
        this.listenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = AbstractButton.class("[Ljava.awt.event.ItemListener;", false);
        }
        this.listenerList.remove(clazz, l);
    }

    public ItemListener[] getItemListeners() {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = AbstractButton.class("[Ljava.awt.event.ItemListener;", false);
        }
        return (ItemListener[])this.listenerList.getListeners(clazz);
    }

    public void addChangeListener(ChangeListener l) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = AbstractButton.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = AbstractButton.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, l);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = AbstractButton.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        e.setSource(this);
        ItemListener[] listeners = this.getItemListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].itemStateChanged(e);
            ++i;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        ActionEvent ae = new ActionEvent(this, e.getID(), this.getActionCommand(), e.getWhen(), e.getModifiers());
        ActionListener[] listeners = this.getActionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].actionPerformed(ae);
            ++i;
        }
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    public int getMnemonic() {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            return mod.getMnemonic();
        }
        return -1;
    }

    public void setMnemonic(char mne) {
        this.setMnemonic((int)mne);
    }

    public void setMnemonic(int mne) {
        ButtonModel mod = this.getModel();
        int old = -1;
        if (mod != null) {
            old = mod.getMnemonic();
        }
        if (old != mne) {
            if (mod != null) {
                mod.setMnemonic(mne);
            }
            if (this.text != null && !this.text.equals("")) {
                char upperCaseMne = Character.toUpperCase((char)mne);
                String upperCaseText = this.text.toUpperCase();
                this.setDisplayedMnemonicIndex(upperCaseText.indexOf(upperCaseMne));
            }
            this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, old, mne);
            this.revalidate();
            this.repaint();
        }
    }

    public void setDisplayedMnemonicIndex(int index) {
        if (index < -1 || this.text != null && index >= this.text.length()) {
            throw new IllegalArgumentException();
        }
        this.mnemonicIndex = index;
    }

    public int getDisplayedMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setRolloverEnabled(boolean r) {
        if (this.rollOverEnabled != r) {
            this.rollOverEnabled = r;
            this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, r ^ true, r);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRolloverEnabled() {
        return this.rollOverEnabled;
    }

    public void setSelected(boolean s) {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            mod.setSelected(s);
        }
    }

    public boolean isSelected() {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            return mod.isSelected();
        }
        return false;
    }

    public void setEnabled(boolean b) {
        if (b == this.isEnabled()) {
            return;
        }
        super.setEnabled(b);
        ButtonModel mod = this.getModel();
        if (mod != null) {
            mod.setEnabled(b);
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int a) {
        if (this.horizontalAlignment == a) {
            return;
        }
        int old = this.horizontalAlignment;
        this.horizontalAlignment = a;
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, old, a);
        this.revalidate();
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int t) {
        if (this.horizontalTextPosition == t) {
            return;
        }
        int old = this.horizontalTextPosition;
        this.horizontalTextPosition = t;
        this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, old, t);
        this.revalidate();
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int a) {
        if (this.verticalAlignment == a) {
            return;
        }
        int old = this.verticalAlignment;
        this.verticalAlignment = a;
        this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, old, a);
        this.revalidate();
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int t) {
        if (this.verticalTextPosition == t) {
            return;
        }
        int old = this.verticalTextPosition;
        this.verticalTextPosition = t;
        this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, old, t);
        this.revalidate();
        this.repaint();
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean b) {
        if (this.borderPainted == b) {
            return;
        }
        boolean old = this.borderPainted;
        this.borderPainted = b;
        this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, old, b);
        this.revalidate();
        this.repaint();
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action a) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            this.removeActionListener(this.action);
            if (this.actionPropertyChangeListener != null) {
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
        }
        Action old = this.action;
        this.action = a;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.actionPropertyChangeListener = this.createActionPropertyChangeListener(a);
            this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            this.addActionListener(this.action);
        }
    }

    public Icon getIcon() {
        return this.default_icon;
    }

    public void setIcon(Icon i) {
        if (this.default_icon == i) {
            return;
        }
        Icon old = this.default_icon;
        this.default_icon = i;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, old, i);
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setLabel(String label) {
        this.setText(label);
    }

    public String getLabel() {
        return this.getText();
    }

    public void setText(String t) {
        if (this.text == t) {
            return;
        }
        String old = this.text;
        this.text = t;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, old, t);
        this.revalidate();
        this.repaint();
    }

    public void setIconTextGap(int i) {
        if (this.iconTextGap == i) {
            return;
        }
        int old = this.iconTextGap;
        this.iconTextGap = i;
        this.fireStateChanged();
        this.revalidate();
        this.repaint();
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets m) {
        if (this.margin == m) {
            return;
        }
        Insets old = this.margin;
        this.margin = m;
        this.firePropertyChange(MARGIN_CHANGED_PROPERTY, old, m);
        this.revalidate();
        this.repaint();
    }

    public Icon getPressedIcon() {
        return this.pressed_icon;
    }

    public void setPressedIcon(Icon pressedIcon) {
        if (this.pressed_icon == pressedIcon) {
            return;
        }
        Icon old = this.pressed_icon;
        this.pressed_icon = pressedIcon;
        this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, old, this.pressed_icon);
        this.revalidate();
        this.repaint();
    }

    public Icon getDisabledIcon() {
        if (this.disabeldIcon == null && this.default_icon instanceof ImageIcon) {
            Image iconImage = ((ImageIcon)this.default_icon).getImage();
            Image grayImage = GrayFilter.createDisabledImage(iconImage);
            this.disabeldIcon = new ImageIcon(grayImage);
        }
        return this.disabeldIcon;
    }

    public void setDisabledIcon(Icon d) {
        this.disabeldIcon = d;
        this.revalidate();
        this.repaint();
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    public void setFocusPainted(boolean p) {
        if (this.focusPainted == p) {
            return;
        }
        boolean old = this.focusPainted;
        this.focusPainted = p;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, old, p);
        this.revalidate();
        this.repaint();
    }

    protected int checkHorizontalKey(int key, String exception) {
        switch (key) {
            case 0: 
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException(exception);
            }
        }
        return key;
    }

    protected int checkVerticalKey(int key, String exception) {
        switch (key) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(exception);
            }
        }
        return key;
    }

    protected void configurePropertiesFromAction(Action a) {
        if (a == null) {
            this.setText(null);
            this.setIcon(null);
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            String actionCommand;
            this.setText((String)a.getValue("Name"));
            this.setIcon((Icon)a.getValue("SmallIcon"));
            this.setEnabled(a.isEnabled());
            this.setToolTipText((String)a.getValue("ShortDescription"));
            if (a.getValue("MnemonicKey") != null) {
                this.setMnemonic((Integer)a.getValue("MnemonicKey"));
            }
            if ((actionCommand = (String)a.getValue("ActionCommandKey")) != null) {
                this.setActionCommand((String)a.getValue("ActionCommandKey"));
            } else {
                this.setActionCommand(this.getText());
            }
        }
    }

    protected ActionListener createActionListener() {
        return new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                AbstractButton.this.fireActionPerformed(e);
            }
        };
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                if (e.getPropertyName().equals("enabled")) {
                    AbstractButton.this.setEnabled(act.isEnabled());
                } else if (e.getPropertyName().equals("Name")) {
                    AbstractButton.this.setText((String)act.getValue("Name"));
                } else if (e.getPropertyName().equals("SmallIcon")) {
                    AbstractButton.this.setIcon((Icon)act.getValue("SmallIcon"));
                } else if (e.getPropertyName().equals("ShortDescription")) {
                    AbstractButton.this.setToolTipText((String)act.getValue("ShortDescription"));
                } else if (e.getPropertyName().equals("MnemonicKey")) {
                    if (act.getValue("MnemonicKey") != null) {
                        AbstractButton.this.setMnemonic((Integer)act.getValue("MnemonicKey"));
                    } else if (e.getPropertyName().equals("ActionCommandKey")) {
                        AbstractButton.this.setActionCommand((String)act.getValue("ActionCommandKey"));
                    }
                }
            }
        };
    }

    protected ChangeListener createChangeListener() {
        return new ButtonChangeListener();
    }

    protected ItemListener createItemListener() {
        return new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                AbstractButton.this.fireItemStateChanged(e);
            }
        };
    }

    public void doClick() {
        this.doClick(100);
    }

    public void doClick(int pressTime) {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            mod.setArmed(true);
            mod.setPressed(true);
            try {
                Thread.sleep(pressTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mod.setPressed(false);
            mod.setArmed(false);
        }
    }

    public Icon getDisabledSelectedIcon() {
        return this.disabledSelectedIcon;
    }

    public void setDisabledSelectedIcon(Icon icon) {
        if (this.disabledSelectedIcon == icon) {
            return;
        }
        Icon old = this.disabledSelectedIcon;
        this.disabledSelectedIcon = icon;
        this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, old, icon);
        this.revalidate();
        this.repaint();
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon r) {
        if (this.rolloverIcon == r) {
            return;
        }
        Icon old = this.rolloverIcon;
        this.rolloverIcon = r;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, old, this.rolloverIcon);
        this.revalidate();
        this.repaint();
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public void setRolloverSelectedIcon(Icon r) {
        if (this.rolloverSelectedIcon == r) {
            return;
        }
        Icon old = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = r;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, old, r);
        this.revalidate();
        this.repaint();
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon s) {
        if (this.selectedIcon == s) {
            return;
        }
        Icon old = this.selectedIcon;
        this.selectedIcon = s;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, old, s);
        this.revalidate();
        this.repaint();
    }

    public Object[] getSelectedObjects() {
        if (this.isSelected()) {
            Object[] objs = new Object[]{this.getText()};
            return objs;
        }
        return null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        boolean bl = false;
        if (this.current_icon == img) {
            bl = true;
        }
        return bl;
    }

    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public void setContentAreaFilled(boolean b) {
        if (this.contentAreaFilled == b) {
            return;
        }
        boolean old = this.contentAreaFilled;
        this.contentAreaFilled = b;
        this.firePropertyChange(CONTENT_AREA_FILLED_CHANGED_PROPERTY, old, b);
        this.setOpaque(b);
    }

    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            super.paintBorder(g);
        }
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.paramString());
        sb.append(",defaultIcon=");
        if (this.getIcon() != null) {
            sb.append(this.getIcon());
        }
        sb.append(",disabledIcon=");
        if (this.getDisabledIcon() != null) {
            sb.append(this.getDisabledIcon());
        }
        sb.append(",disabledSelectedIcon=");
        if (this.getDisabledSelectedIcon() != null) {
            sb.append(this.getDisabledSelectedIcon());
        }
        sb.append(",margin=");
        if (this.getMargin() != null) {
            sb.append(this.getMargin());
        }
        sb.append(",paintBorder=").append(this.isBorderPainted());
        sb.append(",paintFocus=").append(this.isFocusPainted());
        sb.append(",pressedIcon=");
        if (this.getPressedIcon() != null) {
            sb.append(this.getPressedIcon());
        }
        sb.append(",rolloverEnabled=").append(this.isRolloverEnabled());
        sb.append(",rolloverIcon=");
        if (this.getRolloverIcon() != null) {
            sb.append(this.getRolloverIcon());
        }
        sb.append(",rolloverSelected=");
        if (this.getRolloverSelectedIcon() != null) {
            sb.append(this.getRolloverSelectedIcon());
        }
        sb.append(",selectedIcon=");
        if (this.getSelectedIcon() != null) {
            sb.append(this.getSelectedIcon());
        }
        sb.append(",text=");
        if (this.getText() != null) {
            sb.append(this.getText());
        }
        return sb.toString();
    }

    public void setUI(ButtonUI ui) {
        super.setUI(ui);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void updateUI() {
    }

    public long getMultiClickThreshhold() {
        return this.multiClickThreshhold;
    }

    public void setMultiClickThreshhold(long threshhold) {
        if (threshhold < 0L) {
            throw new IllegalArgumentException();
        }
        this.multiClickThreshhold = threshhold;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.changeEvent = new ChangeEvent(this);
    }

    public AbstractButton() {
        this.this();
        this.actionListener = this.createActionListener();
        this.changeListener = this.createChangeListener();
        this.itemListener = this.createItemListener();
        this.horizontalAlignment = 0;
        this.horizontalTextPosition = 11;
        this.verticalAlignment = 0;
        this.verticalTextPosition = 0;
        this.borderPainted = true;
        this.contentAreaFilled = true;
        this.focusPainted = true;
        this.setFocusable(true);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setDisplayedMnemonicIndex(-1);
        this.setOpaque(true);
        this.text = "";
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 1471056094226600578L;

        public void stateChanged(ChangeEvent ev) {
            AbstractButton.this.fireStateChanged();
            AbstractButton.this.repaint();
        }

        protected ButtonChangeListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue,
    AccessibleText {
        private static final long serialVersionUID = -5673062525319836790L;

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public String getAccessibleName() {
            return null;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            return null;
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int value0) {
            return null;
        }

        public boolean doAccessibleAction(int value0) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleText getAccessibleText() {
            return null;
        }

        public int getIndexAtPoint(Point value0) {
            return 0;
        }

        public Rectangle getCharacterBounds(int value0) {
            return null;
        }

        public int getCharCount() {
            return 0;
        }

        public int getCaretPosition() {
            return 0;
        }

        public String getAtIndex(int value0, int value1) {
            return null;
        }

        public String getAfterIndex(int value0, int value1) {
            return null;
        }

        public String getBeforeIndex(int value0, int value1) {
            return null;
        }

        public AttributeSet getCharacterAttribute(int value0) {
            return null;
        }

        public int getSelectionStart() {
            return 0;
        }

        public int getSelectionEnd() {
            return 0;
        }

        public String getSelectedText() {
            return null;
        }

        private final Rectangle getTextRectangle() {
            return null;
        }

        protected AccessibleAbstractButton() {
        }
    }
}

