/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JList
extends JComponent
implements Accessible,
Scrollable {
    private static final long serialVersionUID = 4406629526391098046L;
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    boolean dragEnabled;
    ListCellRenderer cellRenderer;
    int fixedCellWidth;
    int fixedCellHeight;
    int layoutOrientation;
    ListModel model;
    Object prototypeCellValue;
    Color selectionBackground;
    Color selectionForeground;
    ListSelectionModel selectionModel;
    boolean valueIsAdjusting;
    int visibleRowCount;
    ListListener listListener;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionEvent evt = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        ListSelectionListener[] listeners = this.getListSelectionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(evt);
            ++i;
        }
    }

    void init() {
        this.dragEnabled = false;
        this.fixedCellHeight = -1;
        this.fixedCellWidth = -1;
        this.layoutOrientation = 0;
        this.opaque = true;
        this.valueIsAdjusting = false;
        this.visibleRowCount = 8;
        this.cellRenderer = new DefaultListCellRenderer();
        this.listListener = new ListListener();
        this.setModel(new DefaultListModel());
        this.setSelectionModel(this.createSelectionModel());
        this.updateUI();
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int h) {
        if (this.fixedCellHeight == h) {
            return;
        }
        int old = this.fixedCellHeight;
        this.fixedCellHeight = h;
        this.firePropertyChange("fixedCellWidth", old, h);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int w) {
        if (this.fixedCellWidth == w) {
            return;
        }
        int old = this.fixedCellWidth;
        this.fixedCellWidth = w;
        this.firePropertyChange("fixedCellWidth", old, w);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int vc) {
        this.visibleRowCount = vc;
        this.revalidate();
        this.repaint();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = JList.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = JList.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = JList.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        return (ListSelectionListener[])this.getListeners(clazz);
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void setSelectionMode(int a) {
        this.selectionModel.setSelectionMode(a);
    }

    public void setSelectedIndex(int a) {
        this.selectionModel.setSelectionInterval(a, a);
    }

    public void setSelectedIndices(int[] a) {
        int i = 0;
        while (i < a.length) {
            this.setSelectedIndex(a[i]);
            ++i;
        }
    }

    public int getSelectedIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public int getFirstVisibleIndex() {
        ComponentOrientation or = this.getComponentOrientation();
        Rectangle r = this.getVisibleRect();
        if (or == ComponentOrientation.RIGHT_TO_LEFT) {
            r.translate((int)r.getWidth() - 1, 0);
        }
        return this.getUI().locationToIndex(this, r.getLocation());
    }

    public int locationToIndex(Point location) {
        return this.getUI().locationToIndex(this, location);
    }

    public Point indexToLocation(int index) {
        return this.getUI().indexToLocation(this, index);
    }

    public int getLastVisibleIndex() {
        ComponentOrientation or = this.getComponentOrientation();
        Rectangle r = this.getVisibleRect();
        r.translate(0, (int)r.getHeight() - 1);
        if (or == ComponentOrientation.LEFT_TO_RIGHT) {
            r.translate((int)r.getWidth() - 1, 0);
        }
        if (this.getUI().locationToIndex(this, r.getLocation()) == -1 && this.indexToLocation((int)(this.getModel().getSize() - 1)).y < r.y) {
            return this.getModel().getSize() - 1;
        }
        return this.getUI().locationToIndex(this, r.getLocation());
    }

    public int[] getSelectedIndices() {
        if (this.selectionModel.isSelectionEmpty()) {
            return new int[0];
        }
        int lo = this.selectionModel.getMinSelectionIndex();
        int hi = this.selectionModel.getMaxSelectionIndex();
        int n = 0;
        int i = lo;
        while (i <= hi) {
            if (this.selectionModel.isSelectedIndex(i)) {
                ++n;
            }
            ++i;
        }
        int[] v = new int[n];
        int j = 0;
        i = lo;
        while (i <= hi) {
            if (this.selectionModel.isSelectedIndex(i)) {
                v[j++] = i;
            }
            ++i;
        }
        return v;
    }

    public boolean isSelectedIndex(int a) {
        return this.selectionModel.isSelectedIndex(a);
    }

    public Object getSelectedValue() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getModel().getElementAt(index);
    }

    public Object[] getSelectedValues() {
        int[] idx = this.getSelectedIndices();
        Object[] v = new Object[idx.length];
        int i = 0;
        while (i < idx.length) {
            v[i] = this.getModel().getElementAt(i);
            ++i;
        }
        return v;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color c) {
        if (this.selectionBackground == c) {
            return;
        }
        Color old = this.selectionBackground;
        this.selectionBackground = c;
        this.firePropertyChange("selectionBackground", old, c);
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color c) {
        if (this.selectionForeground == c) {
            return;
        }
        Color old = this.selectionForeground;
        this.selectionForeground = c;
        this.firePropertyChange("selectionForeground", old, c);
    }

    public void setSelectedValue(Object obj, boolean scroll) {
        int i = 0;
        while (i < this.model.getSize()) {
            if (this.model.getElementAt(i).equals(obj)) {
                this.setSelectedIndex(i);
                if (!scroll) break;
                this.ensureIndexIsVisible(i);
                break;
            }
            ++i;
        }
    }

    public void ensureIndexIsVisible(int i) {
        this.scrollRectToVisible(this.getUI().getCellBounds(this, i, i));
    }

    public void setListData(final Object[] listData) {
        this.setModel(new AbstractListModel(){

            public final int getSize() {
                return listData.length;
            }

            public final Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public void setListData(final Vector listData) {
        this.setModel(new AbstractListModel(){

            public final int getSize() {
                return listData.size();
            }

            public final Object getElementAt(int i) {
                return listData.elementAt(i);
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        if (this.cellRenderer == renderer) {
            return;
        }
        ListCellRenderer old = this.cellRenderer;
        this.cellRenderer = renderer;
        this.firePropertyChange("cellRenderer", old, renderer);
        this.revalidate();
        this.repaint();
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            this.model.removeListDataListener(this.listListener);
        }
        ListModel old = this.model;
        this.model = model;
        if (this.model != null) {
            this.model.addListDataListener(this.listListener);
        }
        this.firePropertyChange("model", old, model);
        this.revalidate();
        this.repaint();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (this.selectionModel == model) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this.listListener);
        }
        ListSelectionModel old = this.selectionModel;
        this.selectionModel = model;
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.listListener);
        }
        this.firePropertyChange("selectionModel", old, model);
        this.revalidate();
        this.repaint();
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ListUI";
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object obj) {
        if (this.prototypeCellValue == obj) {
            return;
        }
        Object old = this.prototypeCellValue;
        Component comp = this.getCellRenderer().getListCellRendererComponent(this, obj, 0, false, false);
        Dimension d = comp.getPreferredSize();
        this.fixedCellWidth = d.width;
        this.fixedCellHeight = d.height;
        this.prototypeCellValue = obj;
        this.firePropertyChange("prototypeCellValue", old, obj);
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJList();
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.getLayoutOrientation() != 0) {
            return this.getPreferredSize();
        }
        int size = this.getModel().getSize();
        if (this.fixedCellHeight != -1 && this.fixedCellWidth != -1) {
            return new Dimension(this.fixedCellWidth, size * this.fixedCellHeight);
        }
        if (size == 0) {
            if (this.fixedCellWidth == -1) {
                return new Dimension(256, 16 * this.getVisibleRowCount());
            }
            return new Dimension(this.fixedCellWidth, 16 * this.getVisibleRowCount());
        }
        int prefWidth = this.fixedCellWidth != -1 ? this.fixedCellWidth : this.getPreferredSize().width;
        int prefHeight = this.fixedCellHeight != -1 ? this.fixedCellHeight : this.getVisibleRowCount() * this.getCellBounds((int)0, (int)0).height;
        return new Dimension(prefWidth, prefHeight);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        ListUI lui = this.getUI();
        if (orientation == 1) {
            if (direction > 0) {
                Point bottomLeft = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
                int curIdx = lui.locationToIndex(this, bottomLeft);
                Rectangle curBounds = lui.getCellBounds(this, curIdx, curIdx);
                if (curBounds.y + curBounds.height == bottomLeft.y) {
                    if (curIdx + 1 < this.model.getSize()) {
                        Rectangle nxtBounds = lui.getCellBounds(this, curIdx + 1, curIdx + 1);
                        return nxtBounds.height;
                    }
                    return 0;
                }
                return curBounds.y + curBounds.height - bottomLeft.y;
            }
            Point topLeft = new Point(visibleRect.x, visibleRect.y);
            int curIdx = lui.locationToIndex(this, topLeft);
            Rectangle curBounds = lui.getCellBounds(this, curIdx, curIdx);
            if (curBounds.y == topLeft.y) {
                if (curIdx > 0) {
                    Rectangle nxtBounds = lui.getCellBounds(this, curIdx - 1, curIdx - 1);
                    return -nxtBounds.height;
                }
                return 0;
            }
            return curBounds.y - topLeft.y;
        }
        return 1;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.height * direction;
        }
        return visibleRect.width * direction;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        boolean retVal = false;
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            Dimension pref = this.getPreferredSize();
            if (viewport.getSize().width > pref.width) {
                retVal = true;
            }
            if (this.getLayoutOrientation() == 2 && this.getVisibleRowCount() <= 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        boolean retVal = false;
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            Dimension pref = this.getPreferredSize();
            if (viewport.getSize().height > pref.height) {
                retVal = true;
            }
            if (this.getLayoutOrientation() == 1 && this.getVisibleRowCount() <= 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    public int getAnchorSelectionIndex() {
        return this.selectionModel.getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.selectionModel.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.selectionModel.getMaxSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.selectionModel.getMaxSelectionIndex();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.selectionModel.setSelectionInterval(anchor, lead);
    }

    public void addSelectionInterval(int anchor, int lead) {
        this.selectionModel.addSelectionInterval(anchor, lead);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.selectionModel.removeSelectionInterval(index0, index1);
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean isAdjusting) {
        this.valueIsAdjusting = isAdjusting;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean enabled) {
        this.dragEnabled = enabled;
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void setLayoutOrientation(int orientation) {
        if (this.layoutOrientation == orientation) {
            return;
        }
        int old = this.layoutOrientation;
        this.layoutOrientation = orientation;
        this.firePropertyChange("layoutOrientation", old, orientation);
    }

    public Rectangle getCellBounds(int index0, int index1) {
        return this.getUI().getCellBounds(this, index0, index1);
    }

    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        if (prefix == null) {
            throw new IllegalArgumentException("The argument 'prefix' must not be null.");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be less than zero.");
        }
        int size = this.model.getSize();
        if (startIndex > this.model.getSize()) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be greater than the number of elements in the ListModel.");
        }
        int index = -1;
        if (bias == Position.Bias.Forward) {
            int i = startIndex;
            while (i < size) {
                String item = this.model.getElementAt(i).toString();
                if (item.startsWith(prefix)) {
                    index = i;
                    break;
                }
                ++i;
            }
        } else {
            int i = startIndex;
            while (i >= 0) {
                String item = this.model.getElementAt(i).toString();
                if (item.startsWith(prefix)) {
                    index = i;
                    break;
                }
                --i;
            }
        }
        return index;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JList() {
        this.init();
    }

    public JList(Object[] listData) {
        this.init();
        this.setListData(listData);
    }

    public JList(Vector listData) {
        this.init();
        this.setListData(listData);
    }

    public JList(ListModel listData) {
        this.init();
        this.setModel(listData);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ListListener
    implements ListSelectionListener,
    ListDataListener {
        public void contentsChanged(ListDataEvent event) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void intervalAdded(ListDataEvent event) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void intervalRemoved(ListDataEvent event) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void valueChanged(ListSelectionEvent event) {
            JList.this.fireSelectionValueChanged(event.getFirstIndex(), event.getLastIndex(), event.getValueIsAdjusting());
            JList.this.repaint();
        }

        private ListListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int n) {
            return new AccessibleJListChild(JList.this, JList.this.getSelectedIndices()[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return JList.this.isSelectedIndex(n);
        }

        public void addAccessibleSelection(int i) {
            JList.this.addSelectionInterval(i, i);
        }

        public void removeAccessibleSelection(int i) {
            JList.this.removeSelectionInterval(i, i);
        }

        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, JList.this.getModel().getSize());
        }

        public void valueChanged(ListSelectionEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
            this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }

        public void contentsChanged(ListDataEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalAdded(ListDataEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalRemoved(ListDataEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("model")) {
                ListModel oldModel = (ListModel)e.getOldValue();
                oldModel.removeListDataListener(this);
                ListModel newModel = (ListModel)e.getNewValue();
                newModel.addListDataListener(this);
            } else if (propertyName.equals("selectionModel")) {
                ListSelectionModel oldModel = (ListSelectionModel)e.getOldValue();
                oldModel.removeListSelectionListener(this);
                ListSelectionModel newModel = (ListSelectionModel)e.getNewValue();
                oldModel.addListSelectionListener(this);
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet s = super.getAccessibleStateSet();
            if (JList.this.getSelectionMode() != 0) {
                s.add(AccessibleState.MULTISELECTABLE);
            }
            return s;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point p) {
            int childIndex = JList.this.locationToIndex(p);
            return this.getAccessibleChild(childIndex);
        }

        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        public Accessible getAccessibleChild(int n) {
            if (JList.this.getModel().getSize() <= n) {
                return null;
            }
            return new AccessibleJListChild(JList.this, n);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            JList parent;
            int listIndex;
            Cursor cursor;

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.parent.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.parent.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.cursor;
            }

            public void setCursor(Cursor cursor) {
                this.cursor = cursor;
            }

            public Font getFont() {
                return this.parent.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.parent.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            public void setEnabled(boolean b) {
            }

            public boolean isVisible() {
                boolean bl = false;
                if (this.listIndex >= this.parent.getFirstVisibleIndex() && this.listIndex <= this.parent.getLastVisibleIndex()) {
                    bl = true;
                }
                return bl;
            }

            public void setVisible(boolean b) {
            }

            public boolean isShowing() {
                boolean bl = false;
                if (this.isVisible() && this.parent.isShowing()) {
                    bl = true;
                }
                return bl;
            }

            public boolean contains(Point point) {
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                Point loc = this.getLocation();
                SwingUtilities.convertPointToScreen(loc, this.parent);
                return loc;
            }

            public Point getLocation() {
                return this.parent.indexToLocation(this.listIndex);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.parent.getCellBounds(this.listIndex, this.listIndex);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle b = this.getBounds();
                return b.getSize();
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public void requestFocus() {
                this.parent.requestFocus();
            }

            public void addFocusListener(FocusListener listener) {
                this.parent.addFocusListener(listener);
            }

            public void removeFocusListener(FocusListener listener) {
                this.parent.removeFocusListener(listener);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet states = new AccessibleStateSet();
                if (this.isVisible()) {
                    states.add(AccessibleState.VISIBLE);
                }
                if (this.isShowing()) {
                    states.add(AccessibleState.SHOWING);
                }
                if (this.isFocusTraversable()) {
                    states.add(AccessibleState.FOCUSABLE);
                }
                if (this.parent.isEnabled()) {
                    states.add(AccessibleState.SELECTABLE);
                }
                if (this.parent.isSelectedIndex(this.listIndex)) {
                    states.add(AccessibleState.SELECTED);
                }
                return states;
            }

            public int getAccessibleIndexInParent() {
                return this.listIndex;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public Locale getLocale() {
                return this.parent.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
            }

            private final /* synthetic */ void this() {
                this.cursor = Cursor.getDefaultCursor();
            }

            public AccessibleJListChild(JList list2, int index) {
                this.this();
                this.parent = list2;
                this.listIndex = index;
            }
        }
    }
}

