/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final long serialVersionUID = 4227225638931828014L;
    private JPopupMenu popupMenu;
    private MenuEvent menuEvent;
    private int delay;
    protected WinListener popupListener;
    private Point menuLocation;
    static /* synthetic */ Class class$javax$swing$event$MenuListener;

    public JMenuItem add(JMenuItem item) {
        return this.popupMenu.add(item);
    }

    public Component add(Component component) {
        this.popupMenu.insert(component, -1);
        return component;
    }

    public Component add(Component component, int index) {
        return this.popupMenu.add(component, index);
    }

    public JMenuItem add(String text) {
        return this.popupMenu.add(text);
    }

    public JMenuItem add(Action action) {
        return this.popupMenu.add(action);
    }

    public void remove(JMenuItem item) {
        this.popupMenu.remove(item);
    }

    public void remove(int index) {
        this.popupMenu.remove(index);
    }

    public void remove(Component component) {
        int index = this.popupMenu.getComponentIndex(component);
        this.popupMenu.remove(index);
    }

    public void removeAll() {
        this.popupMenu.removeAll();
    }

    public void insert(String text, int index) {
        this.insert(new JMenuItem(text), index);
    }

    public JMenuItem insert(JMenuItem item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than zero");
        }
        this.popupMenu.insert(item, index);
        return item;
    }

    public JMenuItem insert(Action action, int index) {
        JMenuItem item = new JMenuItem(action);
        this.insert(item, index);
        return item;
    }

    public void updateUI() {
        super.setUI((MenuItemUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "MenuUI";
    }

    public void setModel(ButtonModel model) {
        super.setModel(model);
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    private final void setSelectedHelper(boolean selected, boolean menuEnabled, boolean showMenu) {
        if (selected && menuEnabled) {
            super.setArmed(true);
            super.setSelected(true);
            if (this.isShowing()) {
                this.fireMenuSelected();
                int x = 0;
                int y = 0;
                if (showMenu) {
                    if (this.menuLocation == null) {
                        if (this.isTopLevelMenu()) {
                            y = this.getHeight();
                        } else {
                            x = this.getWidth();
                        }
                        this.getPopupMenu().show(this, x, y);
                    } else {
                        this.getPopupMenu().show(this, this.menuLocation.x, this.menuLocation.y);
                    }
                }
            }
        } else {
            super.setSelected(false);
            super.setArmed(false);
            this.fireMenuDeselected();
            this.popupMenu.setVisible(false);
        }
    }

    public void setSelected(boolean selected) {
        this.setSelectedHelper(selected, true, false);
    }

    public boolean isPopupMenuVisible() {
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean popup) {
        if (this.getModel().isEnabled()) {
            this.popupMenu.setVisible(popup);
        }
    }

    protected Point getPopupMenuOrigin() {
        if (this.isTopLevelMenu()) {
            return new Point(0, this.getHeight());
        }
        return new Point(this.getWidth(), 0);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay less than 0");
        }
        this.delay = delay;
    }

    public void setMenuLocation(int x, int y) {
        this.menuLocation = new Point(x, y);
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem item) {
        return new ActionChangedListener(item);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), index);
    }

    public JMenuItem getItem(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        Component c = this.popupMenu.getComponentAtIndex(index);
        if (c instanceof JMenuItem) {
            return (JMenuItem)c;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        return false;
    }

    public int getMenuComponentCount() {
        return this.popupMenu.getComponentCount();
    }

    public Component getMenuComponent(int index) {
        return this.popupMenu.getComponentAtIndex(index);
    }

    public Component[] getMenuComponents() {
        return this.popupMenu.getComponents();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener listener) {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public MenuListener[] getMenuListeners() {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        return (MenuListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireMenuSelected() {
        MenuListener[] listeners = this.getMenuListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].menuSelected(this.menuEvent);
            ++index;
        }
    }

    protected void fireMenuDeselected() {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        EventListener[] ll = this.listenerList.getListeners(clazz);
        int i = 0;
        while (i < ll.length) {
            ((MenuListener)ll[i]).menuDeselected(this.menuEvent);
            ++i;
        }
    }

    protected void fireMenuCanceled() {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        EventListener[] ll = this.listenerList.getListeners(clazz);
        int i = 0;
        while (i < ll.length) {
            ((MenuListener)ll[i]).menuCanceled(this.menuEvent);
            ++i;
        }
    }

    protected WinListener createWinListener(JPopupMenu popup) {
        return new WinListener(popup);
    }

    public void menuSelectionChanged(boolean changed) {
        this.setSelectedHelper(changed, this.isEnabled(), true);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.popupMenu};
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keystroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent event) {
    }

    public void doClick(int time) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
        this.popupMenu.show(this, this.getWidth(), 0);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.popupMenu = new JPopupMenu();
        this.menuEvent = new MenuEvent(this);
    }

    public JMenu() {
        this.this();
    }

    public JMenu(String text) {
        super(text);
        this.this();
        this.popupMenu.setInvoker(this);
    }

    public JMenu(Action action) {
        super(action);
        this.this();
        this.createActionChangeListener(this);
        this.popupMenu.setInvoker(this);
    }

    public JMenu(String text, boolean tearoff) {
        this(text);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ActionChangedListener
    implements PropertyChangeListener {
        private JMenuItem menuItem;

        public void propertyChange(PropertyChangeEvent evt) {
        }

        public ActionChangedListener(JMenuItem menuItem) {
            this.menuItem = menuItem;
            Action a = menuItem.getAction();
            if (a != null) {
                a.addPropertyChangeListener(this);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        private static final long serialVersionUID = -6415815570638474823L;

        public void windowClosing(WindowEvent event) {
            JMenu.this.setSelected(false);
        }

        public WinListener(JPopupMenu popup) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private static final long serialVersionUID = -8131864021059524309L;

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int value0) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleSelection(int value0) {
            return null;
        }

        public boolean isAccessibleChildSelected(int value0) {
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public void addAccessibleSelection(int value0) {
        }

        public void removeAccessibleSelection(int value0) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }

        protected AccessibleJMenu() {
            super(JMenu.this);
        }
    }
}

