/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanRule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tools.StringTools;

public class MissingVerbRule
extends GermanRule {
    private static final int MIN_TOKENS_FOR_ERROR = 5;
    private final PatternRule rule1;
    private final PatternRule rule2;
    private final Language language;

    public MissingVerbRule(ResourceBundle messages, German language) {
        this.language = language;
        this.rule1 = new PatternRule("internal", (Language)language, Arrays.asList(new PatternToken("Vielen", true, false, false), new PatternToken("Dank", true, false, false)), "", "", "");
        this.rule2 = new PatternRule("internal", (Language)language, Arrays.asList(new PatternToken("Herzlichen", true, false, false), new PatternToken("Gl\u00fcckwunsch", true, false, false)), "", "", "");
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.setDefaultOff();
        this.addExamplePair(Example.wrong((String)"<marker>In diesem Satz kein Wort.</marker>"), Example.fixed((String)"In diesem Satz <marker>fehlt</marker> kein Wort."));
    }

    public String getId() {
        return "MISSING_VERB";
    }

    public String getDescription() {
        return "Satz ohne Verb";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        if (!this.isRealSentence(sentence)) {
            return new RuleMatch[0];
        }
        if (this.isSpecialCase(sentence)) {
            return new RuleMatch[0];
        }
        boolean verbFound = false;
        AnalyzedTokenReadings lastToken = null;
        int i = 0;
        for (AnalyzedTokenReadings readings : sentence.getTokensWithoutWhitespace()) {
            if (readings.hasPartialPosTag("VER") || !readings.isTagged() && !StringTools.isCapitalizedWord((String)readings.getToken())) {
                verbFound = true;
                break;
            }
            if (i == 1 && this.verbAtSentenceStart(readings)) {
                verbFound = true;
                break;
            }
            lastToken = readings;
            ++i;
        }
        if (!verbFound && lastToken != null && sentence.getTokensWithoutWhitespace().length >= 5) {
            RuleMatch match = new RuleMatch((Rule)this, 0, lastToken.getStartPos() + lastToken.getToken().length(), "Dieser Satz scheint kein Verb zu enthalten");
            return new RuleMatch[]{match};
        }
        return new RuleMatch[0];
    }

    private boolean isRealSentence(AnalyzedSentence sentence) {
        AnalyzedTokenReadings lastToken;
        String lastTokenStr;
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        return tokens.length > 0 && ((lastTokenStr = (lastToken = tokens[tokens.length - 1]).getToken()).equals(".") || lastTokenStr.equals("?") || lastTokenStr.equals("!"));
    }

    private boolean isSpecialCase(AnalyzedSentence sentence) throws IOException {
        return this.rule1.match(sentence).length > 0 || this.rule2.match(sentence).length > 0;
    }

    private boolean verbAtSentenceStart(AnalyzedTokenReadings readings) throws IOException {
        List lcImperativeReadings;
        String lowercased = StringTools.lowercaseFirstChar((String)readings.getToken());
        List lcReadings = this.language.getTagger().tag(Collections.singletonList(lowercased));
        if (lcReadings.size() > 0 && ((AnalyzedTokenReadings)lcReadings.get(0)).hasPartialPosTag("VER")) {
            return true;
        }
        return !lowercased.endsWith("e") && (lcImperativeReadings = this.language.getTagger().tag(Collections.singletonList(lowercased + "e"))).size() > 0 && ((AnalyzedTokenReadings)lcImperativeReadings.get(0)).hasPartialPosTag("VER");
    }

    public void reset() {
    }
}

