/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.Collections;
import java.util.List;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.editor.mark.TransparentHighlightPainter;
import org.omegat.util.gui.Styles;

public class ComesFromAutoTMMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter PAINTER_XICE = new TransparentHighlightPainter(Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_XICE.getColor(), 0.5f);
    protected static final Highlighter.HighlightPainter PAINTER_X100PC = new TransparentHighlightPainter(Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_X100PC.getColor(), 0.5f);
    protected static final Highlighter.HighlightPainter PAINTER_XAUTO = new TransparentHighlightPainter(Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_XAUTO.getColor(), 0.5f);
    protected static final Highlighter.HighlightPainter PAINTER_XENFORCED = new TransparentHighlightPainter(Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_XENFORCED.getColor(), 0.5f);

    @Override
    public synchronized List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) {
        if (!Core.getEditor().getSettings().isMarkAutoPopulated()) {
            return null;
        }
        TMXEntry e = Core.getProject().getTranslationInfo(ste);
        if (e.linked == null) {
            return null;
        }
        Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, 0, translationText.length());
        switch (e.linked) {
            case xICE: {
                m.painter = PAINTER_XICE;
                break;
            }
            case x100PC: {
                m.painter = PAINTER_X100PC;
                break;
            }
            case xAUTO: {
                m.painter = PAINTER_XAUTO;
                break;
            }
            case xENFORCED: {
                m.painter = PAINTER_XENFORCED;
            }
        }
        return Collections.singletonList(m);
    }
}

