/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.coretypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.loomchild.maligna.coretypes.Category;

public class Alignment {
    public static final float DEFAULT_SCORE = 0.0f;
    private List<String> sourceSegmentList = new ArrayList<String>();
    private List<String> targetSegmentList = new ArrayList<String>();
    private float score = 0.0f;

    public Alignment() {
    }

    public Alignment(List<String> sourceSegmentList, List<String> targetSegmentList, float score) {
        this();
        this.addSourceSegmentList(sourceSegmentList);
        this.addTargetSegmentList(targetSegmentList);
        this.score = score;
    }

    public Alignment(List<String> sourceSegmentList, List<String> targetSegmentList) {
        this(sourceSegmentList, targetSegmentList, 0.0f);
    }

    public Alignment(String[] sourceSegmentArray, String[] targetSegmentArray, float score) {
        this(Arrays.asList(sourceSegmentArray), Arrays.asList(targetSegmentArray), score);
    }

    public Alignment(String[] sourceSegmentArray, String[] targetSegmentArray) {
        this(sourceSegmentArray, targetSegmentArray, 0.0f);
    }

    public void addSourceSegment(String segment) {
        this.sourceSegmentList.add(segment);
    }

    public void addSourceSegmentList(List<String> segmentList) {
        this.sourceSegmentList.addAll(segmentList);
    }

    public void addTargetSegment(String segment) {
        this.targetSegmentList.add(segment);
    }

    public void addTargetSegmentList(List<String> segmentList) {
        this.targetSegmentList.addAll(segmentList);
    }

    public List<String> getSourceSegmentList() {
        return Collections.unmodifiableList(this.sourceSegmentList);
    }

    public List<String> getTargetSegmentList() {
        return Collections.unmodifiableList(this.targetSegmentList);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public Category getCategory() {
        return new Category(this.sourceSegmentList.size(), this.targetSegmentList.size());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceSegmentList == null ? 0 : this.sourceSegmentList.hashCode());
        result = 31 * result + (this.targetSegmentList == null ? 0 : this.targetSegmentList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alignment other = (Alignment)obj;
        if (this.sourceSegmentList == null ? other.sourceSegmentList != null : !this.sourceSegmentList.equals(other.sourceSegmentList)) {
            return false;
        }
        return !(this.targetSegmentList == null ? other.targetSegmentList != null : !this.targetSegmentList.equals(other.targetSegmentList));
    }
}

