/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.SequencePreallocator;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.SequenceGenerator;
import org.apache.derby.impl.sql.catalog.SequenceRange;

public abstract class SequenceUpdater
implements Cacheable {
    protected DataDictionaryImpl _dd;
    protected String _uuidString;
    protected SequenceGenerator _sequenceGenerator;

    public SequenceUpdater() {
    }

    public SequenceUpdater(DataDictionaryImpl dataDictionaryImpl) {
        this();
        this._dd = dataDictionaryImpl;
    }

    protected abstract SequenceGenerator createSequenceGenerator(TransactionController var1) throws StandardException;

    protected abstract boolean updateCurrentValueOnDisk(TransactionController var1, Long var2, Long var3, boolean var4) throws StandardException;

    protected StandardException tooMuchContentionException() {
        return StandardException.newException("X0Y84.T", this._sequenceGenerator.getName());
    }

    public void clean(boolean bl) throws StandardException {
        boolean bl2;
        if (this._sequenceGenerator != null && !(bl2 = this.updateCurrentValueOnDisk(null, this.peekAtCurrentValue()))) {
            String string = MessageService.getTextMessage("X0Y86.S", this._sequenceGenerator.getSchemaName(), this._sequenceGenerator.getName());
            Monitor.getStream().println(string);
        }
        this._uuidString = null;
        this._sequenceGenerator = null;
    }

    public boolean isDirty() {
        return false;
    }

    public Object getIdentity() {
        return this._uuidString;
    }

    public void clearIdentity() {
        block2: {
            try {
                this.clean(false);
            }
            catch (StandardException standardException) {
                LanguageConnectionContext languageConnectionContext = SequenceUpdater.getLCC();
                if (languageConnectionContext == null) break block2;
                Database database = languageConnectionContext.getDatabase();
                boolean bl = database != null ? database.isActive() : false;
                languageConnectionContext.getContextManager().cleanupOnError(standardException, bl);
            }
        }
    }

    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        SequenceUpdater sequenceUpdater = this;
        return sequenceUpdater.setIdentity(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable setIdentity(Object object) throws StandardException {
        this._uuidString = (String)object;
        if (this._sequenceGenerator == null) {
            TransactionController transactionController = SequenceUpdater.getLCC().getTransactionExecute();
            TransactionController transactionController2 = transactionController.startNestedUserTransaction(true, true);
            try {
                this._sequenceGenerator = this.createSequenceGenerator(transactionController2);
            }
            finally {
                if (this._sequenceGenerator == null) {
                    this._uuidString = null;
                }
                transactionController2.commit();
                transactionController2.destroy();
            }
        }
        if (this._sequenceGenerator != null) {
            return this;
        }
        return null;
    }

    public synchronized void getCurrentValueAndAdvance(NumberDataValue numberDataValue) throws StandardException {
        block5: for (int i = 0; i < 2; ++i) {
            long[] lArray = this._sequenceGenerator.getCurrentValueAndAdvance();
            int n = (int)lArray[0];
            long l = lArray[1];
            long l2 = lArray[2];
            long l3 = lArray[3];
            switch (n) {
                case 1: {
                    numberDataValue.setValue(l);
                    return;
                }
                case 2: {
                    this.updateCurrentValueOnDisk(new Long(l), null);
                    numberDataValue.setValue(l);
                    return;
                }
                case 3: {
                    if (!this.updateCurrentValueOnDisk(new Long(l), new Long(l2))) continue block5;
                    this._sequenceGenerator.allocateNewRange(l, l3);
                    continue block5;
                }
                default: {
                    throw this.unimplementedFeature();
                }
            }
        }
        throw this.tooMuchContentionException();
    }

    public Long peekAtCurrentValue() throws StandardException {
        return this._sequenceGenerator.peekAtCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateCurrentValueOnDisk(Long l, Long l2) throws StandardException {
        LanguageConnectionContext languageConnectionContext = SequenceUpdater.getLCC();
        if (languageConnectionContext == null) {
            ContextService contextService = ContextService.getFactory();
            ContextManager contextManager = contextService.getCurrentContextManager();
            AccessFactory accessFactory = this._dd.af;
            TransactionController transactionController = accessFactory.getTransaction(contextManager);
            boolean bl = this.updateCurrentValueOnDisk(transactionController, l, l2, false);
            transactionController.commit();
            transactionController.destroy();
            return bl;
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        TransactionController transactionController2 = transactionController.startNestedUserTransaction(false, true);
        if (transactionController2 != null) {
            try {
                boolean bl = this.updateCurrentValueOnDisk(transactionController2, l, l2, false);
                return bl;
            }
            catch (StandardException standardException) {
                if (!standardException.isLockTimeout()) {
                    throw standardException;
                }
            }
            finally {
                transactionController2.commit();
                transactionController2.destroy();
            }
        }
        throw this.tooMuchContentionException();
    }

    protected SequencePreallocator makePreallocator(TransactionController transactionController) throws StandardException {
        String string = "derby.language.sequence.preallocator";
        String string2 = PropertyUtil.getServiceProperty(transactionController, string);
        if (string2 == null) {
            return new SequenceRange();
        }
        try {
            if (this.isNumber(string2)) {
                return new SequenceRange(Integer.parseInt(string2));
            }
            return (SequencePreallocator)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.missingAllocator(string, string2, classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw this.missingAllocator(string, string2, classCastException);
        }
        catch (InstantiationException instantiationException) {
            throw this.missingAllocator(string, string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.missingAllocator(string, string2, illegalAccessException);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.missingAllocator(string, string2, numberFormatException);
        }
    }

    private StandardException missingAllocator(String string, String string2, Exception exception) {
        return StandardException.newException("X0Y85.S", exception, (Object)string, (Object)string2);
    }

    private boolean isNumber(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException("XSCB3.S");
    }

    public static final class SyssequenceUpdater
    extends SequenceUpdater {
        private RowLocation _sequenceRowLocation;

        public SyssequenceUpdater() {
        }

        public SyssequenceUpdater(DataDictionaryImpl dataDictionaryImpl) {
            super(dataDictionaryImpl);
        }

        protected SequenceGenerator createSequenceGenerator(TransactionController transactionController) throws StandardException {
            RowLocation[] rowLocationArray = new RowLocation[1];
            SequenceDescriptor[] sequenceDescriptorArray = new SequenceDescriptor[1];
            this._dd.computeSequenceRowLocation(transactionController, this._uuidString, rowLocationArray, sequenceDescriptorArray);
            this._sequenceRowLocation = rowLocationArray[0];
            SequenceDescriptor sequenceDescriptor = sequenceDescriptorArray[0];
            return new SequenceGenerator(sequenceDescriptor.getCurrentValue(), sequenceDescriptor.canCycle(), sequenceDescriptor.getIncrement(), sequenceDescriptor.getMaximumValue(), sequenceDescriptor.getMinimumValue(), sequenceDescriptor.getStartValue(), sequenceDescriptor.getSchemaDescriptor().getSchemaName(), sequenceDescriptor.getSequenceName(), this.makePreallocator(transactionController));
        }

        protected boolean updateCurrentValueOnDisk(TransactionController transactionController, Long l, Long l2, boolean bl) throws StandardException {
            return this._dd.updateCurrentSequenceValue(transactionController, this._sequenceRowLocation, bl, l, l2);
        }
    }
}

