/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.heif.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.heif.boxes.Box;
import com.drew.metadata.heif.boxes.FullBox;
import java.io.IOException;

public class ItemLocationBox
extends FullBox {
    int indexSize;
    int offsetSize;
    int lengthSize;
    int baseOffsetSize;
    long itemCount;
    long itemID;
    int constructionMethod;
    int dataReferenceIndex;
    byte[] baseOffset;
    int extentCount;
    Extent[] extents;

    public ItemLocationBox(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        int holder = reader.getUInt8();
        this.offsetSize = (holder & 0xF0) >> 4;
        this.lengthSize = holder & 0xF;
        holder = reader.getUInt8();
        this.baseOffsetSize = (holder & 0xF0) >> 4;
        if (this.version == 1 || this.version == 2) {
            this.indexSize = holder & 0xF;
        }
        if (this.version < 2) {
            this.itemCount = reader.getUInt16();
        } else if (this.version == 2) {
            this.itemCount = reader.getUInt32();
        }
        int i = 0;
        while ((long)i < this.itemCount) {
            if (this.version < 2) {
                this.itemID = reader.getUInt16();
            } else if (this.version == 2) {
                this.itemID = reader.getUInt32();
            }
            if (this.version == 1 || this.version == 2) {
                holder = reader.getUInt16();
                this.constructionMethod = holder & 0xF;
            }
            this.dataReferenceIndex = reader.getUInt16();
            this.baseOffset = reader.getBytes(this.baseOffsetSize);
            this.extentCount = reader.getUInt16();
            Long extentIndex = null;
            this.extents = new Extent[this.extentCount];
            for (int j = 0; j < this.extentCount; ++j) {
                if (this.version == 1 || this.version == 2 && this.indexSize > 0) {
                    extentIndex = this.getIntFromUnknownByte(this.indexSize, reader);
                }
                long extentOffset = this.getIntFromUnknownByte(this.offsetSize, reader);
                long extentLength = this.getIntFromUnknownByte(this.lengthSize, reader);
                this.extents[j] = new Extent(extentIndex == null ? null : extentIndex, extentOffset, extentLength);
            }
            ++i;
        }
    }

    public Long getIntFromUnknownByte(int variable, SequentialReader reader) throws IOException {
        switch (variable) {
            case 1: {
                return reader.getUInt8();
            }
            case 2: {
                return reader.getUInt16();
            }
            case 4: {
                return reader.getUInt32();
            }
            case 8: {
                return reader.getInt64();
            }
        }
        return null;
    }

    static class Extent {
        Long index;
        long offset;
        long length;

        public Extent(Long index, long offset, long length) {
            this.index = index;
            this.offset = offset;
            this.length = length;
        }
    }
}

