/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.BinaryExpression;
import org.josql.expressions.Expression;
import org.josql.internal.Utilities;

public class InExpression
extends BinaryExpression {
    private List items = new ArrayList();
    private boolean not = false;
    private boolean doLike = false;
    private boolean all = false;
    private Map lPats = null;
    private boolean ignoreCase = false;

    public void init(Query q) throws QueryParseException {
        this.left.init(q);
        int s = this.items.size();
        for (int i = 0; i < s; ++i) {
            Expression exp = (Expression)this.items.get(i);
            exp.init(q);
        }
    }

    public void setIgnoreCase(boolean v) {
        this.ignoreCase = v;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean v) {
        this.all = v;
    }

    public boolean isDoLike() {
        return this.doLike;
    }

    public void setDoLike(boolean d) {
        this.doLike = d;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public List getItems() {
        return this.items;
    }

    public void addItem(Expression e) {
        this.items.add(e);
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean v) {
        this.not = v;
    }

    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        Object l = this.left.getValue(o, q);
        String v = null;
        String wc = String.valueOf(q.getWildcardCharacter());
        if (this.doLike && l != null) {
            v = l.toString();
            if (this.ignoreCase) {
                v = v.toLowerCase();
            }
        }
        int count = 0;
        int s = this.items.size();
        for (int i = 0; i < s; ++i) {
            Expression exp = (Expression)this.items.get(i);
            Object eo = exp.getValue(o, q);
            boolean eq = false;
            boolean proc = false;
            if (eo instanceof Collection) {
                Collection col = (Collection)eo;
                eq = this.compareCollection(l, col, v, wc);
                proc = true;
            }
            if (eo instanceof Map) {
                eq = this.compareMap(l, (Map)eo, v, wc);
                proc = true;
            }
            if (!proc) {
                eq = this.compareItem(l, eo, v, wc);
            }
            if (!eq) continue;
            ++count;
            if (this.not) {
                return false;
            }
            if (this.all) continue;
            return true;
        }
        if (this.all && !this.not && count == s) {
            return true;
        }
        if (this.all && this.not && count == 0) {
            return true;
        }
        return this.not;
    }

    private boolean compareCollection(Object o, Collection c, String v, String wc) {
        if (c instanceof List) {
            return this.compareList(o, (List)c, v, wc);
        }
        Iterator i = c.iterator();
        int count = 0;
        while (i.hasNext()) {
            Object n = i.next();
            if (!this.compareItem(o, n, v, wc)) continue;
            ++count;
            if (this.all) continue;
            return true;
        }
        if (this.all && !this.not && count == c.size()) {
            return true;
        }
        return this.all && this.not && count == 0;
    }

    private boolean compareList(Object o, List l, String v, String wc) {
        int s = l.size();
        int count = 0;
        for (int i = 0; i < s; ++i) {
            Object n = l.get(i);
            if (!this.compareItem(o, n, v, wc)) continue;
            ++count;
            if (this.all) continue;
            return true;
        }
        if (this.all && !this.not && count == s) {
            return true;
        }
        return this.all && this.not && count == 0;
    }

    private boolean compareItem(Object o, Object n, String v, String wc) {
        boolean eq = true;
        if (this.doLike) {
            if (v == null && n == null) {
                return true;
            }
            if (n == null) {
                return false;
            }
            String vn = n.toString();
            if (this.ignoreCase) {
                vn = vn.toLowerCase();
            }
            List pat = Utilities.getLikePattern(vn, wc);
            eq = Utilities.matchLikePattern(pat, v);
        } else {
            if (this.ignoreCase) {
                if (o == null && n == null) {
                    return true;
                }
                if (n == null) {
                    return false;
                }
                return o.toString().equalsIgnoreCase(n.toString());
            }
            eq = Utilities.isEquals(o, n);
        }
        return eq;
    }

    private boolean compareMap(Object o, Map m, String v, String wc) {
        Iterator i = m.keySet().iterator();
        int count = 0;
        while (i.hasNext()) {
            Object n = i.next();
            if (!this.compareItem(o, n, v, wc)) continue;
            ++count;
            if (this.all) continue;
            return true;
        }
        if (this.all && !this.not && count == m.size()) {
            return true;
        }
        return this.all && this.not && count == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.left.toString());
        buf.append(" ");
        if (this.isNot()) {
            buf.append("NOT ");
        }
        if (this.ignoreCase) {
            buf.append("$");
        }
        buf.append("IN ");
        if (this.doLike) {
            buf.append("LIKE ");
        }
        if (this.all) {
            buf.append("ALL ");
        }
        buf.append("(");
        for (int i = 0; i < this.items.size(); ++i) {
            buf.append(this.items.get(i));
            if (i >= this.items.size() - 1) continue;
            buf.append(",");
        }
        buf.append(")");
        if (this.isBracketed()) {
            buf.insert(0, "(");
            buf.append(")");
        }
        return buf.toString();
    }
}

