/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.cli.commands;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.activemq.apollo.broker.ConfigStore$;
import org.apache.activemq.apollo.broker.store.Store;
import org.apache.activemq.apollo.broker.store.StoreFactory$;
import org.apache.activemq.apollo.cli.commands.Helper;
import org.apache.activemq.apollo.cli.commands.Helper$;
import org.apache.activemq.apollo.cli.commands.StoreExport$;
import org.apache.activemq.apollo.cli.commands.StoreExport$StoreExport$;
import org.apache.activemq.apollo.dto.BrokerDTO;
import org.apache.activemq.apollo.dto.VirtualHostDTO;
import org.apache.activemq.apollo.util.FileSupport$;
import org.apache.activemq.apollo.util.Service;
import org.apache.activemq.apollo.util.ServiceControl$;
import org.apache.activemq.apollo.util.package$;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.service.command.CommandSession;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@Command(scope="apollo", name="store-export", description="exports the contents of a broker message store")
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001=\u00111b\u0015;pe\u0016,\u0005\u0010]8si*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004G2L'BA\u0004\t\u0003\u0019\t\u0007o\u001c7m_*\u0011\u0011BC\u0001\tC\u000e$\u0018N^3nc*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u0019CA\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a?5\t!D\u0003\u0002\u00047)\u0011A$H\u0001\u0005O><wN\u0003\u0002\u001f\u0015\u0005)a-\u001a7jq&\u0011\u0001E\u0007\u0002\u0007\u0003\u000e$\u0018n\u001c8\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003\t9Q!\f\u0001\t\u00069\n1b\u0015;pe\u0016,\u0005\u0010]8siB\u0011q\u0006M\u0007\u0002\u0001\u0019)\u0011\u0001\u0001E\u0003cM!\u0001\u0007\u0005\u001a\"!\t\u0019d'D\u00015\u0015\t)d!\u0001\u0003vi&d\u0017BA\u001c5\u0005\raun\u001a\u0005\u0006QA\"\t!\u000f\u000b\u0002]!91\b\u0001a\u0001\n\u0003a\u0014\u0001B2p]\u001a,\u0012!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001R\t!![8\n\u0005\t{$\u0001\u0002$jY\u0016Dq\u0001\u0012\u0001A\u0002\u0013\u0005Q)\u0001\u0005d_:4w\fJ3r)\t1\u0015\n\u0005\u0002#\u000f&\u0011\u0001j\t\u0002\u0005+:LG\u000fC\u0004K\u0007\u0006\u0005\t\u0019A\u001f\u0002\u0007a$\u0013\u0007\u0003\u0004M\u0001\u0001\u0006K!P\u0001\u0006G>tg\r\t\u0015\u0007\u0017:\u000b&\u000bV+\u0011\u0005ey\u0015B\u0001)\u001b\u0005\u0019y\u0005\u000f^5p]\u0006!a.Y7fC\u0005\u0019\u0016AB\u0017.G>tg-A\u0006eKN\u001c'/\u001b9uS>t\u0017%\u0001,\u0002=QCW\rI!q_2dw\u000eI2p]\u001aLw-\u001e:bi&|g\u000e\t4jY\u0016t\u0003b\u0002-\u0001\u0001\u0004%\t!W\u0001\u0005Q>\u001cH/F\u0001[!\tYfL\u0004\u0002#9&\u0011QlI\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^G!9!\r\u0001a\u0001\n\u0003\u0019\u0017\u0001\u00035pgR|F%Z9\u0015\u0005\u0019#\u0007b\u0002&b\u0003\u0003\u0005\rA\u0017\u0005\u0007M\u0002\u0001\u000b\u0015\u0002.\u0002\u000b!|7\u000f\u001e\u0011)\r\u0015t\u0015\u000b\u001b+kC\u0005I\u0017AD\u0017.m&\u0014H/^1m[!|7\u000f^\u0011\u0002W\u0006iF\u000b[3!S\u0012\u0004sN\u001a\u0011uQ\u0016\u0004c/\u001b:uk\u0006d\u0007\u0005[8ti\u0002\"x\u000eI3ya>\u0014H\u000f\f\u0011jM\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002C\u000f[3!I\u00164\u0017-\u001e7uAYL'\u000f^;bY\u0002Bwn\u001d;!SN\u00043/\u001a7fGR,GM\f\u0005\b[\u0002\u0001\r\u0011\"\u0001=\u0003\u00111\u0017\u000e\\3\t\u000f=\u0004\u0001\u0019!C\u0001a\u0006Aa-\u001b7f?\u0012*\u0017\u000f\u0006\u0002Gc\"9!J\\A\u0001\u0002\u0004i\u0004BB:\u0001A\u0003&Q(A\u0003gS2,\u0007\u0005\u000b\u0006skFCH+_>}{z\u0004\"!\u0007<\n\u0005]T\"\u0001C!sOVlWM\u001c;\"\u00035\f\u0013A_\u00012)\",\u0007eY8naJ,7o]3eAQ\f'\u000f\t4jY\u0016\u0004Co\u001c\u0011i_2$\u0007\u0005\u001e5fA\u0015D\bo\u001c:uK\u0012\u0004C-\u0019;b\u0003\u0015Ig\u000eZ3y;\u0005\u0001\u0011\u0001\u0003:fcVL'/\u001a3\u001a\u0003\u0005Aq!!\u0001\u0001\t\u0003\t\u0019!A\u0004fq\u0016\u001cW\u000f^3\u0015\t\u0005\u0015\u00111\u0002\t\u0004E\u0005\u001d\u0011bAA\u0005G\t1\u0011I\\=SK\u001aDq!!\u0004\u0000\u0001\u0004\ty!A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u000591m\\7nC:$'bAA\r;\u000591/\u001a:wS\u000e,\u0017\u0002BA\u000f\u0003'\u0011abQ8n[\u0006tGmU3tg&|g\u000eK\u0007\u0001\u0003C\t9#!\u000bR\u0003W!\u0016q\u0006\t\u00043\u0005\r\u0012bAA\u00135\t91i\\7nC:$\u0017!B:d_B,\u0017%A\u0004\"\u0005\u00055\u0012\u0001D:u_J,W&\u001a=q_J$\u0018EAA\u0019\u00039*\u0007\u0010]8siN\u0004C\u000f[3!G>tG/\u001a8ug\u0002zg\rI1!EJ|7.\u001a:![\u0016\u001c8/Y4fAM$xN]3")
public class StoreExport
implements Action,
ScalaObject {
    @org.apache.felix.gogo.commands.Option(name="--conf", description="The Apollo configuration file.")
    private File conf;
    @org.apache.felix.gogo.commands.Option(name="--virtual-host", description="The id of the virtual host to export, if not specified, the default virtual host is selected.")
    private String host;
    @Argument(name="file", description="The compressed tar file to hold the exported data", index=0, required=true)
    private File file;
    private volatile StoreExport$StoreExport$ StoreExport$module;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final StoreExport$StoreExport$ StoreExport() {
        if (this.StoreExport$module != null) return this.StoreExport$module;
        StoreExport storeExport = this;
        synchronized (storeExport) {
            if (this.StoreExport$module == null) {
                this.StoreExport$module = new StoreExport$StoreExport$(this);
            }
            return this.StoreExport$module;
        }
    }

    public File conf() {
        return this.conf;
    }

    public void conf_$eq(File file) {
        this.conf = file;
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String string) {
        this.host = string;
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File file) {
        this.file = file;
    }

    public Object execute(CommandSession session) {
        block6: {
            try {
                File base = FileSupport$.MODULE$.system_dir("apollo.base");
                if (this.conf() == null) {
                    this.conf_$eq(FileSupport$.MODULE$.to_rich_file(FileSupport$.MODULE$.to_rich_file(base).$div("etc")).$div("apollo.xml"));
                }
                if (!this.conf().exists()) break block6;
                PrintStream printStream = session.getConsole();
                BrokerDTO config = ConfigStore$.MODULE$.load(this.conf(), (Function1)new Serializable(this, printStream){
                    public static final long serialVersionUID;
                    private final PrintStream eta$0$1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String string) {
                        this.eta$0$1$1.println(string);
                    }
                    {
                        this.eta$0$1$1 = printStream;
                    }
                });
                VirtualHostDTO[] hosts = (VirtualHostDTO[])JavaConversions$.MODULE$.collectionAsScalaIterable((Collection)config.virtual_hosts).toArray(ClassManifest$.MODULE$.classType(VirtualHostDTO.class));
                Option vho = this.host() == null ? Predef$.MODULE$.refArrayOps((Object[])hosts).headOption() : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hosts).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final StoreExport $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(VirtualHostDTO virtualHostDTO) {
                        String string = virtualHostDTO.id;
                        String string2 = this.$outer.host();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).headOption();
                VirtualHostDTO vh = (VirtualHostDTO)vho.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Nothing$ apply() {
                        return Helper$.MODULE$.error("Could find host to export");
                    }
                });
                if (vh.store == null) {
                    throw Helper$.MODULE$.error(Predef$.MODULE$.augmentString("The virtual host '%s' does not have a store configured.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vh.id})));
                }
                Store store$1 = StoreFactory$.MODULE$.create(vh.store);
                if (store$1 == null) {
                    throw Helper$.MODULE$.error("Could not create the store.");
                }
                session.getConsole().println(new StringBuilder().append((Object)"Starting store: ").append((Object)store$1).toString());
                ServiceControl$.MODULE$.start((Service)store$1, "store startup");
                session.getConsole().println("Exporting... (this might take a while)");
                FileSupport$.MODULE$.using((Closeable)new BufferedOutputStream(new FileOutputStream(this.file())), (Function1)new Serializable(this, store$1){
                    public static final long serialVersionUID;
                    public final Store store$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(BufferedOutputStream os$1) {
                        ((Option)package$.MODULE$.sync_cb((Function1)new Serializable(this, os$1){
                            public static final long serialVersionUID;
                            private final $anonfun$execute$1 $outer;
                            private final BufferedOutputStream os$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(Function1<Option<String>, BoxedUnit> cb) {
                                this.$outer.store$1.export_data((OutputStream)this.os$1, cb);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.os$1 = bufferedOutputStream;
                            }
                        })).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Nothing$ apply(Object object) {
                                return Helper$.MODULE$.error(object);
                            }
                        });
                    }
                    {
                        this.store$1 = store;
                    }
                });
                ServiceControl$.MODULE$.stop((Service)store$1, "store stop");
                session.getConsole().println(new StringBuilder().append((Object)"Done. Export located at: ").append((Object)this.file()).toString());
            }
            catch (Helper.Failure failure) {
                throw Helper$.MODULE$.error(failure.getMessage());
            }
            return null;
        }
        throw Helper$.MODULE$.error(Predef$.MODULE$.augmentString("Configuration file'%s' does not exist.\n\nTry creating a broker instance using the 'apollo create' command.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conf()})));
    }
}

