/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.sandbox.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequestedSecurityToken {
    private Element element;
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedSecurityToken");
    SecurityContextToken sct;
    UsernameToken unt;

    public RequestedSecurityToken(Document doc) throws Exception {
        this.element = doc.createElementNS(TOKEN.getNamespaceURI(), "wst:" + TOKEN.getLocalPart());
        WSSecurityUtil.setNamespace(this.element, TOKEN.getNamespaceURI(), "wst");
        this.element.appendChild(doc.createTextNode(""));
    }

    public RequestedSecurityToken(Document doc, boolean generateChildren) throws Exception {
        this(doc);
        if (generateChildren) {
            this.sct = new SecurityContextToken(doc);
            this.element.appendChild(this.sct.getElement());
        }
    }

    public RequestedSecurityToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
    }

    public RequestedSecurityToken(Element elem, boolean parseChildElements) throws WSSecurityException {
        this(elem);
        if (!parseChildElements) {
            return;
        }
        this.sct = new SecurityContextToken((Element)WSSecurityUtil.getDirectChild(elem, SecurityContextToken.TOKEN.getLocalPart(), SecurityContextToken.TOKEN.getNamespaceURI()));
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void addToken(Element childToken) {
        this.element.appendChild(childToken);
    }

    public SecurityContextToken getSct() {
        return this.sct;
    }
}

