/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.rest.RestRequestFilter;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestPutWatchAction
extends WatcherRestHandler
implements RestRequestFilter {
    private static final Logger logger = LogManager.getLogger(RestPutWatchAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private static final Set<String> FILTERED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"input.http.request.auth.basic.password", "input.chain.inputs.*.http.request.auth.basic.password", "actions.*.email.attachments.*.reporting.auth.basic.password", "actions.*.webhook.auth.basic.password"}));

    public RestPutWatchAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_watcher/watch/{id}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_watcher/watch/{id}", (RestHandler)this);
    }

    public String getName() {
        return "xpack_watcher_put_watch_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(final RestRequest request, WatcherClient client) throws IOException {
        PutWatchRequest putWatchRequest = new PutWatchRequest(request.param("id"), request.content(), request.getXContentType());
        putWatchRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putWatchRequest.masterNodeTimeout()));
        putWatchRequest.setVersion(request.paramAsLong("version", -3L));
        putWatchRequest.setIfSeqNo(request.paramAsLong("if_seq_no", putWatchRequest.getIfSeqNo()));
        putWatchRequest.setIfPrimaryTerm(request.paramAsLong("if_primary_term", putWatchRequest.getIfPrimaryTerm()));
        putWatchRequest.setActive(request.paramAsBoolean("active", putWatchRequest.isActive()));
        return channel -> client.putWatch(putWatchRequest, (ActionListener)new RestBuilderListener<PutWatchResponse>(channel){

            public RestResponse buildResponse(PutWatchResponse response, XContentBuilder builder) throws Exception {
                response.toXContent(builder, (ToXContent.Params)request);
                RestStatus status = response.isCreated() ? RestStatus.CREATED : RestStatus.OK;
                return new BytesRestResponse(status, builder);
            }
        });
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

