/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.codec.audio.mpa.MPAHeader;

public class MPAParse {
    private static int MPA_MAX_BYTES_IN_FRAME = 2024;
    private static int MPA_MIN_BYTES_IN_FRAME = 21;
    private static int MPA_NSAMP = 1152;
    private static int MPA_LAYER1 = 3;
    private static int MPA_LAYER2 = 2;
    private static int MPA_LAYER3 = 1;
    private static int MPA_MPEG1 = 1;
    private static int MPA_MPEG2 = 0;
    private static int MPA_MONO = 3;
    public static int[][] SAMPLE_TABLE = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};
    public static int[][] BITRATE_TABLE1 = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, -1}, {0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, -1}};
    public static int[][] BITRATE_TABLE2 = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1}};
    private static int[] MAX_FREE_BITS = new int[]{0, 11520, 13824, 5376};
    public static int[] SLOT_BITS_MASK = new int[]{0, 7, 7, 31};
    public static int[][] SAMPLES_PER_FRAME = new int[][]{{0, 576, 1152, 384}, {0, 1152, 1152, 384}};
    public static int MPA_OK = 0;
    public static int MPA_HDR_DOUBTED = 1;
    public static int MPA_ERR_LOWBUFFER = -1;
    public static int MPA_ERR_NULLPTR = -2;
    public static int MPA_ERR_NOHDR = -3;
    private boolean firstFound = false;
    private int firstId = 0;
    private int firstLayer = 0;
    private int firstSamplingRate = 0;

    public String getName() {
        return "MPEG Audio Parser";
    }

    public void reset() {
        this.firstFound = false;
        this.firstId = 0;
        this.firstLayer = 0;
        this.firstSamplingRate = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHeader(MPAHeader header, byte[] inData, int inOffset, int inLength) {
        int channelMode;
        int paddingBit;
        int samplingIndex;
        int bitrateIndex;
        int crc;
        int layer;
        int id;
        int bufend;
        int off2;
        int offset;
        int status;
        block28: {
            status = MPA_ERR_NOHDR;
            boolean found = false;
            offset = inOffset;
            off2 = 0;
            if (inLength < 4) {
                return status;
            }
            bufend = offset + inLength;
            block2: while (true) {
                if ((inData[offset] & 0xFF) != 255 || (inData[offset + 1] & 0xF6) <= 240 || (inData[offset + 2] & 0xF0) == 240 || (inData[offset + 2] & 0xC) == 12 || (inData[offset + 3] & 3) == 2) {
                    if (++offset + 3 < bufend) continue;
                    if (!found) {
                        return status;
                    }
                    break block28;
                }
                id = inData[offset + 1] >> 3 & 1;
                layer = inData[offset + 1] >> 1 & 3;
                crc = inData[offset + 1] & 1;
                bitrateIndex = inData[offset + 2] >> 4 & 0xF;
                samplingIndex = inData[offset + 2] >> 2 & 3;
                paddingBit = inData[offset + 2] >> 1 & 1;
                channelMode = inData[offset + 3] >> 6 & 3;
                int nSamples = SAMPLES_PER_FRAME[id][layer];
                int samplingRate = SAMPLE_TABLE[id][samplingIndex];
                if (bitrateIndex != 0) {
                    int bitsInFrame = (id == MPA_MPEG1 ? BITRATE_TABLE1[layer][bitrateIndex] : BITRATE_TABLE2[layer][bitrateIndex]) * 1000 * nSamples / samplingRate & ~SLOT_BITS_MASK[layer];
                    if (paddingBit != 0) {
                        bitsInFrame += SLOT_BITS_MASK[layer] + 1;
                    }
                    if ((off2 = offset + (bitsInFrame >> 3)) + 1 < bufend) {
                        if ((inData[off2] & 0xFF) == 255 && (inData[off2 + 1] & 0xFE) == (inData[offset + 1] & 0xFE)) {
                            if (this.firstFound) {
                                if (id == this.firstId && layer == this.firstLayer && samplingRate == this.firstSamplingRate) {
                                    header.headerOffset = offset;
                                    found = true;
                                    status = MPA_OK;
                                    break block28;
                                } else {
                                    ++offset;
                                    continue;
                                }
                            }
                            header.headerOffset = offset;
                            found = true;
                            status = MPA_OK;
                            break block28;
                        }
                        if (offset == inOffset && this.firstFound && id == this.firstId && layer == this.firstLayer && samplingRate == this.firstSamplingRate) {
                            if (!found) {
                                header.headerOffset = offset;
                            }
                            found = true;
                            status = MPA_HDR_DOUBTED;
                            break block28;
                        } else {
                            ++offset;
                            continue;
                        }
                    }
                    if (!found) {
                        header.headerOffset = offset;
                    }
                    found = true;
                    status = MPA_HDR_DOUBTED;
                    ++offset;
                    continue;
                }
                int maxLen = MAX_FREE_BITS[layer] >> 3;
                off2 = 48;
                if (offset + off2 + 3 >= bufend) {
                    if (!found) {
                        header.headerOffset = offset;
                    }
                    found = true;
                    status = MPA_HDR_DOUBTED;
                    ++offset;
                    continue;
                }
                try {
                    while ((inData[offset + off2] & 0xFF) != 255 || (inData[offset + off2 + 1] & 0xFE) != (inData[offset + 1] & 0xFE) || (inData[offset + off2 + 2] & 0xFC) != (inData[offset + 2] & 0xFC) || (inData[offset + off2 + 3] & 3) != 2) {
                        if (++off2 > maxLen) {
                            ++offset;
                            continue block2;
                        }
                        if (offset + off2 + 3 < bufend) continue;
                        if (!found) {
                            header.headerOffset = offset;
                        }
                        found = true;
                        status = MPA_HDR_DOUBTED;
                        ++offset;
                        continue block2;
                    }
                    break;
                }
                catch (Exception ex) {
                    System.err.println("Exception: off " + offset + " off2 " + off2 + " bufend " + bufend);
                    ex.printStackTrace();
                    return MPA_ERR_NOHDR;
                }
            }
            header.headerOffset = offset;
            found = true;
            status = MPA_OK;
        }
        offset = header.headerOffset;
        id = inData[offset + 1] >> 3 & 1;
        layer = inData[offset + 1] >> 1 & 3;
        crc = inData[offset + 1] & 1;
        bitrateIndex = inData[offset + 2] >> 4 & 0xF;
        samplingIndex = inData[offset + 2] >> 2 & 3;
        paddingBit = inData[offset + 2] >> 1 & 1;
        channelMode = inData[offset + 3] >> 6 & 3;
        header.layer = 4 - layer;
        header.nSamples = SAMPLES_PER_FRAME[id][layer];
        header.samplingRate = SAMPLE_TABLE[id][samplingIndex];
        header.bitRate = id == MPA_MPEG1 ? BITRATE_TABLE1[layer][bitrateIndex] : BITRATE_TABLE2[layer][bitrateIndex];
        int n2 = header.nChannels = channelMode == MPA_MONO ? 1 : 2;
        if (header.bitRate > 0) {
            header.bitsInFrame = header.bitRate * 1000 * header.nSamples / header.samplingRate & ~SLOT_BITS_MASK[layer];
            if (paddingBit != 0) {
                header.bitsInFrame += SLOT_BITS_MASK[layer] + 1;
            }
        } else {
            header.bitsInFrame = status == MPA_OK ? off2 << 3 : bufend - offset << 3;
        }
        if (layer == MPA_LAYER3) {
            int hoff;
            int n3 = hoff = crc == 1 ? 4 : 6;
            header.negOffset = id == MPA_MPEG1 ? (inData[offset + hoff] & 0xFF) << 1 | inData[offset + hoff + 1] >> 7 & 1 : inData[offset + hoff] & 0xFF;
        } else {
            header.negOffset = 0;
        }
        if (!this.firstFound && status == MPA_OK) {
            this.firstFound = true;
            this.firstId = id;
            this.firstLayer = layer;
            this.firstSamplingRate = header.samplingRate;
        }
        return status;
    }
}

