/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.StringUtils;

public class Role
extends BuildableType {
    public static final Comparator<Role> militaryComparator = Comparator.comparingDouble(r -> r.getOffence() + r.getDefence()).reversed();
    private Role downgrade;
    private int maximumCount = 1;
    private UnitType expertUnit = null;
    private List<RoleChange> roleChanges = null;
    private static final String CAPTURE_TAG = "capture";
    private static final String DOWNGRADE_TAG = "downgrade";
    private static final String FROM_TAG = "from";
    private static final String EXPERT_UNIT_TAG = "expert-unit";
    private static final String MAXIMUM_COUNT_TAG = "maximum-count";
    private static final String ROLE_CHANGE_TAG = "role-change";
    private static final String OLD_EXPERT_UNIT_TAG = "expertUnit";
    private static final String OLD_MAXIMUM_COUNT_TAG = "maximumCount";

    public Role(String id, Specification specification) {
        super(id, specification);
    }

    public static boolean isDefaultRoleId(String roleId) {
        return "model.role.default".equals(roleId);
    }

    public boolean isDefaultRole() {
        return Role.isDefaultRoleId(this.getId());
    }

    public String getRoleSuffix() {
        return Role.getRoleSuffix(this.getId());
    }

    public static String getRoleSuffix(String roleId) {
        return StringUtils.lastPart(roleId, ".");
    }

    public static String fixRoleId(String roleId) {
        if (roleId.indexOf(46) < 0) {
            roleId = "model.role." + roleId.toLowerCase(Locale.US);
        }
        return roleId;
    }

    public final Role getDowngrade() {
        return this.downgrade;
    }

    public final void setDowngrade(Role newDowngrade) {
        this.downgrade = newDowngrade;
    }

    public final int getMaximumCount() {
        return this.maximumCount;
    }

    public final void setMaximumCount(int newMaximumCount) {
        this.maximumCount = newMaximumCount;
    }

    public final UnitType getExpertUnit() {
        return this.expertUnit;
    }

    public final void setExpertUnit(UnitType newExpertUnit) {
        this.expertUnit = newExpertUnit;
    }

    public List<AbstractGoods> getRequiredGoods(int roleCount) {
        List<AbstractGoods> result = this.getRequiredGoods();
        if (roleCount > 1 && !result.isEmpty()) {
            for (AbstractGoods ag : result) {
                ag.setAmount(roleCount * ag.getAmount());
            }
        }
        return result;
    }

    public int getRequiredGoodsPrice(Market market) {
        return this.getRequiredGoods().stream().mapToInt(ag -> market.getBidPrice(ag.getType(), ag.getAmount() * this.getMaximumCount())).sum();
    }

    public final List<RoleChange> getRoleChanges() {
        return this.roleChanges == null ? Collections.emptyList() : this.roleChanges;
    }

    public void addRoleChange(String from, String capture) {
        if (this.roleChanges == null) {
            this.roleChanges = new ArrayList<RoleChange>();
        }
        this.roleChanges.add(new RoleChange(from, capture));
    }

    public double getOffence() {
        return this.applyModifiers(0.0f, null, "model.modifier.offence");
    }

    public boolean isOffensive() {
        return this.hasModifier("model.modifier.offence");
    }

    private double getDefence() {
        return this.applyModifiers(0.0f, null, "model.modifier.defence");
    }

    public boolean isDefensive() {
        return this.hasModifier("model.modifier.defence");
    }

    public boolean isCompatibleWith(Role other) {
        return Role.isCompatibleWith(this, other);
    }

    public static boolean isCompatibleWith(Role role1, Role role2) {
        if (role1 == null) {
            return role2 == null;
        }
        if (role2 == null) {
            return false;
        }
        return role1 == role2 || role1.getDowngrade() == role2 || role2.getDowngrade() == role1;
    }

    public static List<AbstractGoods> getGoodsDifference(Role from, int fromCount, Role to, int toCount) {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        if (!(from == to || from == null && to.isDefaultRole())) {
            List<Object> fromGoods = from == null ? new ArrayList() : from.getRequiredGoods(fromCount);
            List<AbstractGoods> toGoods = to.getRequiredGoods(toCount);
            for (AbstractGoods abstractGoods : toGoods) {
                int amount = abstractGoods.getAmount() - AbstractGoods.getCount(abstractGoods.getType(), fromGoods);
                if (amount == 0) continue;
                result.add(new AbstractGoods(abstractGoods.getType(), amount));
            }
            for (AbstractGoods abstractGoods : fromGoods) {
                if (AbstractGoods.containsType(abstractGoods.getType(), toGoods)) continue;
                result.add(new AbstractGoods(abstractGoods.getType(), -abstractGoods.getAmount()));
            }
        }
        return result;
    }

    private int getAbilityIndex() {
        if (this.requiresAbility("model.ability.native")) {
            return 10;
        }
        if (this.requiresAbility("model.ability.refUnit")) {
            return 5;
        }
        return 0;
    }

    public static List<Role> getAvailableRoles(Player player, UnitType type, List<Role> roles) {
        return roles.stream().filter(r -> r.isAvailableTo(player, type)).collect(Collectors.toList());
    }

    public String toFullString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[Role ").append(this.getSuffix());
        for (Map.Entry<String, Boolean> entry : this.getRequiredAbilities().entrySet()) {
            sb.append(" ").append(entry.getKey()).append("=").append(entry.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(FreeColObject other) {
        Role role;
        int cmp = 0;
        if (other instanceof Role && (cmp = (role = (Role)other).getAbilityIndex() - this.getAbilityIndex()) == 0) {
            cmp = role.getRequiredGoods().size() - this.getRequiredGoods().size();
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.downgrade != null) {
            xw.writeAttribute(DOWNGRADE_TAG, this.downgrade);
        }
        if (this.expertUnit != null) {
            xw.writeAttribute(EXPERT_UNIT_TAG, this.expertUnit);
        }
        if (this.maximumCount > 1) {
            xw.writeAttribute(MAXIMUM_COUNT_TAG, this.maximumCount);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (RoleChange rc : this.getRoleChanges()) {
            xw.writeStartElement(ROLE_CHANGE_TAG);
            xw.writeAttribute(FROM_TAG, rc.from);
            xw.writeAttribute(CAPTURE_TAG, rc.capture);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.downgrade = xr.getType(spec, DOWNGRADE_TAG, Role.class, null);
        this.expertUnit = xr.hasAttribute(OLD_EXPERT_UNIT_TAG) ? xr.getType(spec, OLD_EXPERT_UNIT_TAG, UnitType.class, null) : xr.getType(spec, EXPERT_UNIT_TAG, UnitType.class, null);
        this.maximumCount = xr.hasAttribute(OLD_MAXIMUM_COUNT_TAG) ? xr.getAttribute(OLD_MAXIMUM_COUNT_TAG, 1) : xr.getAttribute(MAXIMUM_COUNT_TAG, 1);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.roleChanges = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (ROLE_CHANGE_TAG.equals(tag)) {
            String from = xr.getAttribute(FROM_TAG, null);
            String capture = xr.getAttribute(CAPTURE_TAG, null);
            this.addRoleChange(from, capture);
            xr.closeTag(ROLE_CHANGE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return Role.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "role";
    }

    public static class RoleChange {
        public final String from;
        public final String capture;

        RoleChange(String from, String capture) {
            this.from = from;
            this.capture = capture;
        }

        public Role getFrom(Specification spec) {
            return spec.getRole(this.from);
        }

        public Role getCapture(Specification spec) {
            return spec.getRole(this.capture);
        }
    }
}

