/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.views;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.provider.SetProperty;

@NotThreadSafe
public class SetPropertySetView<E>
extends AbstractSet<E> {
    private final SetProperty<E> delegate;

    public SetPropertySetView(SetProperty<E> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean add(E e) {
        boolean added = !this.contains(e);
        this.delegate.add(e);
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = false;
        for (E e : c) {
            added |= this.add(e);
        }
        return added;
    }

    @Override
    public boolean contains(Object o) {
        return ((Set)this.delegate.get()).contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((Set)this.delegate.get()).containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        LinkedHashSet set = new LinkedHashSet((Collection)this.delegate.get());
        boolean removed = set.remove(o);
        this.delegate.set(set);
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        LinkedHashSet set = new LinkedHashSet((Collection)this.delegate.get());
        boolean removed = set.removeAll(c);
        this.delegate.set(set);
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        LinkedHashSet set = new LinkedHashSet((Collection)this.delegate.get());
        boolean removed = set.retainAll(c);
        this.delegate.set(set);
        return removed;
    }

    @Override
    public void clear() {
        this.delegate.empty();
    }

    @Override
    public Iterator<E> iterator() {
        LinkedHashSet set = new LinkedHashSet((Collection)this.delegate.get());
        final Iterator it = set.iterator();
        return new Iterator<E>(){
            E previousValue = null;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                this.previousValue = it.next();
                return this.previousValue;
            }

            @Override
            public void remove() {
                it.remove();
                SetPropertySetView.this.remove(this.previousValue);
            }
        };
    }

    @Override
    public int size() {
        return ((Set)this.delegate.get()).size();
    }
}

