/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.client.impl.DefaultSftpClient;

public class DefaultSftpClientFactory
extends AbstractLoggingBean
implements SftpClientFactory {
    public static final DefaultSftpClientFactory INSTANCE = new DefaultSftpClientFactory();

    @Override
    public SftpClient createSftpClient(ClientSession session, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        DefaultSftpClient client = this.createDefaultSftpClient(session, selector, errorDataHandler);
        try {
            client.negotiateVersion(selector);
        }
        catch (IOException | Error | RuntimeException e) {
            this.debug("createSftpClient({}) failed ({}) to negotiate version: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
            client.close();
            throw e;
        }
        return client;
    }

    protected DefaultSftpClient createDefaultSftpClient(ClientSession session, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        return new DefaultSftpClient(session, selector, errorDataHandler);
    }

    @Override
    public SftpFileSystem createSftpFileSystem(ClientSession session, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler, int readBufferSize, int writeBufferSize) throws IOException {
        ClientFactoryManager manager = session.getFactoryManager();
        SftpFileSystemProvider provider = new SftpFileSystemProvider((SshClient)manager, selector, errorDataHandler);
        SftpFileSystem fs = provider.newFileSystem(session);
        if (readBufferSize > 0) {
            fs.setReadBufferSize(readBufferSize);
        }
        if (writeBufferSize > 0) {
            fs.setWriteBufferSize(writeBufferSize);
        }
        return fs;
    }
}

