/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket.internals;

import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.core.BytePacketBuilderExtensions_jvmKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.websocket.internals.BytePacketUtilsKt;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u001b\u0010\u0003\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0006\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a+\u0010\u000f\u001a\u00020\u000e*\u00020\b2\u0006\u0010\t\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\"\u0014\u0010\u0011\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Ljava/util/zip/Deflater;", "", "data", "deflateFully", "(Ljava/util/zip/Deflater;[B)[B", "Ljava/util/zip/Inflater;", "inflateFully", "(Ljava/util/zip/Inflater;[B)[B", "Lkotlinx/io/Sink;", "deflater", "Ljava/nio/ByteBuffer;", "buffer", "", "flush", "", "deflateTo", "(Lkotlinx/io/Sink;Ljava/util/zip/Deflater;Ljava/nio/ByteBuffer;Z)I", "PADDED_EMPTY_CHUNK", "[B", "EMPTY_CHUNK", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nDeflaterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Pool.kt\nio/ktor/utils/io/pool/PoolKt\n*L\n1#1,86:1\n15#2,2:87\n17#2:94\n15#2,3:95\n15#2,2:98\n17#2:105\n156#3,5:89\n156#3,5:100\n*S KotlinDebug\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n*L\n20#1:87,2\n20#1:94\n36#1:95,3\n46#1:98,2\n46#1:105\n21#1:89,5\n47#1:100,5\n*E\n"})
public final class DeflaterUtilsKt {
    @NotNull
    private static final byte[] PADDED_EMPTY_CHUNK;
    @NotNull
    private static final byte[] EMPTY_CHUNK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] deflateFully(@NotNull Deflater $this$deflateFully, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)$this$deflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $this$deflateFully.setInput(data);
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$deflateFully_u24lambda_u241 = (Sink)builder$iv;
        boolean bl = false;
        ObjectPool $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
        boolean $i$f$useInstance = false;
        Object instance$iv = $this$useInstance$iv.borrow();
        try {
            ByteBuffer buffer = (ByteBuffer)instance$iv;
            boolean bl2 = false;
            while (!$this$deflateFully.needsInput()) {
                DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, false);
            }
            while (DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, true) != 0) {
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$useInstance$iv.recycle(instance$iv);
        }
        Source deflatedBytes = (Source)builder$iv;
        if (BytePacketUtilsKt.endsWith(deflatedBytes, PADDED_EMPTY_CHUNK)) {
            byte[] it = $i$f$buildPacket = SourcesKt.readByteArray((Source)deflatedBytes, (int)((int)ByteReadPacketKt.getRemaining((Source)deflatedBytes) - EMPTY_CHUNK.length));
            boolean bl3 = false;
            deflatedBytes.close();
            return $i$f$buildPacket;
        }
        $i$f$buildPacket = false;
        builder$iv = new Buffer();
        Sink $this$deflateFully_u24lambda_u243 = (Sink)builder$iv;
        boolean bl4 = false;
        BytePacketBuilderKt.writePacket((Sink)$this$deflateFully_u24lambda_u243, (Source)deflatedBytes);
        $this$deflateFully_u24lambda_u243.writeByte((byte)0);
        return SourcesKt.readByteArray((Source)((Source)builder$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] inflateFully(@NotNull Inflater $this$inflateFully, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)$this$inflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] dataToInflate = ArraysKt.plus((byte[])data, (byte[])EMPTY_CHUNK);
        $this$inflateFully.setInput(dataToInflate);
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$inflateFully_u24lambda_u245 = (Sink)builder$iv;
        boolean bl = false;
        ObjectPool $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
        boolean $i$f$useInstance = false;
        Object instance$iv = $this$useInstance$iv.borrow();
        try {
            ByteBuffer buffer = (ByteBuffer)instance$iv;
            boolean bl2 = false;
            long limit = (long)dataToInflate.length + $this$inflateFully.getBytesRead();
            while ($this$inflateFully.getBytesRead() < limit) {
                buffer.clear();
                int inflated = $this$inflateFully.inflate(buffer.array(), buffer.position(), buffer.limit());
                buffer.position(buffer.position() + inflated);
                buffer.flip();
                BytePacketBuilderExtensions_jvmKt.writeFully((Sink)$this$inflateFully_u24lambda_u245, (ByteBuffer)buffer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$useInstance$iv.recycle(instance$iv);
        }
        Source packet = (Source)builder$iv;
        return SourcesKt.readByteArray((Source)packet);
    }

    private static final int deflateTo(Sink $this$deflateTo, Deflater deflater, ByteBuffer buffer, boolean flush2) {
        int deflated;
        buffer.clear();
        int n = deflated = flush2 ? deflater.deflate(buffer.array(), buffer.position(), buffer.limit(), 2) : deflater.deflate(buffer.array(), buffer.position(), buffer.limit());
        if (deflated == 0) {
            return 0;
        }
        buffer.position(buffer.position() + deflated);
        buffer.flip();
        BytePacketBuilderExtensions_jvmKt.writeFully((Sink)$this$deflateTo, (ByteBuffer)buffer);
        return deflated;
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, -1, -1};
        PADDED_EMPTY_CHUNK = byArray;
        byArray = new byte[]{0, 0, -1, -1};
        EMPTY_CHUNK = byArray;
    }
}

