/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;

public class ForceRequestHeaderValueRule
extends Rule {
    private String headerName;
    private String forcedValue;

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getForcedValue() {
        return this.forcedValue;
    }

    public void setForcedValue(String forcedValue) {
        this.forcedValue = forcedValue;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String existingValue = httpServletRequest.getHeader(this.headerName);
        if (existingValue == null) {
            return null;
        }
        if (existingValue.equals(this.forcedValue)) {
            return null;
        }
        Request baseRequest = Request.getBaseRequest(httpServletRequest);
        if (baseRequest == null) {
            return null;
        }
        HttpFields.Mutable replacement = HttpFields.build(baseRequest.getHttpFields()).remove(this.headerName).add(this.headerName, this.forcedValue);
        baseRequest.setHttpFields(replacement);
        return target;
    }
}

