/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleContainer
extends Rule
implements Dumpable {
    public static final String ORIGINAL_QUERYSTRING_ATTRIBUTE_SUFFIX = ".QUERYSTRING";
    private static final Logger LOG = LoggerFactory.getLogger(RuleContainer.class);
    protected Rule[] _rules;
    protected String _originalPathAttribute;
    protected String _originalQueryStringAttribute;
    protected boolean _rewriteRequestURI = true;
    protected boolean _rewritePathInfo = true;

    public Rule[] getRules() {
        return this._rules;
    }

    public void setRules(Rule[] rules) {
        this._rules = rules;
    }

    public void addRule(Rule rule) {
        this._rules = ArrayUtil.addToArray(this._rules, rule, Rule.class);
    }

    public boolean isRewriteRequestURI() {
        return this._rewriteRequestURI;
    }

    public void setRewriteRequestURI(boolean rewriteRequestURI) {
        this._rewriteRequestURI = rewriteRequestURI;
    }

    public boolean isRewritePathInfo() {
        return this._rewritePathInfo;
    }

    public void setRewritePathInfo(boolean rewritePathInfo) {
        this._rewritePathInfo = rewritePathInfo;
    }

    public String getOriginalPathAttribute() {
        return this._originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribte) {
        this._originalPathAttribute = originalPathAttribte;
        this._originalQueryStringAttribute = originalPathAttribte + ORIGINAL_QUERYSTRING_ATTRIBUTE_SUFFIX;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.apply(target, request, response);
    }

    protected String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean originalSet;
        boolean bl = originalSet = this._originalPathAttribute == null;
        if (this._rules == null) {
            return target;
        }
        for (Rule rule : this._rules) {
            String applied = rule.matchAndApply(target, request, response);
            if (applied == null) continue;
            LOG.debug("applied {}", (Object)rule);
            LOG.debug("rewrote {} to {}", (Object)target, (Object)applied);
            if (!originalSet) {
                originalSet = true;
                request.setAttribute(this._originalPathAttribute, target);
                String query = request.getQueryString();
                if (query != null) {
                    request.setAttribute(this._originalQueryStringAttribute, query);
                }
            }
            Request baseRequest = Request.getBaseRequest(request);
            if (this._rewriteRequestURI) {
                String encoded = URIUtil.encodePath(applied);
                if (rule instanceof Rule.ApplyURI) {
                    ((Rule.ApplyURI)((Object)rule)).applyURI(baseRequest, baseRequest.getRequestURI(), encoded);
                } else {
                    HttpURI baseUri = baseRequest.getHttpURI();
                    baseRequest.setHttpURI(HttpURI.build(baseUri, encoded).param(baseUri.getParam()).query(baseUri.getQuery()));
                }
            }
            if (this._rewritePathInfo) {
                baseRequest.setContext(baseRequest.getContext(), applied);
            }
            target = applied;
            if (rule.isHandling()) {
                LOG.debug("handling {}", (Object)rule);
                baseRequest.setHandled(true);
            }
            if (!rule.isTerminating()) continue;
            LOG.debug("terminating {}", (Object)rule);
            break;
        }
        return target;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this._rules);
    }
}

