/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001a\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/InterArrivalDelta;", "", "sendTimeGroupLength", "Ljava/time/Duration;", "<init>", "(Ljava/time/Duration;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "currentTimestampGroup", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/InterArrivalDelta$SendTimeGroup;", "prevTimestampGroup", "numConsecutiveReorderedPackets", "", "computeDeltas", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/InterArrivalDelta$ComputeDeltasResult;", "sendTime", "Ljava/time/Instant;", "arrivalTime", "systemTime", "packetSize", "", "newTimestampGroup", "", "belongsToBurst", "reset", "", "ComputeDeltasResult", "SendTimeGroup", "Companion", "jitsi-media-transform"})
public final class InterArrivalDelta {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration sendTimeGroupLength;
    @NotNull
    private final Logger logger;
    @NotNull
    private SendTimeGroup currentTimestampGroup;
    @NotNull
    private SendTimeGroup prevTimestampGroup;
    private int numConsecutiveReorderedPackets;
    public static final int kReorderedResetThreshold = 3;
    @NotNull
    private static final Duration kArrivalTimeOffsetThreshold = DurationKt.getSecs(3);
    @NotNull
    private static final Duration kBurstDeltaThreshold = DurationKt.getMs(5);
    @NotNull
    private static final Duration kMaxBurstDuration = DurationKt.getMs(100);

    public InterArrivalDelta(@NotNull Duration sendTimeGroupLength) {
        Intrinsics.checkNotNullParameter(sendTimeGroupLength, "sendTimeGroupLength");
        this.sendTimeGroupLength = sendTimeGroupLength;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.currentTimestampGroup = new SendTimeGroup(0L, null, null, null, null, null, 63, null);
        this.prevTimestampGroup = new SendTimeGroup(0L, null, null, null, null, null, 63, null);
    }

    @NotNull
    public final ComputeDeltasResult computeDeltas(@NotNull Instant sendTime, @NotNull Instant arrivalTime, @NotNull Instant systemTime, long packetSize) {
        Intrinsics.checkNotNullParameter(sendTime, "sendTime");
        Intrinsics.checkNotNullParameter(arrivalTime, "arrivalTime");
        Intrinsics.checkNotNullParameter(systemTime, "systemTime");
        Duration sendTimeDelta = Duration.ZERO;
        Duration arrivalTimeDelta = Duration.ZERO;
        int packetSizeDelta = 0;
        boolean calculatedDeltas = false;
        if (this.currentTimestampGroup.isFirstPacket()) {
            this.currentTimestampGroup.setSendTime(sendTime);
            this.currentTimestampGroup.setFirstSendTime(sendTime);
            this.currentTimestampGroup.setFirstArrival(arrivalTime);
        } else {
            if (this.currentTimestampGroup.getFirstSendTime().compareTo(sendTime) > 0) {
                return new ComputeDeltasResult(false, null, null, 0, 14, null);
            }
            if (this.newTimestampGroup(arrivalTime, sendTime)) {
                if (!Intrinsics.areEqual(this.prevTimestampGroup.getCompleteTime(), InstantKt.NEVER)) {
                    Duration systemTimeDelta;
                    sendTimeDelta = Duration.between(this.prevTimestampGroup.getSendTime(), this.currentTimestampGroup.getSendTime());
                    arrivalTimeDelta = Duration.between(this.prevTimestampGroup.getCompleteTime(), this.currentTimestampGroup.getCompleteTime());
                    if (arrivalTimeDelta.minus(systemTimeDelta = Duration.between(this.prevTimestampGroup.getLastSystemTime(), this.currentTimestampGroup.getLastSystemTime())).compareTo(kArrivalTimeOffsetThreshold) >= 0) {
                        this.logger.warn("The arrival clock offset has changed (diff = " + arrivalTimeDelta.minus(systemTimeDelta) + "), resetting");
                        this.reset();
                        return new ComputeDeltasResult(false, null, null, 0, 14, null);
                    }
                    if (arrivalTimeDelta.compareTo(Duration.ZERO) < 0) {
                        ++this.numConsecutiveReorderedPackets;
                        if (this.numConsecutiveReorderedPackets >= 3) {
                            this.logger.warn("Packets between send burst arrived out of order, restting: arrivalTimeDelta=" + arrivalTimeDelta + ", sendTimeDelta=" + sendTimeDelta);
                            this.reset();
                        }
                        return new ComputeDeltasResult(false, null, null, 0, 14, null);
                    }
                    this.numConsecutiveReorderedPackets = 0;
                    packetSizeDelta = (int)this.currentTimestampGroup.getSize() - (int)this.prevTimestampGroup.getSize();
                    calculatedDeltas = true;
                }
                this.prevTimestampGroup = SendTimeGroup.copy$default(this.currentTimestampGroup, 0L, null, null, null, null, null, 63, null);
                this.currentTimestampGroup.setFirstSendTime(sendTime);
                this.currentTimestampGroup.setSendTime(sendTime);
                this.currentTimestampGroup.setFirstArrival(arrivalTime);
                this.currentTimestampGroup.setSize(0L);
            } else {
                this.currentTimestampGroup.setSendTime(InstantKt.max(this.currentTimestampGroup.getSendTime(), sendTime));
            }
        }
        Object object = this.currentTimestampGroup;
        ((SendTimeGroup)object).setSize(((SendTimeGroup)object).getSize() + packetSize);
        this.currentTimestampGroup.setCompleteTime(arrivalTime);
        this.currentTimestampGroup.setLastSystemTime(systemTime);
        object = sendTimeDelta;
        Intrinsics.checkNotNull(object);
        Object object2 = object;
        object = arrivalTimeDelta;
        Intrinsics.checkNotNull(object);
        return new ComputeDeltasResult(calculatedDeltas, (Duration)object2, (Duration)object, packetSizeDelta);
    }

    private final boolean newTimestampGroup(Instant arrivalTime, Instant sendTime) {
        if (this.currentTimestampGroup.isFirstPacket()) {
            return false;
        }
        if (this.belongsToBurst(arrivalTime, sendTime)) {
            return false;
        }
        return Duration.between(this.currentTimestampGroup.getFirstSendTime(), sendTime).compareTo(this.sendTimeGroupLength) > 0;
    }

    private final boolean belongsToBurst(Instant arrivalTime, Instant sendTime) {
        if (!(!Intrinsics.areEqual(this.currentTimestampGroup.getCompleteTime(), InstantKt.NEVER))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Duration arrivalTimeDelta = Duration.between(this.currentTimestampGroup.getCompleteTime(), arrivalTime);
        Duration sendTimeDelta = Duration.between(this.currentTimestampGroup.getSendTime(), sendTime);
        if (Intrinsics.areEqual(sendTimeDelta, Duration.ZERO)) {
            return true;
        }
        Duration propagationDelta = arrivalTimeDelta.minus(sendTimeDelta);
        return propagationDelta.compareTo(Duration.ZERO) < 0 && arrivalTimeDelta.compareTo(kBurstDeltaThreshold) <= 0 && Duration.between(this.currentTimestampGroup.getFirstArrival(), arrivalTime).compareTo(kMaxBurstDuration) < 0;
    }

    private final void reset() {
        this.numConsecutiveReorderedPackets = 0;
        this.currentTimestampGroup = new SendTimeGroup(0L, null, null, null, null, null, 63, null);
        this.prevTimestampGroup = new SendTimeGroup(0L, null, null, null, null, null, 63, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/InterArrivalDelta$Companion;", "", "<init>", "()V", "kReorderedResetThreshold", "", "kArrivalTimeOffsetThreshold", "Ljava/time/Duration;", "getKArrivalTimeOffsetThreshold", "()Ljava/time/Duration;", "kBurstDeltaThreshold", "getKBurstDeltaThreshold", "kMaxBurstDuration", "getKMaxBurstDuration", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getKArrivalTimeOffsetThreshold() {
            return kArrivalTimeOffsetThreshold;
        }

        @NotNull
        public final Duration getKBurstDeltaThreshold() {
            return kBurstDeltaThreshold;
        }

        @NotNull
        public final Duration getKMaxBurstDuration() {
            return kMaxBurstDuration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/InterArrivalDelta$ComputeDeltasResult;", "", "computed", "", "sendTimeDelta", "Ljava/time/Duration;", "arrivalTimeDelta", "packetSizeDelta", "", "<init>", "(ZLjava/time/Duration;Ljava/time/Duration;I)V", "getComputed", "()Z", "getSendTimeDelta", "()Ljava/time/Duration;", "getArrivalTimeDelta", "getPacketSizeDelta", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "jitsi-media-transform"})
    public static final class ComputeDeltasResult {
        private final boolean computed;
        @NotNull
        private final Duration sendTimeDelta;
        @NotNull
        private final Duration arrivalTimeDelta;
        private final int packetSizeDelta;

        public ComputeDeltasResult(boolean computed, @NotNull Duration sendTimeDelta, @NotNull Duration arrivalTimeDelta, int packetSizeDelta) {
            Intrinsics.checkNotNullParameter(sendTimeDelta, "sendTimeDelta");
            Intrinsics.checkNotNullParameter(arrivalTimeDelta, "arrivalTimeDelta");
            this.computed = computed;
            this.sendTimeDelta = sendTimeDelta;
            this.arrivalTimeDelta = arrivalTimeDelta;
            this.packetSizeDelta = packetSizeDelta;
        }

        public /* synthetic */ ComputeDeltasResult(boolean bl, Duration duration, Duration duration2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n2 & 2) != 0) {
                duration = Duration.ZERO;
            }
            if ((n2 & 4) != 0) {
                duration2 = Duration.ZERO;
            }
            if ((n2 & 8) != 0) {
                n = 0;
            }
            this(bl, duration, duration2, n);
        }

        public final boolean getComputed() {
            return this.computed;
        }

        @NotNull
        public final Duration getSendTimeDelta() {
            return this.sendTimeDelta;
        }

        @NotNull
        public final Duration getArrivalTimeDelta() {
            return this.arrivalTimeDelta;
        }

        public final int getPacketSizeDelta() {
            return this.packetSizeDelta;
        }

        public final boolean component1() {
            return this.computed;
        }

        @NotNull
        public final Duration component2() {
            return this.sendTimeDelta;
        }

        @NotNull
        public final Duration component3() {
            return this.arrivalTimeDelta;
        }

        public final int component4() {
            return this.packetSizeDelta;
        }

        @NotNull
        public final ComputeDeltasResult copy(boolean computed, @NotNull Duration sendTimeDelta, @NotNull Duration arrivalTimeDelta, int packetSizeDelta) {
            Intrinsics.checkNotNullParameter(sendTimeDelta, "sendTimeDelta");
            Intrinsics.checkNotNullParameter(arrivalTimeDelta, "arrivalTimeDelta");
            return new ComputeDeltasResult(computed, sendTimeDelta, arrivalTimeDelta, packetSizeDelta);
        }

        public static /* synthetic */ ComputeDeltasResult copy$default(ComputeDeltasResult computeDeltasResult, boolean bl, Duration duration, Duration duration2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = computeDeltasResult.computed;
            }
            if ((n2 & 2) != 0) {
                duration = computeDeltasResult.sendTimeDelta;
            }
            if ((n2 & 4) != 0) {
                duration2 = computeDeltasResult.arrivalTimeDelta;
            }
            if ((n2 & 8) != 0) {
                n = computeDeltasResult.packetSizeDelta;
            }
            return computeDeltasResult.copy(bl, duration, duration2, n);
        }

        @NotNull
        public String toString() {
            return "ComputeDeltasResult(computed=" + this.computed + ", sendTimeDelta=" + this.sendTimeDelta + ", arrivalTimeDelta=" + this.arrivalTimeDelta + ", packetSizeDelta=" + this.packetSizeDelta + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.computed);
            result = result * 31 + this.sendTimeDelta.hashCode();
            result = result * 31 + this.arrivalTimeDelta.hashCode();
            result = result * 31 + Integer.hashCode(this.packetSizeDelta);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComputeDeltasResult)) {
                return false;
            }
            ComputeDeltasResult computeDeltasResult = (ComputeDeltasResult)other;
            if (this.computed != computeDeltasResult.computed) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sendTimeDelta, computeDeltasResult.sendTimeDelta)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.arrivalTimeDelta, computeDeltasResult.arrivalTimeDelta)) {
                return false;
            }
            return this.packetSizeDelta == computeDeltasResult.packetSizeDelta;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003JE\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u001d2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006+"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/InterArrivalDelta$SendTimeGroup;", "", "size", "", "firstSendTime", "Ljava/time/Instant;", "sendTime", "firstArrival", "completeTime", "lastSystemTime", "<init>", "(JLjava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;)V", "getSize", "()J", "setSize", "(J)V", "getFirstSendTime", "()Ljava/time/Instant;", "setFirstSendTime", "(Ljava/time/Instant;)V", "getSendTime", "setSendTime", "getFirstArrival", "setFirstArrival", "getCompleteTime", "setCompleteTime", "getLastSystemTime", "setLastSystemTime", "isFirstPacket", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    public static final class SendTimeGroup {
        private long size;
        @NotNull
        private Instant firstSendTime;
        @NotNull
        private Instant sendTime;
        @NotNull
        private Instant firstArrival;
        @NotNull
        private Instant completeTime;
        @NotNull
        private Instant lastSystemTime;

        public SendTimeGroup(long size, @NotNull Instant firstSendTime, @NotNull Instant sendTime, @NotNull Instant firstArrival, @NotNull Instant completeTime, @NotNull Instant lastSystemTime) {
            Intrinsics.checkNotNullParameter(firstSendTime, "firstSendTime");
            Intrinsics.checkNotNullParameter(sendTime, "sendTime");
            Intrinsics.checkNotNullParameter(firstArrival, "firstArrival");
            Intrinsics.checkNotNullParameter(completeTime, "completeTime");
            Intrinsics.checkNotNullParameter(lastSystemTime, "lastSystemTime");
            this.size = size;
            this.firstSendTime = firstSendTime;
            this.sendTime = sendTime;
            this.firstArrival = firstArrival;
            this.completeTime = completeTime;
            this.lastSystemTime = lastSystemTime;
        }

        public /* synthetic */ SendTimeGroup(long l, Instant instant, Instant instant2, Instant instant3, Instant instant4, Instant instant5, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                instant = InstantKt.NEVER;
            }
            if ((n & 4) != 0) {
                instant2 = InstantKt.NEVER;
            }
            if ((n & 8) != 0) {
                instant3 = InstantKt.NEVER;
            }
            if ((n & 0x10) != 0) {
                instant4 = InstantKt.NEVER;
            }
            if ((n & 0x20) != 0) {
                instant5 = InstantKt.NEVER;
            }
            this(l, instant, instant2, instant3, instant4, instant5);
        }

        public final long getSize() {
            return this.size;
        }

        public final void setSize(long l) {
            this.size = l;
        }

        @NotNull
        public final Instant getFirstSendTime() {
            return this.firstSendTime;
        }

        public final void setFirstSendTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.firstSendTime = instant;
        }

        @NotNull
        public final Instant getSendTime() {
            return this.sendTime;
        }

        public final void setSendTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.sendTime = instant;
        }

        @NotNull
        public final Instant getFirstArrival() {
            return this.firstArrival;
        }

        public final void setFirstArrival(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.firstArrival = instant;
        }

        @NotNull
        public final Instant getCompleteTime() {
            return this.completeTime;
        }

        public final void setCompleteTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.completeTime = instant;
        }

        @NotNull
        public final Instant getLastSystemTime() {
            return this.lastSystemTime;
        }

        public final void setLastSystemTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.lastSystemTime = instant;
        }

        public final boolean isFirstPacket() {
            return Intrinsics.areEqual(this.completeTime, InstantKt.NEVER);
        }

        public final long component1() {
            return this.size;
        }

        @NotNull
        public final Instant component2() {
            return this.firstSendTime;
        }

        @NotNull
        public final Instant component3() {
            return this.sendTime;
        }

        @NotNull
        public final Instant component4() {
            return this.firstArrival;
        }

        @NotNull
        public final Instant component5() {
            return this.completeTime;
        }

        @NotNull
        public final Instant component6() {
            return this.lastSystemTime;
        }

        @NotNull
        public final SendTimeGroup copy(long size, @NotNull Instant firstSendTime, @NotNull Instant sendTime, @NotNull Instant firstArrival, @NotNull Instant completeTime, @NotNull Instant lastSystemTime) {
            Intrinsics.checkNotNullParameter(firstSendTime, "firstSendTime");
            Intrinsics.checkNotNullParameter(sendTime, "sendTime");
            Intrinsics.checkNotNullParameter(firstArrival, "firstArrival");
            Intrinsics.checkNotNullParameter(completeTime, "completeTime");
            Intrinsics.checkNotNullParameter(lastSystemTime, "lastSystemTime");
            return new SendTimeGroup(size, firstSendTime, sendTime, firstArrival, completeTime, lastSystemTime);
        }

        public static /* synthetic */ SendTimeGroup copy$default(SendTimeGroup sendTimeGroup, long l, Instant instant, Instant instant2, Instant instant3, Instant instant4, Instant instant5, int n, Object object) {
            if ((n & 1) != 0) {
                l = sendTimeGroup.size;
            }
            if ((n & 2) != 0) {
                instant = sendTimeGroup.firstSendTime;
            }
            if ((n & 4) != 0) {
                instant2 = sendTimeGroup.sendTime;
            }
            if ((n & 8) != 0) {
                instant3 = sendTimeGroup.firstArrival;
            }
            if ((n & 0x10) != 0) {
                instant4 = sendTimeGroup.completeTime;
            }
            if ((n & 0x20) != 0) {
                instant5 = sendTimeGroup.lastSystemTime;
            }
            return sendTimeGroup.copy(l, instant, instant2, instant3, instant4, instant5);
        }

        @NotNull
        public String toString() {
            return "SendTimeGroup(size=" + this.size + ", firstSendTime=" + this.firstSendTime + ", sendTime=" + this.sendTime + ", firstArrival=" + this.firstArrival + ", completeTime=" + this.completeTime + ", lastSystemTime=" + this.lastSystemTime + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.size);
            result = result * 31 + this.firstSendTime.hashCode();
            result = result * 31 + this.sendTime.hashCode();
            result = result * 31 + this.firstArrival.hashCode();
            result = result * 31 + this.completeTime.hashCode();
            result = result * 31 + this.lastSystemTime.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SendTimeGroup)) {
                return false;
            }
            SendTimeGroup sendTimeGroup = (SendTimeGroup)other;
            if (this.size != sendTimeGroup.size) {
                return false;
            }
            if (!Intrinsics.areEqual(this.firstSendTime, sendTimeGroup.firstSendTime)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sendTime, sendTimeGroup.sendTime)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.firstArrival, sendTimeGroup.firstArrival)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.completeTime, sendTimeGroup.completeTime)) {
                return false;
            }
            return Intrinsics.areEqual(this.lastSystemTime, sendTimeGroup.lastSystemTime);
        }

        public SendTimeGroup() {
            this(0L, null, null, null, null, null, 63, null);
        }
    }
}

