/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.AcknowledgedBitrateEstimatorInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.rtp.bandwidthestimation2.RobustThroughputEstimatorKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.RobustThroughputEstimatorSettings;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\b\u0011J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/RobustThroughputEstimator;", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AcknowledgedBitrateEstimatorInterface;", "settings", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/RobustThroughputEstimatorSettings;", "<init>", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/RobustThroughputEstimatorSettings;)V", "getSettings", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/RobustThroughputEstimatorSettings;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "incomingPacketFeedbackVector", "", "packetFeedbackVector", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketResult;", "bitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "bitrate-4yB3KFE", "peekRate", "peekRate-4yB3KFE", "setAlr", "inAlr", "", "setAlrEndedTime", "alrEndedTime", "Ljava/time/Instant;", "firstPacketOutsideWindow", "window", "Lkotlin/collections/ArrayDeque;", "latestDiscardedSendTime", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRobustThroughputEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RobustThroughputEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/RobustThroughputEstimator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1863#2,2:235\n1863#2,2:237\n*S KotlinDebug\n*F\n+ 1 RobustThroughputEstimator.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/RobustThroughputEstimator\n*L\n53#1:235,2\n121#1:237,2\n*E\n"})
public final class RobustThroughputEstimator
implements AcknowledgedBitrateEstimatorInterface {
    @NotNull
    private final RobustThroughputEstimatorSettings settings;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ArrayDeque<PacketResult> window;
    @NotNull
    private Instant latestDiscardedSendTime;

    public RobustThroughputEstimator(@NotNull RobustThroughputEstimatorSettings settings) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        this.settings = settings;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        if (!this.settings.getEnabled()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.window = new ArrayDeque();
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue(instant, "MIN");
        this.latestDiscardedSendTime = instant;
    }

    @NotNull
    public final RobustThroughputEstimatorSettings getSettings() {
        return this.settings;
    }

    @Override
    public void incomingPacketFeedbackVector(@NotNull List<PacketResult> packetFeedbackVector) {
        Intrinsics.checkNotNullParameter(packetFeedbackVector, "packetFeedbackVector");
        if (!RobustThroughputEstimatorKt.isSorted((Collection)packetFeedbackVector, new Comparator(){

            public final int compare(T a, T b) {
                PacketResult it = (PacketResult)a;
                boolean bl = false;
                Comparable comparable = it.getReceiveTime();
                it = (PacketResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)it.getReceiveTime());
            }
        })) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable $this$forEach$iv = packetFeedbackVector;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketResult packet = (PacketResult)element$iv;
            boolean bl = false;
            if (InstantKt.isInfinite(packet.getReceiveTime()) || InstantKt.isInfinite(packet.getSentPacket().getSendTime())) continue;
            this.window.addLast(packet);
            this.window.last().getSentPacket().setPriorUnackedData(this.window.last().getSentPacket().getPriorUnackedData().times(this.settings.getUnackedWeight()));
            for (int i = this.window.size() - 1; i > 0 && this.window.get(i).getReceiveTime().compareTo(this.window.get(i - 1).getReceiveTime()) < 0; --i) {
                Collections.swap((List)this.window, i, i - 1);
            }
            Duration kMaxReorderingTime = DurationKt.getSecs(1);
            Duration receiveDelta = Duration.between(packet.getReceiveTime(), this.window.last().getReceiveTime());
            if (receiveDelta.compareTo(kMaxReorderingTime) <= 0) continue;
            this.logger.warn("Severe packet re-ordering or timestamps offset changed: " + receiveDelta);
            this.window.clear();
            this.latestDiscardedSendTime = Instant.MIN;
        }
        while (this.firstPacketOutsideWindow()) {
            this.latestDiscardedSendTime = InstantKt.max(this.latestDiscardedSendTime, this.window.first().getSentPacket().getSendTime());
            this.window.removeFirst();
        }
    }

    @Override
    @Nullable
    public Bandwidth bitrate-4yB3KFE() {
        Object object;
        if (this.window.isEmpty() || this.window.size() < this.settings.getRequiredPackets()) {
            return null;
        }
        Duration largestRecvGap = Duration.ZERO;
        Duration secondLargestRecvGap = Duration.ZERO;
        int n = this.window.size();
        for (int i = 1; i < n; ++i) {
            Duration gap = Duration.between(this.window.get(i - 1).getReceiveTime(), this.window.get(i).getReceiveTime());
            if (gap.compareTo(largestRecvGap) > 0) {
                secondLargestRecvGap = largestRecvGap;
                largestRecvGap = gap;
                continue;
            }
            if (gap.compareTo(secondLargestRecvGap) <= 0) continue;
            secondLargestRecvGap = gap;
        }
        Instant firstSendTime = null;
        firstSendTime = Instant.MAX;
        Instant lastSendTime = null;
        lastSendTime = Instant.MIN;
        Instant firstRecvTime = null;
        firstRecvTime = Instant.MAX;
        Instant lastRecvTime = null;
        lastRecvTime = Instant.MIN;
        DataSize recvSize = null;
        recvSize = DataSizeKt.getBytes(0);
        DataSize sendSize = null;
        sendSize = DataSizeKt.getBytes(0);
        DataSize firstRecvSize = null;
        firstRecvSize = DataSizeKt.getBytes(0);
        DataSize lastSendSize = null;
        lastSendSize = DataSizeKt.getBytes(0);
        int numSentPacketsInWindow = 0;
        Iterable $this$forEach$iv = this.window;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketResult packet = (PacketResult)element$iv;
            boolean bl = false;
            if (packet.getReceiveTime().compareTo(firstRecvTime) < 0) {
                firstRecvTime = packet.getReceiveTime();
                firstRecvSize = packet.getSentPacket().getSize().plus(packet.getSentPacket().getPriorUnackedData());
            }
            Instant instant = lastRecvTime;
            Intrinsics.checkNotNullExpressionValue(instant, "element");
            lastRecvTime = InstantKt.max(instant, packet.getReceiveTime());
            recvSize = recvSize.plus(packet.getSentPacket().getSize());
            recvSize = recvSize.plus(packet.getSentPacket().getPriorUnackedData());
            if (packet.getSentPacket().getSendTime().compareTo(this.latestDiscardedSendTime) < 0) continue;
            if (packet.getSentPacket().getSendTime().compareTo(lastSendTime) > 0) {
                lastSendTime = packet.getSentPacket().getSendTime();
                lastSendSize = packet.getSentPacket().getSize().plus(packet.getSentPacket().getPriorUnackedData());
            }
            Instant instant2 = firstSendTime;
            Intrinsics.checkNotNullExpressionValue(instant2, "element");
            firstSendTime = InstantKt.min(instant2, packet.getSentPacket().getSendTime());
            sendSize = sendSize.plus(packet.getSentPacket().getSize());
            sendSize = sendSize.plus(packet.getSentPacket().getPriorUnackedData());
            ++numSentPacketsInWindow;
        }
        recvSize = recvSize.minus(firstRecvSize);
        sendSize = sendSize.minus(lastSendSize);
        Instant instant = firstRecvTime;
        Intrinsics.checkNotNullExpressionValue(instant, "element");
        if (!InstantKt.isFinite(instant)) {
            String $i$f$forEach2 = "Check failed.";
            throw new IllegalStateException($i$f$forEach2.toString());
        }
        Instant instant3 = lastRecvTime;
        Intrinsics.checkNotNullExpressionValue(instant3, "element");
        if (!InstantKt.isFinite(instant3)) {
            String $i$f$forEach2 = "Check failed.";
            throw new IllegalStateException($i$f$forEach2.toString());
        }
        Duration recvDuration = (Duration)RangesKt.coerceAtLeast((Comparable)Duration.between(firstRecvTime, lastRecvTime).minus(largestRecvGap).plus(secondLargestRecvGap), (Comparable)DurationKt.getMs(1));
        if (numSentPacketsInWindow < this.settings.getRequiredPackets()) {
            Intrinsics.checkNotNull(recvDuration);
            return Bandwidth.box-impl(BandwidthKt.per(recvSize, recvDuration));
        }
        Instant instant4 = firstSendTime;
        Intrinsics.checkNotNullExpressionValue(instant4, "element");
        if (!InstantKt.isFinite(instant4)) {
            object = "Check failed.";
            throw new IllegalStateException(object.toString());
        }
        Instant instant5 = lastSendTime;
        Intrinsics.checkNotNullExpressionValue(instant5, "element");
        if (!InstantKt.isFinite(instant5)) {
            object = "Check failed.";
            throw new IllegalStateException(object.toString());
        }
        Duration sendDuration = (Duration)RangesKt.coerceAtLeast((Comparable)Duration.between(firstSendTime, lastSendTime), (Comparable)DurationKt.getMs(1));
        Intrinsics.checkNotNull(sendDuration);
        long l = BandwidthKt.per(sendSize, sendDuration);
        Intrinsics.checkNotNull(recvDuration);
        return Bandwidth.box-impl(BandwidthKt.min-YUm52VA(l, BandwidthKt.per(recvSize, recvDuration)));
    }

    @Override
    @Nullable
    public Bandwidth peekRate-4yB3KFE() {
        return this.bitrate-4yB3KFE();
    }

    @Override
    public void setAlr(boolean inAlr) {
    }

    @Override
    public void setAlrEndedTime(@NotNull Instant alrEndedTime) {
        Intrinsics.checkNotNullParameter(alrEndedTime, "alrEndedTime");
    }

    private final boolean firstPacketOutsideWindow() {
        if (this.window.isEmpty()) {
            return false;
        }
        if (this.window.size() > this.settings.getMaxWindowPackets()) {
            return true;
        }
        Duration currentWindowDuration = Duration.between(this.window.first().getReceiveTime(), this.window.last().getReceiveTime());
        if (currentWindowDuration.compareTo(this.settings.getMaxWindowDuration()) > 0) {
            return true;
        }
        return this.window.size() > this.settings.getWindowPackets() && currentWindowDuration.compareTo(this.settings.getMinWindowDuration()) > 0;
    }
}

