/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.PacketOrigin;
import org.jitsi.nlj.rtp.bandwidthestimation2.InFlightBytesTracker;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacedPacketInfo;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketFeedback;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.rtp.bandwidthestimation2.SentPacket;
import org.jitsi.nlj.rtp.bandwidthestimation2.SentPacketInfo;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportFeedbackAdapterKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportPacketsFeedback;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.nlj.util.RtpSequenceIndexTracker;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.EcnMarking;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.ReceivedPacketInfo;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.RtcpFbCcfbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.PacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.ReceivedPacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.TimeUtils;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002?@B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0014J\u0006\u0010 \u001a\u00020\u0012J(\u0010!\u001a\u0004\u0018\u00010\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020&H\u0002J\u0006\u0010=\u001a\u00020>R\u001b\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010-\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010.\u001a\n \u0007*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u0018\u00100\u001a\n \u0007*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00106\u001a\n \u0007*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u0018\u00107\u001a\n \u0007*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u0012\u00108\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00109R\u001a\u0010:\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00100;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020(0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "Lorg/jitsi/utils/logging2/Logger;", "addPacket", "", "packet", "Lorg/jitsi/nlj/PacketInfo;", "tccSeqNum", "", "overheadBytes", "Lorg/jitsi/nlj/util/DataSize;", "creationTime", "Ljava/time/Instant;", "processSentPacket", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/SentPacket;", "sentPacket", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/SentPacketInfo;", "processTransportFeedback", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportPacketsFeedback;", "feedback", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "feedbackReceiveTime", "processCongestionControlFeedback", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacket;", "getOutstandingData", "toTransportFeedback", "packetResults", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketResult;", "supportsEcn", "", "retrievePacketFeedback", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketFeedback;", "transportSeqNum", "received", "key", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter$SsrcAndRtpSequenceNumber;", "pendingUntrackedSize", "lastSendTime", "Ljava/time/Instant;", "lastUntrackedSendTime", "seqNumUnwrapper", "Lorg/jitsi/nlj/util/RtpSequenceIndexTracker;", "lastAckSeqNum", "inFlight", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/InFlightBytesTracker;", "currentOffset", "lastTransportFeedbackBaseTime", "lastFeedbackCompactNtpTime", "Ljava/lang/Long;", "rtpToTransportSequenceNumber", "Ljava/util/TreeMap;", "history", "getStatisitics", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter$StatisticsSnapshot;", "SsrcAndRtpSequenceNumber", "StatisticsSnapshot", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nTransportFeedbackAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportFeedbackAdapter.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,451:1\n1863#2,2:452\n1863#2,2:454\n1#3:456\n*S KotlinDebug\n*F\n+ 1 TransportFeedbackAdapter.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter\n*L\n197#1:452,2\n265#1:454,2\n*E\n"})
public final class TransportFeedbackAdapter {
    private final Logger logger;
    @NotNull
    private DataSize pendingUntrackedSize;
    private Instant lastSendTime;
    private Instant lastUntrackedSendTime;
    @NotNull
    private final RtpSequenceIndexTracker seqNumUnwrapper;
    private long lastAckSeqNum;
    @NotNull
    private final InFlightBytesTracker inFlight;
    private Instant currentOffset;
    private Instant lastTransportFeedbackBaseTime;
    @Nullable
    private Long lastFeedbackCompactNtpTime;
    @NotNull
    private final TreeMap<SsrcAndRtpSequenceNumber, Long> rtpToTransportSequenceNumber;
    @NotNull
    private final TreeMap<Long, PacketFeedback> history;

    public TransportFeedbackAdapter(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.pendingUntrackedSize = DataSize.Companion.getZERO();
        this.lastSendTime = Instant.MIN;
        this.lastUntrackedSendTime = Instant.MIN;
        this.seqNumUnwrapper = new RtpSequenceIndexTracker();
        this.lastAckSeqNum = -1L;
        this.inFlight = new InFlightBytesTracker();
        this.currentOffset = Instant.MIN;
        this.lastTransportFeedbackBaseTime = Instant.MIN;
        this.rtpToTransportSequenceNumber = new TreeMap();
        this.history = new TreeMap();
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final void addPacket(@NotNull PacketInfo packet, long tccSeqNum, @NotNull DataSize overheadBytes, @NotNull Instant creationTime) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(overheadBytes, "overheadBytes");
        Intrinsics.checkNotNullParameter(creationTime, "creationTime");
        RtpPacket rtpPacket = (RtpPacket)packet.packetAs();
        int truncatedSeqNum = (int)(tccSeqNum & 0xFFFFL);
        long unwrappedSeqNum = this.seqNumUnwrapper.update(truncatedSeqNum);
        if (!(unwrappedSeqNum == tccSeqNum)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        DataSize dataSize = DataSizeKt.getBytes(packet.getPacket().length).plus(overheadBytes);
        Object object = packet.getProbingInfo();
        PacedPacketInfo pacedPacketInfo = object instanceof PacedPacketInfo ? (PacedPacketInfo)object : null;
        if (pacedPacketInfo == null) {
            pacedPacketInfo = new PacedPacketInfo(0, 0, 0, 0L, 15, null);
        }
        PacedPacketInfo pacedPacketInfo2 = pacedPacketInfo;
        PacketFeedback feedback = new PacketFeedback(creationTime, new SentPacket(null, dataSize, null, pacedPacketInfo2, false, tccSeqNum, null, 85, null), rtpPacket.getSsrc(), rtpPacket.getSequenceNumber(), packet.getPacketOrigin() == PacketOrigin.Retransmission);
        while (!((Map)this.history).isEmpty() && Duration.between(this.history.firstEntry().getValue().getCreationTime(), creationTime).compareTo(TransportFeedbackAdapterKt.access$getKSendTimeHistoryWindow$p()) > 0) {
            if (this.history.firstEntry().getValue().getSent().getSequenceNumber() > this.lastAckSeqNum) {
                PacketFeedback packetFeedback = this.history.firstEntry().getValue();
                Intrinsics.checkNotNullExpressionValue(packetFeedback, "<get-value>(...)");
                this.inFlight.removeInFlightPacketBytes(packetFeedback);
            }
            PacketFeedback packet2 = this.history.firstEntry().getValue();
            this.rtpToTransportSequenceNumber.remove(new SsrcAndRtpSequenceNumber(packet2.getSsrc(), packet2.getRtpSequenceNumber()));
            this.history.remove(this.history.firstEntry().getKey());
        }
        ((Map)this.rtpToTransportSequenceNumber).put(new SsrcAndRtpSequenceNumber(feedback.getSsrc(), feedback.getRtpSequenceNumber()), feedback.getSent().getSequenceNumber());
        ((Map)this.history).put(feedback.getSent().getSequenceNumber(), feedback);
    }

    @Nullable
    public final SentPacket processSentPacket(@NotNull SentPacketInfo sentPacket) {
        Intrinsics.checkNotNullParameter(sentPacket, "sentPacket");
        Instant sendTime = sentPacket.getSendTime();
        if (sentPacket.getInfo().getIncludedInFeedback() || sentPacket.getPacketId() != -1L) {
            long seqNum = sentPacket.getPacketId();
            PacketFeedback it = this.history.get(seqNum);
            if (it != null) {
                boolean packetRetransmit = InstantKt.isFinite(it.getSent().getSendTime());
                it.getSent().setSendTime(sendTime);
                Instant instant = this.lastSendTime;
                Intrinsics.checkNotNullExpressionValue(instant, "lastSendTime");
                this.lastSendTime = InstantKt.max(instant, sendTime);
                if (!Intrinsics.areEqual(this.pendingUntrackedSize, DataSize.Companion.getZERO())) {
                    if (sendTime.compareTo(this.lastUntrackedSendTime) < 0) {
                        this.logger.warn("appending acknowledged data for out of order packet.  (Diff: " + Duration.between(sendTime, this.lastUntrackedSendTime) + ".)");
                    }
                    this.pendingUntrackedSize = this.pendingUntrackedSize.plus(DataSizeKt.getBytes(sentPacket.getInfo().getPacketSizeBytes()));
                }
                if (!packetRetransmit && it.getSent().getSequenceNumber() > this.lastAckSeqNum) {
                    this.inFlight.addInFlightPacketBytes(it);
                    it.getSent().setDataInFlight(this.inFlight.getOutstandingData());
                    return it.getSent();
                }
            }
        } else if (sentPacket.getInfo().getIncludedInAllocation()) {
            if (sendTime.compareTo(this.lastSendTime) < 0) {
                this.logger.warn("ignoring untracked data for out of order packet");
            }
            this.pendingUntrackedSize = this.pendingUntrackedSize.plus(DataSizeKt.getBytes(sentPacket.getInfo().getPacketSizeBytes()));
            Instant instant = this.lastUntrackedSendTime;
            Intrinsics.checkNotNullExpressionValue(instant, "lastUntrackedSendTime");
            this.lastUntrackedSendTime = InstantKt.max(instant, sendTime);
        }
        return null;
    }

    @Nullable
    public final TransportPacketsFeedback processTransportFeedback(@NotNull RtcpFbTccPacket feedback, @NotNull Instant feedbackReceiveTime) {
        Intrinsics.checkNotNullParameter(feedback, "feedback");
        Intrinsics.checkNotNullParameter(feedbackReceiveTime, "feedbackReceiveTime");
        if (feedback.GetPacketStatusCount() == 0) {
            this.logger.info(TransportFeedbackAdapter::processTransportFeedback$lambda$0);
            return null;
        }
        Instant instant = this.lastTransportFeedbackBaseTime;
        Intrinsics.checkNotNullExpressionValue(instant, "lastTransportFeedbackBaseTime");
        if (InstantKt.isInfinite(instant)) {
            this.currentOffset = feedbackReceiveTime;
        } else {
            Instant instant2 = this.lastTransportFeedbackBaseTime;
            Intrinsics.checkNotNullExpressionValue(instant2, "lastTransportFeedbackBaseTime");
            Duration delta = feedback.GetBaseDelta(instant2);
            if (delta.compareTo(Duration.between(this.currentOffset, Instant.EPOCH)) < 0) {
                this.logger.warn("Unexpected feedback timestamp received: " + feedbackReceiveTime);
                this.currentOffset = feedbackReceiveTime;
            } else {
                this.currentOffset = this.currentOffset.plus(delta);
            }
        }
        this.lastTransportFeedbackBaseTime = feedback.BaseTime();
        ArrayList<PacketResult> packetResultVector = new ArrayList<PacketResult>();
        packetResultVector.ensureCapacity(feedback.GetPacketStatusCount());
        int failedLookups = 0;
        Duration deltaSinceBase = null;
        deltaSinceBase = Duration.ZERO;
        Iterable $this$forEach$iv = feedback;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketReport report = (PacketReport)element$iv;
            boolean bl = false;
            long seqNum = this.seqNumUnwrapper.interpret(report.getSeqNum());
            PacketFeedback packetFeedback = this.retrievePacketFeedback(seqNum, report instanceof ReceivedPacketReport);
            if (packetFeedback == null) {
                ++failedLookups;
                continue;
            }
            boolean previouslyReportedLost = packetFeedback.getReportedLost();
            PacketResult result = new PacketResult(null, null, null, null, false, 31, null);
            result.setSentPacket(packetFeedback.getSent());
            if (report instanceof ReceivedPacketReport) {
                deltaSinceBase = deltaSinceBase.plus(((ReceivedPacketReport)report).getDeltaDuration());
                result.setReceiveTime(this.currentOffset.plus(deltaSinceBase));
                this.history.remove(seqNum);
            } else {
                packetFeedback.setReportedLost(true);
            }
            result.setRtpPacketInfo(new PacketResult.RtpPacketInfo(packetFeedback.getSsrc(), packetFeedback.getRtpSequenceNumber(), packetFeedback.isRetransmission()));
            result.setPreviouslyReportedLost(previouslyReportedLost);
            packetResultVector.add(result);
        }
        if (failedLookups > 0) {
            this.logger.info("Failed to lookup send time for " + failedLookups + " packet" + (failedLookups > 1 ? "s" : "") + ". Packets reordered or send time history too small?");
        }
        return this.toTransportFeedback((List<PacketResult>)packetResultVector, feedbackReceiveTime, false);
    }

    @Nullable
    public final TransportPacketsFeedback processCongestionControlFeedback(@NotNull RtcpFbCcfbPacket feedback, @NotNull Instant feedbackReceiveTime) {
        Comparable<Long> comparable;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter(feedback, "feedback");
                Intrinsics.checkNotNullParameter(feedbackReceiveTime, "feedbackReceiveTime");
                if (feedback.getPackets().isEmpty()) {
                    this.logger.info(TransportFeedbackAdapter::processCongestionControlFeedback$lambda$2);
                    return null;
                }
                Instant instant = this.currentOffset;
                Intrinsics.checkNotNullExpressionValue(instant, "currentOffset");
                if (InstantKt.isInfinite(instant)) {
                    this.currentOffset = feedbackReceiveTime;
                }
                if ((comparable = this.lastFeedbackCompactNtpTime) == null) break block11;
                long it = ((Number)((Object)comparable)).longValue();
                boolean bl = false;
                Duration duration = Duration.ofMillis(TimeUtils.ntpShortToMs(feedback.getReportTimestampCompactNtp()) - TimeUtils.ntpShortToMs(it));
                comparable = duration;
                if (duration != null) break block12;
            }
            comparable = Duration.ZERO;
        }
        Comparable<Long> feedbackDelta = comparable;
        this.lastFeedbackCompactNtpTime = feedback.getReportTimestampCompactNtp();
        if (((Duration)feedbackDelta).compareTo(Duration.ZERO) < 0) {
            this.logger.warn("Unexpected feedback ntp time delta " + feedbackDelta);
            this.currentOffset = feedbackReceiveTime;
        } else {
            this.currentOffset = this.currentOffset.plus((TemporalAmount)((Object)feedbackDelta));
        }
        Ref.IntRef failedLookups = new Ref.IntRef();
        boolean supportsEcn = false;
        supportsEcn = true;
        List packetResultVector = new ArrayList();
        Iterable $this$forEach$iv = feedback.getPackets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.PacketInfo packetInfo = (org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.PacketInfo)element$iv;
            boolean bl = false;
            PacketFeedback packetFeedback = this.retrievePacketFeedback(new SsrcAndRtpSequenceNumber(packetInfo.getSsrc(), packetInfo.getSequenceNumber()), packetInfo instanceof ReceivedPacketInfo);
            if (packetFeedback == null) {
                ++failedLookups.element;
                int cfr_ignored_0 = failedLookups.element;
                continue;
            }
            PacketResult result = new PacketResult(null, null, null, null, false, 31, null);
            result.setSentPacket(packetFeedback.getSent());
            if (packetInfo instanceof ReceivedPacketInfo) {
                result.setReceiveTime(this.currentOffset.minus(((ReceivedPacketInfo)packetInfo).getArrivalTimeOffset()));
                result.setEcn(((ReceivedPacketInfo)packetInfo).getEcn());
                supportsEcn = supportsEcn && ((ReceivedPacketInfo)packetInfo).getEcn() != EcnMarking.kNotEct;
            }
            result.setRtpPacketInfo(new PacketResult.RtpPacketInfo(packetFeedback.getSsrc(), packetFeedback.getRtpSequenceNumber(), packetFeedback.isRetransmission()));
            packetResultVector.add(result);
        }
        if (failedLookups.element > 0) {
            this.logger.warn(() -> TransportFeedbackAdapter.processCongestionControlFeedback$lambda$5(failedLookups));
        }
        CollectionsKt.sortWith(packetResultVector, (arg_0, arg_1) -> TransportFeedbackAdapter.processCongestionControlFeedback$lambda$8(TransportFeedbackAdapter::processCongestionControlFeedback$lambda$7, arg_0, arg_1));
        return this.toTransportFeedback(packetResultVector, feedbackReceiveTime, supportsEcn);
    }

    @NotNull
    public final DataSize getOutstandingData() {
        return this.inFlight.getOutstandingData();
    }

    private final TransportPacketsFeedback toTransportFeedback(List<PacketResult> packetResults, Instant feedbackReceiveTime, boolean supportsEcn) {
        TransportPacketsFeedback msg = new TransportPacketsFeedback();
        msg.setFeedbackTime(feedbackReceiveTime);
        if (packetResults.isEmpty()) {
            return null;
        }
        msg.setPacketFeedbacks(packetResults);
        msg.setDataInFlight(this.inFlight.getOutstandingData());
        msg.setTransportSupportsEcn(supportsEcn);
        return msg;
    }

    private final PacketFeedback retrievePacketFeedback(long transportSeqNum, boolean received) {
        PacketFeedback packetFeedback;
        if (transportSeqNum > this.lastAckSeqNum) {
            NavigableMap<Long, PacketFeedback> navigableMap = this.history.subMap(this.lastAckSeqNum, false, transportSeqNum, true);
            Intrinsics.checkNotNullExpressionValue(navigableMap, "subMap(...)");
            for (Map.Entry it : ((Map)navigableMap).entrySet()) {
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
                this.inFlight.removeInFlightPacketBytes((PacketFeedback)v);
            }
            this.lastAckSeqNum = transportSeqNum;
        }
        if ((packetFeedback = this.history.get(transportSeqNum)) == null) {
            this.logger.debug(() -> TransportFeedbackAdapter.retrievePacketFeedback$lambda$9(transportSeqNum));
            return null;
        }
        if (InstantKt.isInfinite(packetFeedback.getSent().getSendTime())) {
            this.logger.error("Received feedback before packet with seqNum " + transportSeqNum + " was indicated as sent");
            return null;
        }
        if (received) {
            this.rtpToTransportSequenceNumber.remove(new SsrcAndRtpSequenceNumber(packetFeedback.getSsrc(), packetFeedback.getRtpSequenceNumber()));
            this.history.remove(transportSeqNum);
        }
        return packetFeedback;
    }

    private final PacketFeedback retrievePacketFeedback(SsrcAndRtpSequenceNumber key, boolean received) {
        Long transportSeqNum = this.rtpToTransportSequenceNumber.get(key);
        if (transportSeqNum == null) {
            return null;
        }
        return this.retrievePacketFeedback(transportSeqNum, received);
    }

    @NotNull
    public final StatisticsSnapshot getStatisitics() {
        DataSize dataSize = this.inFlight.getInFlightData();
        Instant instant = this.lastSendTime;
        Intrinsics.checkNotNullExpressionValue(instant, "lastSendTime");
        Instant instant2 = this.lastUntrackedSendTime;
        Intrinsics.checkNotNullExpressionValue(instant2, "lastUntrackedSendTime");
        int n = this.history.size();
        Instant instant3 = this.currentOffset;
        Intrinsics.checkNotNullExpressionValue(instant3, "currentOffset");
        Instant instant4 = this.lastTransportFeedbackBaseTime;
        Intrinsics.checkNotNullExpressionValue(instant4, "lastTransportFeedbackBaseTime");
        return new StatisticsSnapshot(dataSize, this.pendingUntrackedSize, instant, instant2, this.lastAckSeqNum, n, instant3, instant4);
    }

    private static final String processTransportFeedback$lambda$0() {
        return "Empty transport feedback packet received";
    }

    private static final String processCongestionControlFeedback$lambda$2() {
        return "Empty congestion control feedback packet received";
    }

    private static final String processCongestionControlFeedback$lambda$5(Ref.IntRef $failedLookups) {
        Intrinsics.checkNotNullParameter($failedLookups, "$failedLookups");
        return "Failed to lookup send time for " + $failedLookups.element + " packets. Packets reordered or send time history too small?";
    }

    private static final int processCongestionControlFeedback$lambda$7(PacketResult lhs, PacketResult rhs) {
        PacketResult it = lhs;
        boolean bl = false;
        Comparable comparable = Long.valueOf(it.getSentPacket().getSequenceNumber());
        it = rhs;
        Comparable comparable2 = comparable;
        bl = false;
        return ComparisonsKt.compareValues(comparable2, it.getSentPacket().getSequenceNumber());
    }

    private static final int processCongestionControlFeedback$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final String retrievePacketFeedback$lambda$9(long $transportSeqNum) {
        return "No history entry found for seqNum " + $transportSeqNum;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter$SsrcAndRtpSequenceNumber;", "", "ssrc", "", "rtpSequenceNumber", "", "<init>", "(JI)V", "getSsrc", "()J", "getRtpSequenceNumber", "()I", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "jitsi-media-transform"})
    private static final class SsrcAndRtpSequenceNumber
    implements Comparable<SsrcAndRtpSequenceNumber> {
        private final long ssrc;
        private final int rtpSequenceNumber;

        public SsrcAndRtpSequenceNumber(long ssrc, int rtpSequenceNumber) {
            this.ssrc = ssrc;
            this.rtpSequenceNumber = rtpSequenceNumber;
        }

        public final long getSsrc() {
            return this.ssrc;
        }

        public final int getRtpSequenceNumber() {
            return this.rtpSequenceNumber;
        }

        @Override
        public int compareTo(@NotNull SsrcAndRtpSequenceNumber other) {
            Intrinsics.checkNotNullParameter(other, "other");
            Function1[] function1Array = new Function1[]{SsrcAndRtpSequenceNumber::compareTo$lambda$0, SsrcAndRtpSequenceNumber::compareTo$lambda$1};
            return ComparisonsKt.compareValuesBy(this, other, function1Array);
        }

        public final long component1() {
            return this.ssrc;
        }

        public final int component2() {
            return this.rtpSequenceNumber;
        }

        @NotNull
        public final SsrcAndRtpSequenceNumber copy(long ssrc, int rtpSequenceNumber) {
            return new SsrcAndRtpSequenceNumber(ssrc, rtpSequenceNumber);
        }

        public static /* synthetic */ SsrcAndRtpSequenceNumber copy$default(SsrcAndRtpSequenceNumber ssrcAndRtpSequenceNumber, long l, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = ssrcAndRtpSequenceNumber.ssrc;
            }
            if ((n2 & 2) != 0) {
                n = ssrcAndRtpSequenceNumber.rtpSequenceNumber;
            }
            return ssrcAndRtpSequenceNumber.copy(l, n);
        }

        @NotNull
        public String toString() {
            return "SsrcAndRtpSequenceNumber(ssrc=" + this.ssrc + ", rtpSequenceNumber=" + this.rtpSequenceNumber + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.ssrc);
            result = result * 31 + Integer.hashCode(this.rtpSequenceNumber);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SsrcAndRtpSequenceNumber)) {
                return false;
            }
            SsrcAndRtpSequenceNumber ssrcAndRtpSequenceNumber = (SsrcAndRtpSequenceNumber)other;
            if (this.ssrc != ssrcAndRtpSequenceNumber.ssrc) {
                return false;
            }
            return this.rtpSequenceNumber == ssrcAndRtpSequenceNumber.rtpSequenceNumber;
        }

        private static final Comparable compareTo$lambda$0(SsrcAndRtpSequenceNumber it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Long.valueOf(it.ssrc);
        }

        private static final Comparable compareTo$lambda$1(SsrcAndRtpSequenceNumber it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Integer.valueOf(it.rtpSequenceNumber);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportFeedbackAdapter$StatisticsSnapshot;", "", "inFlight", "Lorg/jitsi/nlj/util/DataSize;", "pendingUntrackedSize", "lastSendTime", "Ljava/time/Instant;", "lastUntrackedSendTime", "lastAckSeqNum", "", "historySize", "", "currentOffset", "lastTransportFeedbackBaseTime", "<init>", "(Lorg/jitsi/nlj/util/DataSize;Lorg/jitsi/nlj/util/DataSize;Ljava/time/Instant;Ljava/time/Instant;JILjava/time/Instant;Ljava/time/Instant;)V", "getInFlight", "()Lorg/jitsi/nlj/util/DataSize;", "getPendingUntrackedSize", "getLastSendTime", "()Ljava/time/Instant;", "getLastUntrackedSendTime", "getLastAckSeqNum", "()J", "getHistorySize", "()I", "getCurrentOffset", "getLastTransportFeedbackBaseTime", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-media-transform"})
    public static final class StatisticsSnapshot {
        @NotNull
        private final DataSize inFlight;
        @NotNull
        private final DataSize pendingUntrackedSize;
        @NotNull
        private final Instant lastSendTime;
        @NotNull
        private final Instant lastUntrackedSendTime;
        private final long lastAckSeqNum;
        private final int historySize;
        @NotNull
        private final Instant currentOffset;
        @NotNull
        private final Instant lastTransportFeedbackBaseTime;

        public StatisticsSnapshot(@NotNull DataSize inFlight, @NotNull DataSize pendingUntrackedSize, @NotNull Instant lastSendTime, @NotNull Instant lastUntrackedSendTime, long lastAckSeqNum, int historySize, @NotNull Instant currentOffset, @NotNull Instant lastTransportFeedbackBaseTime) {
            Intrinsics.checkNotNullParameter(inFlight, "inFlight");
            Intrinsics.checkNotNullParameter(pendingUntrackedSize, "pendingUntrackedSize");
            Intrinsics.checkNotNullParameter(lastSendTime, "lastSendTime");
            Intrinsics.checkNotNullParameter(lastUntrackedSendTime, "lastUntrackedSendTime");
            Intrinsics.checkNotNullParameter(currentOffset, "currentOffset");
            Intrinsics.checkNotNullParameter(lastTransportFeedbackBaseTime, "lastTransportFeedbackBaseTime");
            this.inFlight = inFlight;
            this.pendingUntrackedSize = pendingUntrackedSize;
            this.lastSendTime = lastSendTime;
            this.lastUntrackedSendTime = lastUntrackedSendTime;
            this.lastAckSeqNum = lastAckSeqNum;
            this.historySize = historySize;
            this.currentOffset = currentOffset;
            this.lastTransportFeedbackBaseTime = lastTransportFeedbackBaseTime;
        }

        @NotNull
        public final DataSize getInFlight() {
            return this.inFlight;
        }

        @NotNull
        public final DataSize getPendingUntrackedSize() {
            return this.pendingUntrackedSize;
        }

        @NotNull
        public final Instant getLastSendTime() {
            return this.lastSendTime;
        }

        @NotNull
        public final Instant getLastUntrackedSendTime() {
            return this.lastUntrackedSendTime;
        }

        public final long getLastAckSeqNum() {
            return this.lastAckSeqNum;
        }

        public final int getHistorySize() {
            return this.historySize;
        }

        @NotNull
        public final Instant getCurrentOffset() {
            return this.currentOffset;
        }

        @NotNull
        public final Instant getLastTransportFeedbackBaseTime() {
            return this.lastTransportFeedbackBaseTime;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u240.put("in_flight_bytes", (Object)this.inFlight.getBytes());
            $this$toJson_u24lambda_u240.put("pending_untracked_size", (Object)this.pendingUntrackedSize.getBytes());
            $this$toJson_u24lambda_u240.put("last_send_time", TransportFeedbackAdapterKt.access$toEpochMilliOrInf(this.lastSendTime));
            $this$toJson_u24lambda_u240.put("last_untracked_send_time", TransportFeedbackAdapterKt.access$toEpochMilliOrInf(this.lastUntrackedSendTime));
            $this$toJson_u24lambda_u240.put("last_ack_seq_num", (Object)this.lastAckSeqNum);
            $this$toJson_u24lambda_u240.put("history_size", (Object)this.historySize);
            $this$toJson_u24lambda_u240.put("current_offset", TransportFeedbackAdapterKt.access$toEpochMilliOrInf(this.currentOffset));
            $this$toJson_u24lambda_u240.put("last_transport_feedback_base_time", TransportFeedbackAdapterKt.access$toEpochMilliOrInf(this.lastTransportFeedbackBaseTime));
            return orderedJsonObject;
        }
    }
}

