/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.OptionalConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimatorConfig;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimatorEngine;
import org.jitsi.nlj.rtp.bandwidthestimation.GoogleCcEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation2.GoogCcTransportCcEngine;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.stats.RateTracker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0016\u0010#\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/BitrateCalculator;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "name", "", "activePacketRateThreshold", "", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;ILjava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "bitrateTracker", "Lorg/jitsi/nlj/util/BitrateTracker;", "packetRateTracker", "Lorg/jitsi/utils/stats/RateTracker;", "bitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "getBitrate-rlWvAKk", "()J", "packetRatePps", "", "getPacketRatePps", "start", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "active", "", "getActive", "()Z", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nBitrateCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitrateCalculator.kt\norg/jitsi/nlj/transform/node/incoming/BitrateCalculator\n+ 2 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,185:1\n103#2,6:186\n103#2,6:192\n*S KotlinDebug\n*F\n+ 1 BitrateCalculator.kt\norg/jitsi/nlj/transform/node/incoming/BitrateCalculator\n*L\n145#1:186,6\n163#1:192,6\n*E\n"})
public class BitrateCalculator
extends ObserverNode {
    @NotNull
    public static final Companion Companion;
    private final int activePacketRateThreshold;
    @NotNull
    private final Clock clock;
    @NotNull
    private final BitrateTracker bitrateTracker;
    @NotNull
    private final RateTracker packetRateTracker;
    private final Instant start;
    @NotNull
    private static final Duration GRACE_PERIOD;
    @NotNull
    private static final OptionalConfigDelegate<Duration> _windowSize$delegate;
    @NotNull
    private static final OptionalConfigDelegate<Duration> _bucketSize$delegate;

    public BitrateCalculator(@NotNull String name, int activePacketRateThreshold, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(clock, "clock");
        super(name);
        this.activePacketRateThreshold = activePacketRateThreshold;
        this.clock = clock;
        this.bitrateTracker = Companion.createBitrateTracker();
        this.packetRateTracker = Companion.createRateTracker();
        this.start = this.clock.instant();
    }

    public /* synthetic */ BitrateCalculator(String string, int n, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 1) != 0) {
            string = "Bitrate calculator";
        }
        if ((n2 & 2) != 0) {
            n = 5;
        }
        if ((n2 & 4) != 0) {
            clock = Clock.systemUTC();
        }
        this(string, n, clock);
    }

    @NotNull
    protected final Clock getClock() {
        return this.clock;
    }

    public final long getBitrate-rlWvAKk() {
        return this.bitrateTracker.getRate-rlWvAKk();
    }

    public final long getPacketRatePps() {
        return this.packetRateTracker.getRate();
    }

    public final boolean getActive() {
        return Duration.between(this.start, this.clock.instant()).compareTo(GRACE_PERIOD) <= 0 ? this.getBitrate-rlWvAKk() > 0L : this.getPacketRatePps() >= (long)this.activePacketRateThreshold;
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        long now = this.clock.millis();
        this.bitrateTracker.update(DataSizeKt.getBytes(packetInfo.getPacket().length), now);
        this.packetRateTracker.update(1L, now);
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u240.addNumber("bitrate_bps", this.getBitrate-rlWvAKk());
        $this$getNodeStats_u24lambda_u240.addNumber("packet_rate_pps", this.getPacketRatePps());
        $this$getNodeStats_u24lambda_u240.addBoolean("active", this.getActive());
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        return super.getNodeStats();
    }

    public BitrateCalculator() {
        this(null, 0, null, 7, null);
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        GRACE_PERIOD = DurationKt.getSecs(10);
        boolean $i$f$optionalconfig = false;
        SupplierBuilder $this$_windowSize_delegate_u24lambda_u241 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl = false;
        $this$_windowSize_delegate_u24lambda_u241.from("jmt.rtp.bitrate-calculator.window-size", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        _windowSize$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new OptionalConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new OptionalConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$optionalconfig = false;
        SupplierBuilder $this$_bucketSize_delegate_u24lambda_u242 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl2 = false;
        $this$_bucketSize_delegate_u24lambda_u242.from("jmt.rtp.bitrate-calculator.bucket-size", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        _bucketSize$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new OptionalConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new OptionalConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\u0007R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/BitrateCalculator$Companion;", "", "<init>", "()V", "GRACE_PERIOD", "Ljava/time/Duration;", "getGRACE_PERIOD", "()Ljava/time/Duration;", "_windowSize", "get_windowSize", "_windowSize$delegate", "Lorg/jitsi/metaconfig/OptionalConfigDelegate;", "defaultWindowSize", "windowSize", "getWindowSize", "_bucketSize", "get_bucketSize", "_bucketSize$delegate", "defaultBucketSize", "bucketSize", "getBucketSize", "createBitrateTracker", "Lorg/jitsi/nlj/util/BitrateTracker;", "createRateTracker", "Lorg/jitsi/utils/stats/RateTracker;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Duration getGRACE_PERIOD() {
            return GRACE_PERIOD;
        }

        private final Duration get_windowSize() {
            return (Duration)_windowSize$delegate.getValue(this, $$delegatedProperties[0]);
        }

        private final Duration defaultWindowSize() {
            Duration duration;
            switch (WhenMappings.$EnumSwitchMapping$0[BandwidthEstimatorConfig.Companion.getEngine().ordinal()]) {
                case 1: {
                    duration = GoogleCcEstimator.Companion.getDefaultRateTrackerWindowSize();
                    break;
                }
                case 2: {
                    duration = GoogCcTransportCcEngine.Companion.getDefaultRateTrackerWindowSize();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return duration;
        }

        @NotNull
        public final Duration getWindowSize() {
            Duration duration = this.get_windowSize();
            if (duration == null) {
                duration = this.defaultWindowSize();
            }
            return duration;
        }

        private final Duration get_bucketSize() {
            return (Duration)_bucketSize$delegate.getValue(this, $$delegatedProperties[1]);
        }

        private final Duration defaultBucketSize() {
            Duration duration;
            switch (WhenMappings.$EnumSwitchMapping$0[BandwidthEstimatorConfig.Companion.getEngine().ordinal()]) {
                case 1: {
                    duration = GoogleCcEstimator.Companion.getDefaultRateTrackerBucketSize();
                    break;
                }
                case 2: {
                    duration = GoogCcTransportCcEngine.Companion.getDefaultRateTrackerBucketSize();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return duration;
        }

        @NotNull
        public final Duration getBucketSize() {
            Duration duration = this.get_bucketSize();
            if (duration == null) {
                duration = this.defaultBucketSize();
            }
            return duration;
        }

        @NotNull
        public final BitrateTracker createBitrateTracker() {
            return new BitrateTracker(this.getWindowSize(), this.getBucketSize(), null, 4, null);
        }

        @NotNull
        public final RateTracker createRateTracker() {
            return new RateTracker(this.getWindowSize(), this.getBucketSize(), null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "_windowSize", "get_windowSize()Ljava/time/Duration;", 0)), Reflection.property1(new PropertyReference1Impl(Companion.class, "_bucketSize", "get_bucketSize()Ljava/time/Duration;", 0))};
            $$delegatedProperties = kPropertyArray;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BandwidthEstimatorEngine.values().length];
                try {
                    nArray[BandwidthEstimatorEngine.GoogleCc.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BandwidthEstimatorEngine.GoogleCc2.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

