/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.TimeUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\f*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0004*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0004*\u00020\u0001\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"NEVER", "Ljava/time/Instant;", "instantOfEpochMicro", "epochMicro", "", "max", "a", "b", "min", "formatMilli", "", "isFinite", "", "isInfinite", "roundedMillis", "Ljava/time/Clock;", "toEpochMicro", "toRoundedEpochMilli", "jitsi-utils"})
public final class InstantKt {
    @JvmField
    @NotNull
    public static final Instant NEVER;

    public static final long toEpochMicro(@NotNull Instant $this$toEpochMicro) {
        Intrinsics.checkNotNullParameter($this$toEpochMicro, "<this>");
        if ($this$toEpochMicro.getEpochSecond() < 0L && $this$toEpochMicro.getNano() > 0) {
            long millis = Math.multiplyExact($this$toEpochMicro.getEpochSecond() + 1L, 1000000);
            long adjustment = $this$toEpochMicro.getNano() / 1000 - 1;
            return Math.addExact(millis, adjustment);
        }
        long millis = Math.multiplyExact($this$toEpochMicro.getEpochSecond(), 1000000);
        return Math.addExact(millis, (long)($this$toEpochMicro.getNano() / 1000));
    }

    @NotNull
    public static final Instant instantOfEpochMicro(long epochMicro) {
        long secs = Math.floorDiv(epochMicro, 1000000);
        long mos = Math.floorMod(epochMicro, 1000000);
        Instant instant = Instant.ofEpochSecond(secs, mos * (long)1000);
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochSecond(...)");
        return instant;
    }

    @NotNull
    public static final String formatMilli(@NotNull Instant $this$formatMilli) {
        Intrinsics.checkNotNullParameter($this$formatMilli, "<this>");
        String string = TimeUtils.formatTimeAsFullMillis($this$formatMilli.getEpochSecond(), $this$formatMilli.getNano());
        Intrinsics.checkNotNullExpressionValue(string, "formatTimeAsFullMillis(...)");
        return string;
    }

    public static final long toRoundedEpochMilli(@NotNull Instant $this$toRoundedEpochMilli) {
        Intrinsics.checkNotNullParameter($this$toRoundedEpochMilli, "<this>");
        long ret = $this$toRoundedEpochMilli.toEpochMilli();
        int remainder = Math.floorMod($this$toRoundedEpochMilli.getNano(), 1000000);
        if (remainder > 499999) {
            long l = ret;
            ret = l + 1L;
        }
        return ret;
    }

    public static final boolean isInfinite(@NotNull Instant $this$isInfinite) {
        Intrinsics.checkNotNullParameter($this$isInfinite, "<this>");
        return Intrinsics.areEqual($this$isInfinite, Instant.MAX) || Intrinsics.areEqual($this$isInfinite, Instant.MIN);
    }

    public static final boolean isFinite(@NotNull Instant $this$isFinite) {
        Intrinsics.checkNotNullParameter($this$isFinite, "<this>");
        return !InstantKt.isInfinite($this$isFinite);
    }

    public static final long roundedMillis(@NotNull Clock $this$roundedMillis) {
        Intrinsics.checkNotNullParameter($this$roundedMillis, "<this>");
        Instant instant = $this$roundedMillis.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        return InstantKt.toRoundedEpochMilli(instant);
    }

    @NotNull
    public static final Instant max(@NotNull Instant a, @NotNull Instant b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.compareTo(b) >= 0 ? a : b;
    }

    @NotNull
    public static final Instant min(@NotNull Instant a, @NotNull Instant b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.compareTo(b) <= 0 ? a : b;
    }

    static {
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue(instant, "MIN");
        NEVER = instant;
    }
}

