/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.export;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.mediajson.CustomParameters;
import org.jitsi.mediajson.Event;
import org.jitsi.mediajson.Media;
import org.jitsi.mediajson.MediaEvent;
import org.jitsi.mediajson.MediaFormat;
import org.jitsi.mediajson.Start;
import org.jitsi.mediajson.StartEvent;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.util.RtpSequenceIndexTracker;
import org.jitsi.nlj.util.RtpTimestampIndexTracker;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\"B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\fH\u0002J \u0010 \u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lorg/jitsi/videobridge/export/MediaJsonSerializer;", "", "handleEvent", "Lkotlin/Function1;", "Lorg/jitsi/mediajson/Event;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "ref", "Ljava/time/Instant;", "ssrcsStarted", "", "", "Lorg/jitsi/videobridge/export/MediaJsonSerializer$SsrcState;", "seq", "", "getSeq", "()I", "setSeq", "(I)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "encode", "p", "Lorg/jitsi/nlj/rtp/AudioRtpPacket;", "epId", "", "createStart", "Lorg/jitsi/mediajson/StartEvent;", "ssrc", "encodeMedia", "state", "SsrcState", "jitsi-videobridge"})
public final class MediaJsonSerializer {
    @NotNull
    private final Function1<Event, Unit> handleEvent;
    @NotNull
    private final Instant ref;
    @NotNull
    private final Map<Long, SsrcState> ssrcsStarted;
    private int seq;
    @NotNull
    private final Logger logger;

    public MediaJsonSerializer(@NotNull Function1<? super Event, Unit> handleEvent) {
        Intrinsics.checkNotNullParameter(handleEvent, "handleEvent");
        this.handleEvent = handleEvent;
        Instant instant = Clock.systemUTC().instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        this.ref = instant;
        this.ssrcsStarted = new LinkedHashMap();
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    }

    public final int getSeq() {
        return this.seq;
    }

    public final void setSeq(int n) {
        this.seq = n;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encode(@NotNull AudioRtpPacket p, @NotNull String epId) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(epId, "epId");
        Map<Long, SsrcState> map = this.ssrcsStarted;
        synchronized (map) {
            boolean bl = false;
            SsrcState ssrcState = this.ssrcsStarted.computeIfAbsent(p.getSsrc(), arg_0 -> MediaJsonSerializer.encode$lambda$3$lambda$2(arg_0 -> MediaJsonSerializer.encode$lambda$3$lambda$1(p, this, epId, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(ssrcState, "computeIfAbsent(...)");
            SsrcState state = ssrcState;
            this.handleEvent.invoke(this.encodeMedia(p, state, epId));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final StartEvent createStart(String epId, long ssrc) {
        ++this.seq;
        return new StartEvent(this.seq, new Start(epId + "-" + ssrc, new MediaFormat("opus", 48000, 2), new CustomParameters(epId)));
    }

    private final Event encodeMedia(AudioRtpPacket p, SsrcState state, String epId) {
        ++this.seq;
        String string = epId + "-" + p.getSsrc();
        int n = state.getSequenceNumber(p.getSequenceNumber());
        long l = state.getTimestamp(p.getTimestamp());
        Intrinsics.checkNotNullExpressionValue(p.buffer, "buffer");
        return new MediaEvent(this.seq, new Media(string, n, l, Base64.Default.encode(p.buffer, p.getPayloadOffset(), p.getPayloadOffset() + p.getPayloadLength())));
    }

    private static final SsrcState encode$lambda$3$lambda$1(AudioRtpPacket $p, MediaJsonSerializer this$0, String $epId, Long ssrc) {
        SsrcState ssrcState;
        Intrinsics.checkNotNullParameter($p, "$p");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($epId, "$epId");
        Intrinsics.checkNotNullParameter(ssrc, "ssrc");
        SsrcState it = ssrcState = new SsrcState($p.getTimestamp(), (long)((double)Duration.between(this$0.ref, Clock.systemUTC().instant()).toNanos() * 4.8E-5));
        boolean bl = false;
        this$0.logger.info("Starting SSRC " + ssrc + " for endpoint " + $epId + " ");
        this$0.handleEvent.invoke(this$0.createStart($epId, ssrc));
        return ssrcState;
    }

    private static final SsrcState encode$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (SsrcState)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/export/MediaJsonSerializer$SsrcState;", "", "initialRtpTimestamp", "", "startOffset", "<init>", "(JJ)V", "seqIndexTracker", "Lorg/jitsi/nlj/util/RtpSequenceIndexTracker;", "timestampIndexTracker", "Lorg/jitsi/nlj/util/RtpTimestampIndexTracker;", "offset", "getTimestamp", "rtpTimestamp", "getSequenceNumber", "", "seq", "jitsi-videobridge"})
    @SourceDebugExtension(value={"SMAP\nMediaJsonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaJsonSerializer.kt\norg/jitsi/videobridge/export/MediaJsonSerializer$SsrcState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
    private static final class SsrcState {
        @NotNull
        private final RtpSequenceIndexTracker seqIndexTracker = new RtpSequenceIndexTracker();
        @NotNull
        private final RtpTimestampIndexTracker timestampIndexTracker;
        private final long offset;

        /*
         * WARNING - void declaration
         */
        public SsrcState(long initialRtpTimestamp, long startOffset) {
            void $this$timestampIndexTracker_u24lambda_u240;
            RtpTimestampIndexTracker rtpTimestampIndexTracker;
            RtpTimestampIndexTracker rtpTimestampIndexTracker2 = rtpTimestampIndexTracker = new RtpTimestampIndexTracker();
            SsrcState ssrcState = this;
            boolean bl = false;
            $this$timestampIndexTracker_u24lambda_u240.update(initialRtpTimestamp);
            ssrcState.timestampIndexTracker = rtpTimestampIndexTracker;
            this.offset = startOffset - initialRtpTimestamp;
        }

        public final long getTimestamp(long rtpTimestamp) {
            return this.offset + this.timestampIndexTracker.update(rtpTimestamp);
        }

        public final int getSequenceNumber(int seq) {
            return (int)this.seqIndexTracker.update(seq);
        }
    }
}

