/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.DoubleGaugeMetric;
import org.jitsi.metrics.HistogramMetric;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.rtcp.RembHandler;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.RtpReceiverStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsSnapshot;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.stats.ConferencePacketStats;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b1\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0011\u0010\"\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u0011\u0010$\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u0011\u0010&\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000fR\u0011\u0010*\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000fR\u0011\u0010,\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000fR\u0011\u0010.\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000fR\u0011\u00100\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000fR\u0011\u00102\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u000fR\u0011\u00104\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000fR\u0011\u00106\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u000fR\u0011\u00108\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u000fR\u0011\u0010:\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u000fR\u0011\u0010<\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u000fR\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010CR\u0011\u0010F\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010C\u00a8\u0006L"}, d2={"Lorg/jitsi/videobridge/metrics/VideobridgePeriodicMetrics;", "", "<init>", "()V", "incomingLoss", "Lorg/jitsi/metrics/DoubleGaugeMetric;", "getIncomingLoss", "()Lorg/jitsi/metrics/DoubleGaugeMetric;", "outgoingLoss", "getOutgoingLoss", "loss", "getLoss", "relayIncomingBitrate", "Lorg/jitsi/metrics/LongGaugeMetric;", "getRelayIncomingBitrate", "()Lorg/jitsi/metrics/LongGaugeMetric;", "relayOutgoingBitrate", "getRelayOutgoingBitrate", "relayIncomingPacketRate", "getRelayIncomingPacketRate", "relayOutgoingPacketRate", "getRelayOutgoingPacketRate", "incomingBitrate", "getIncomingBitrate", "outgoingBitrate", "getOutgoingBitrate", "incomingPacketRate", "getIncomingPacketRate", "outgoingPacketRate", "getOutgoingPacketRate", "averageRtt", "getAverageRtt", "largestConference", "getLargestConference", "endpoints", "getEndpoints", "endpointsWithHighOutgoingLoss", "getEndpointsWithHighOutgoingLoss", "activeEndpoints", "getActiveEndpoints", "endpointsSendingAudio", "getEndpointsSendingAudio", "endpointsSendingVideo", "getEndpointsSendingVideo", "endpointsRelayed", "getEndpointsRelayed", "endpointsOversending", "getEndpointsOversending", "endpointsReceiveOnly", "getEndpointsReceiveOnly", "endpointsInactive", "getEndpointsInactive", "endpointsWithSpuriousRemb", "getEndpointsWithSpuriousRemb", "endpointsWithSuspendedSources", "getEndpointsWithSuspendedSources", "conferencesInactive", "getConferencesInactive", "conferencesP2p", "getConferencesP2p", "conferencesWithRelay", "getConferencesWithRelay", "conferenceSizeBuckets", "", "conferencesBySize", "Lorg/jitsi/metrics/HistogramMetric;", "getConferencesBySize", "()Lorg/jitsi/metrics/HistogramMetric;", "conferencesByAudioSender", "getConferencesByAudioSender", "conferencesByVideoSender", "getConferencesByVideoSender", "update", "", "videobridge", "Lorg/jitsi/videobridge/Videobridge;", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVideobridgePeriodicMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideobridgePeriodicMetrics.kt\norg/jitsi/videobridge/metrics/VideobridgePeriodicMetrics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n1855#2,2:364\n1855#2,2:366\n1855#2,2:368\n1549#2:370\n1620#2,3:371\n*S KotlinDebug\n*F\n+ 1 VideobridgePeriodicMetrics.kt\norg/jitsi/videobridge/metrics/VideobridgePeriodicMetrics\n*L\n354#1:364,2\n357#1:366,2\n360#1:368,2\n141#1:370\n141#1:371,3\n*E\n"})
public final class VideobridgePeriodicMetrics {
    @NotNull
    public static final VideobridgePeriodicMetrics INSTANCE;
    @NotNull
    private static final DoubleGaugeMetric incomingLoss;
    @NotNull
    private static final DoubleGaugeMetric outgoingLoss;
    @NotNull
    private static final DoubleGaugeMetric loss;
    @NotNull
    private static final LongGaugeMetric relayIncomingBitrate;
    @NotNull
    private static final LongGaugeMetric relayOutgoingBitrate;
    @NotNull
    private static final LongGaugeMetric relayIncomingPacketRate;
    @NotNull
    private static final LongGaugeMetric relayOutgoingPacketRate;
    @NotNull
    private static final LongGaugeMetric incomingBitrate;
    @NotNull
    private static final LongGaugeMetric outgoingBitrate;
    @NotNull
    private static final LongGaugeMetric incomingPacketRate;
    @NotNull
    private static final LongGaugeMetric outgoingPacketRate;
    @NotNull
    private static final DoubleGaugeMetric averageRtt;
    @NotNull
    private static final LongGaugeMetric largestConference;
    @NotNull
    private static final LongGaugeMetric endpoints;
    @NotNull
    private static final LongGaugeMetric endpointsWithHighOutgoingLoss;
    @NotNull
    private static final LongGaugeMetric activeEndpoints;
    @NotNull
    private static final LongGaugeMetric endpointsSendingAudio;
    @NotNull
    private static final LongGaugeMetric endpointsSendingVideo;
    @NotNull
    private static final LongGaugeMetric endpointsRelayed;
    @NotNull
    private static final LongGaugeMetric endpointsOversending;
    @NotNull
    private static final LongGaugeMetric endpointsReceiveOnly;
    @NotNull
    private static final LongGaugeMetric endpointsInactive;
    @NotNull
    private static final LongGaugeMetric endpointsWithSpuriousRemb;
    @NotNull
    private static final LongGaugeMetric endpointsWithSuspendedSources;
    @NotNull
    private static final LongGaugeMetric conferencesInactive;
    @NotNull
    private static final LongGaugeMetric conferencesP2p;
    @NotNull
    private static final LongGaugeMetric conferencesWithRelay;
    @NotNull
    private static final double[] conferenceSizeBuckets;
    @NotNull
    private static final HistogramMetric conferencesBySize;
    @NotNull
    private static final HistogramMetric conferencesByAudioSender;
    @NotNull
    private static final HistogramMetric conferencesByVideoSender;

    private VideobridgePeriodicMetrics() {
    }

    @NotNull
    public final DoubleGaugeMetric getIncomingLoss() {
        return incomingLoss;
    }

    @NotNull
    public final DoubleGaugeMetric getOutgoingLoss() {
        return outgoingLoss;
    }

    @NotNull
    public final DoubleGaugeMetric getLoss() {
        return loss;
    }

    @NotNull
    public final LongGaugeMetric getRelayIncomingBitrate() {
        return relayIncomingBitrate;
    }

    @NotNull
    public final LongGaugeMetric getRelayOutgoingBitrate() {
        return relayOutgoingBitrate;
    }

    @NotNull
    public final LongGaugeMetric getRelayIncomingPacketRate() {
        return relayIncomingPacketRate;
    }

    @NotNull
    public final LongGaugeMetric getRelayOutgoingPacketRate() {
        return relayOutgoingPacketRate;
    }

    @NotNull
    public final LongGaugeMetric getIncomingBitrate() {
        return incomingBitrate;
    }

    @NotNull
    public final LongGaugeMetric getOutgoingBitrate() {
        return outgoingBitrate;
    }

    @NotNull
    public final LongGaugeMetric getIncomingPacketRate() {
        return incomingPacketRate;
    }

    @NotNull
    public final LongGaugeMetric getOutgoingPacketRate() {
        return outgoingPacketRate;
    }

    @NotNull
    public final DoubleGaugeMetric getAverageRtt() {
        return averageRtt;
    }

    @NotNull
    public final LongGaugeMetric getLargestConference() {
        return largestConference;
    }

    @NotNull
    public final LongGaugeMetric getEndpoints() {
        return endpoints;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsWithHighOutgoingLoss() {
        return endpointsWithHighOutgoingLoss;
    }

    @NotNull
    public final LongGaugeMetric getActiveEndpoints() {
        return activeEndpoints;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsSendingAudio() {
        return endpointsSendingAudio;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsSendingVideo() {
        return endpointsSendingVideo;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsRelayed() {
        return endpointsRelayed;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsOversending() {
        return endpointsOversending;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsReceiveOnly() {
        return endpointsReceiveOnly;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsInactive() {
        return endpointsInactive;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsWithSpuriousRemb() {
        return endpointsWithSpuriousRemb;
    }

    @NotNull
    public final LongGaugeMetric getEndpointsWithSuspendedSources() {
        return endpointsWithSuspendedSources;
    }

    @NotNull
    public final LongGaugeMetric getConferencesInactive() {
        return conferencesInactive;
    }

    @NotNull
    public final LongGaugeMetric getConferencesP2p() {
        return conferencesP2p;
    }

    @NotNull
    public final LongGaugeMetric getConferencesWithRelay() {
        return conferencesWithRelay;
    }

    @NotNull
    public final HistogramMetric getConferencesBySize() {
        return conferencesBySize;
    }

    @NotNull
    public final HistogramMetric getConferencesByAudioSender() {
        return conferencesByAudioSender;
    }

    @NotNull
    public final HistogramMetric getConferencesByVideoSender() {
        return conferencesByVideoSender;
    }

    public final void update(@NotNull Videobridge videobridge) {
        long it;
        Intrinsics.checkNotNullParameter(videobridge, "videobridge");
        long endpoints = 0L;
        long localEndpoints = 0L;
        long octoEndpoints = 0L;
        long octoConferences = 0L;
        double bitrateDownloadBps = 0.0;
        double bitrateUploadBps = 0.0;
        long packetRateUpload = 0L;
        long packetRateDownload = 0L;
        double relayBitrateIncomingBps = 0.0;
        double relayBitrateOutgoingBps = 0.0;
        long relayPacketRateOutgoing = 0L;
        long relayPacketRateIncoming = 0L;
        long incomingPacketsReceived = 0L;
        long incomingPacketsLost = 0L;
        long outgoingPacketsReceived = 0L;
        long outgoingPacketsLost = 0L;
        double rttSumMs = 0.0;
        long rttCount = 0L;
        long largestConferenceSize = 0L;
        long inactiveConferences = 0L;
        long p2pConferences = 0L;
        long inactiveEndpoints = 0L;
        long receiveOnlyEndpoints = 0L;
        long numAudioSenders = 0L;
        long numVideoSenders = 0L;
        long numOversending = 0L;
        long endpointsWithHighOutgoingLoss = 0L;
        long numLocalActiveEndpoints = 0L;
        long endpointsWithSuspendedSources = 0L;
        Collection<Conference> conferences = videobridge.getConferences();
        ArrayList<Long> conferenceSizesList = new ArrayList<Long>(conferences.size());
        ArrayList<Long> audioSendersList = new ArrayList<Long>(conferences.size());
        ArrayList<Long> videoSendersList = new ArrayList<Long>(conferences.size());
        for (Conference conference : conferences) {
            long l;
            boolean inactive;
            long conferenceBitrate = 0L;
            long conferencePacketRate = 0L;
            if (conference.isP2p()) {
                long l2 = p2pConferences;
                p2pConferences = l2 + 1L;
            }
            if (inactive = conference.isInactive()) {
                l = inactiveConferences;
                inactiveConferences = l + 1L;
                inactiveEndpoints += (long)conference.getEndpointCount();
            } else {
                numLocalActiveEndpoints += (long)conference.getLocalEndpointCount();
            }
            if (conference.hasRelays()) {
                l = octoConferences;
                octoConferences = l + 1L;
            }
            long numConferenceEndpoints = conference.getEndpointCount();
            int numLocalEndpoints = conference.getLocalEndpointCount();
            localEndpoints += (long)numLocalEndpoints;
            if (numConferenceEndpoints > largestConferenceSize) {
                largestConferenceSize = numConferenceEndpoints;
            }
            conferenceSizesList.add(numConferenceEndpoints);
            endpoints += numConferenceEndpoints;
            octoEndpoints += numConferenceEndpoints - (long)numLocalEndpoints;
            long conferenceAudioSenders = 0L;
            long conferenceVideoSenders = 0L;
            for (Endpoint endpoint : conference.getLocalEndpoints()) {
                double endpointOutgoingFractionLost;
                long l3;
                if (endpoint.isOversending()) {
                    long l4 = numOversending;
                    numOversending = l4 + 1L;
                }
                boolean sendingAudio = endpoint.isSendingAudio();
                boolean sendingVideo = endpoint.isSendingVideo();
                if (sendingAudio) {
                    l3 = conferenceAudioSenders;
                    conferenceAudioSenders = l3 + 1L;
                }
                if (sendingVideo) {
                    l3 = conferenceVideoSenders;
                    conferenceVideoSenders = l3 + 1L;
                }
                if (!(sendingAudio || sendingVideo || inactive)) {
                    l3 = receiveOnlyEndpoints;
                    receiveOnlyEndpoints = l3 + 1L;
                }
                if (endpoint.hasSuspendedSources()) {
                    l3 = endpointsWithSuspendedSources;
                    endpointsWithSuspendedSources = l3 + 1L;
                }
                TransceiverStats transceiverStats = endpoint.getTransceiver().getTransceiverStats();
                EndpointConnectionStats.Snapshot endpointConnectionStats = transceiverStats.component1();
                RtpReceiverStats rtpReceiverStats = transceiverStats.component2();
                PacketStreamStats.Snapshot outgoingStats = transceiverStats.component4();
                IncomingStatisticsSnapshot incomingStats = rtpReceiverStats.getIncomingStats();
                PacketStreamStats.Snapshot incomingPacketStreamStats = rtpReceiverStats.getPacketStreamStats();
                bitrateDownloadBps += (double)incomingPacketStreamStats.getBitrateBps();
                packetRateDownload += incomingPacketStreamStats.getPacketRate();
                conferenceBitrate += incomingPacketStreamStats.getBitrateBps();
                conferencePacketRate += incomingPacketStreamStats.getPacketRate();
                bitrateUploadBps += (double)outgoingStats.getBitrateBps();
                packetRateUpload += outgoingStats.getPacketRate();
                conferenceBitrate += outgoingStats.getBitrateBps();
                conferencePacketRate += outgoingStats.getPacketRate();
                double endpointRtt = endpointConnectionStats.getRtt();
                if (endpointRtt > 0.0) {
                    rttSumMs += endpointRtt;
                    long l5 = rttCount;
                    rttCount = l5 + 1L;
                }
                incomingPacketsReceived += endpointConnectionStats.getIncomingLossStats().getPacketsReceived();
                incomingPacketsLost += endpointConnectionStats.getIncomingLossStats().getPacketsLost();
                long endpointOutgoingPacketsReceived = endpointConnectionStats.getOutgoingLossStats().getPacketsReceived();
                long endpointOutgoingPacketsLost = endpointConnectionStats.getOutgoingLossStats().getPacketsLost();
                outgoingPacketsReceived += endpointOutgoingPacketsReceived;
                outgoingPacketsLost += endpointOutgoingPacketsLost;
                if (inactive || endpointOutgoingPacketsLost + endpointOutgoingPacketsReceived <= 0L || !((endpointOutgoingFractionLost = (double)endpointOutgoingPacketsLost / (double)(endpointOutgoingPacketsLost + endpointOutgoingPacketsReceived)) > 0.1)) continue;
                long l6 = endpointsWithHighOutgoingLoss;
                endpointsWithHighOutgoingLoss = l6 + 1L;
            }
            for (Relay relay : conference.getRelays()) {
                relayBitrateIncomingBps += (double)relay.getIncomingBitrateBps();
                relayPacketRateIncoming += relay.getIncomingPacketRate();
                conferenceBitrate += relay.getIncomingBitrateBps();
                conferencePacketRate += relay.getIncomingPacketRate();
                relayBitrateOutgoingBps += (double)relay.getOutgoingBitrateBps();
                relayPacketRateOutgoing += relay.getOutgoingPacketRate();
                conferenceBitrate += relay.getOutgoingBitrateBps();
                conferencePacketRate += relay.getOutgoingPacketRate();
            }
            audioSendersList.add(conferenceAudioSenders);
            numAudioSenders += conferenceAudioSenders;
            videoSendersList.add(conferenceVideoSenders);
            numVideoSenders += conferenceVideoSenders;
            ConferencePacketStats.stats.addValue((int)numConferenceEndpoints, conferencePacketRate, conferenceBitrate);
        }
        double rttAggregate = rttCount > 0L ? rttSumMs / (double)rttCount : 0.0;
        double incomingLoss = 0.0;
        if (incomingPacketsReceived + incomingPacketsLost > 0L) {
            incomingLoss = (double)incomingPacketsLost / (double)(incomingPacketsReceived + incomingPacketsLost);
        }
        double outgoingLoss = 0.0;
        if (outgoingPacketsReceived + outgoingPacketsLost > 0L) {
            outgoingLoss = (double)outgoingPacketsLost / (double)(outgoingPacketsReceived + outgoingPacketsLost);
        }
        double overallLoss = 0.0;
        if (incomingPacketsReceived + incomingPacketsLost + outgoingPacketsReceived + outgoingPacketsLost > 0L) {
            overallLoss = (double)(outgoingPacketsLost + incomingPacketsLost) / (double)(incomingPacketsReceived + incomingPacketsLost + outgoingPacketsReceived + outgoingPacketsLost);
        }
        DoubleGaugeMetric.set$default(VideobridgePeriodicMetrics.incomingLoss, incomingLoss, null, 2, null);
        DoubleGaugeMetric.set$default(VideobridgePeriodicMetrics.outgoingLoss, outgoingLoss, null, 2, null);
        DoubleGaugeMetric.set$default(loss, overallLoss, null, 2, null);
        LongGaugeMetric.set$default(VideobridgePeriodicMetrics.endpoints, endpoints, null, 2, null);
        LongGaugeMetric.set$default(VideobridgePeriodicMetrics.endpointsWithHighOutgoingLoss, endpointsWithHighOutgoingLoss, null, 2, null);
        LongGaugeMetric.set$default(endpointsWithSpuriousRemb, RembHandler.Companion.endpointsWithSpuriousRemb(), null, 2, null);
        LongGaugeMetric.set$default(activeEndpoints, numLocalActiveEndpoints, null, 2, null);
        LongGaugeMetric.set$default(incomingBitrate, (long)bitrateDownloadBps, null, 2, null);
        LongGaugeMetric.set$default(outgoingBitrate, (long)bitrateUploadBps, null, 2, null);
        LongGaugeMetric.set$default(incomingPacketRate, packetRateDownload, null, 2, null);
        LongGaugeMetric.set$default(outgoingPacketRate, packetRateUpload, null, 2, null);
        DoubleGaugeMetric.set$default(averageRtt, rttAggregate, null, 2, null);
        LongGaugeMetric.set$default(largestConference, largestConferenceSize, null, 2, null);
        LongGaugeMetric.set$default(endpointsSendingAudio, numAudioSenders, null, 2, null);
        LongGaugeMetric.set$default(endpointsSendingVideo, numVideoSenders, null, 2, null);
        LongGaugeMetric.set$default(endpointsRelayed, octoEndpoints, null, 2, null);
        LongGaugeMetric.set$default(endpointsOversending, numOversending, null, 2, null);
        LongGaugeMetric.set$default(endpointsReceiveOnly, receiveOnlyEndpoints, null, 2, null);
        LongGaugeMetric.set$default(endpointsInactive, inactiveEndpoints, null, 2, null);
        LongGaugeMetric.set$default(VideobridgePeriodicMetrics.endpointsWithSuspendedSources, endpointsWithSuspendedSources, null, 2, null);
        LongGaugeMetric.set$default(conferencesInactive, inactiveConferences, null, 2, null);
        LongGaugeMetric.set$default(conferencesP2p, p2pConferences, null, 2, null);
        LongGaugeMetric.set$default(conferencesWithRelay, octoConferences, null, 2, null);
        LongGaugeMetric.set$default(relayIncomingBitrate, (long)relayBitrateIncomingBps, null, 2, null);
        LongGaugeMetric.set$default(relayOutgoingBitrate, (long)relayBitrateOutgoingBps, null, 2, null);
        LongGaugeMetric.set$default(relayIncomingPacketRate, relayPacketRateIncoming, null, 2, null);
        LongGaugeMetric.set$default(relayOutgoingPacketRate, relayPacketRateOutgoing, null, 2, null);
        conferencesBySize.getHistogram().clear();
        Iterable $this$forEach$iv = conferenceSizesList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).longValue();
            boolean bl = false;
            conferencesBySize.getHistogram().observe(it);
        }
        conferencesByAudioSender.getHistogram().clear();
        $this$forEach$iv = audioSendersList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).longValue();
            boolean bl = false;
            conferencesByAudioSender.getHistogram().observe(it);
        }
        conferencesByVideoSender.getHistogram().clear();
        $this$forEach$iv = videoSendersList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).longValue();
            boolean bl = false;
            conferencesByVideoSender.getHistogram().observe(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new VideobridgePeriodicMetrics();
        incomingLoss = MetricsContainer.registerDoubleGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "incoming_loss_fraction", "Fraction of incoming RTP packets that are lost.", 0.0, null, 12, null);
        outgoingLoss = MetricsContainer.registerDoubleGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "outgoing_loss_fraction", "Fraction of outgoing RTP packets that are lost.", 0.0, null, 12, null);
        loss = MetricsContainer.registerDoubleGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "loss_fraction", "Fraction of RTP packets that are lost (incoming and outgoing combined).", 0.0, null, 12, null);
        relayIncomingBitrate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_incoming_bitrate", "Incoming RTP/RTCP bitrate from relays in bps.", 0L, null, 12, null);
        relayOutgoingBitrate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_outgoing_bitrate", "Outgoing RTP/RTCP bitrate to relays in bps.", 0L, null, 12, null);
        relayIncomingPacketRate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_incoming_packet_rate", "Incoming RTP/RTCP packet rate from relays in pps.", 0L, null, 12, null);
        relayOutgoingPacketRate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_outgoing_packet_rate", "Outgoing RTP/RTCP packet rate to relays in pps.", 0L, null, 12, null);
        incomingBitrate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "incoming_bitrate", "Incoming RTP/RTCP bitrate in bps.", 0L, null, 12, null);
        outgoingBitrate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "outgoing_bitrate", "Outgoing RTP/RTCP bitrate in bps.", 0L, null, 12, null);
        incomingPacketRate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "incoming_packet_rate", "Incoming RTP/RTCP packet rate in pps.", 0L, null, 12, null);
        outgoingPacketRate = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "outgoing_packet_rate", "Outgoing RTP/RTCP packet rate in pps.", 0L, null, 12, null);
        averageRtt = MetricsContainer.registerDoubleGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "average_rtt", "Average RTT across all local endpoints in ms.", 0.0, null, 12, null);
        largestConference = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "largest_conference", "The size of the largest conference (number of endpoints).", 0L, null, 12, null);
        endpoints = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "current_endpoints", "Number of current endpoints (local and relayed).", 0L, null, 12, null);
        endpointsWithHighOutgoingLoss = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_with_high_outgoing_loss", "Number of endpoints that have high outgoing loss (>10%).", 0L, null, 12, null);
        activeEndpoints = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "active_endpoints", "The number of active local endpoints (in a conference where at least one endpoint sends audio or video).", 0L, null, 12, null);
        endpointsSendingAudio = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_sending_audio", "The number of local endpoints sending audio.", 0L, null, 12, null);
        endpointsSendingVideo = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_sending_video", "The number of local endpoints sending video.", 0L, null, 12, null);
        endpointsRelayed = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_relayed", "Number of relayed endpoints.", 0L, null, 12, null);
        endpointsOversending = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_oversending", "Number of endpoints that we are oversending to.", 0L, null, 12, null);
        endpointsReceiveOnly = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_recvonly", "Number of endpoints that are not sending audio or video (but are receiveing).", 0L, null, 12, null);
        endpointsInactive = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_inactive", "Number of endpoints in inactive conferences (where no endpoint sends audio or video).", 0L, null, 12, null);
        endpointsWithSpuriousRemb = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_with_spurious_remb", "Number of endpoints that have send a REMB packet even though REMB wasn't configured.", 0L, null, 12, null);
        endpointsWithSuspendedSources = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_with_suspended_sources", "Number of endpoints that that we have suspended sending some video streams to because of bwe.", 0L, null, 12, null);
        conferencesInactive = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "conferences_inactive", "Number of inactive conferences (no endpoint is sending audio or video).", 0L, null, 12, null);
        conferencesP2p = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "conferences_p2p", "Number of p2p conferences (inactive with 2 endpoints).", 0L, null, 12, null);
        conferencesWithRelay = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "conferences_with_relay", "Number of conferences with one or more relays.", 0L, null, 12, null);
        Iterable $this$map$iv = new IntRange(0, 20);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)it);
        }
        double[] dArray = conferenceSizeBuckets = CollectionsKt.toDoubleArray(CollectionsKt.toList((List)var3_3));
        conferencesBySize = VideobridgeMetricsContainer.Companion.getInstance().registerHistogram("conferences_by_size", "Histogram of conferences by total number of endpoints.", Arrays.copyOf(dArray, dArray.length));
        dArray = conferenceSizeBuckets;
        conferencesByAudioSender = VideobridgeMetricsContainer.Companion.getInstance().registerHistogram("conferences_by_audio_sender", "Histogram of conferences by number of local endpoints sending audio.", Arrays.copyOf(dArray, dArray.length));
        dArray = conferenceSizeBuckets;
        conferencesByVideoSender = VideobridgeMetricsContainer.Companion.getInstance().registerHistogram("conferences_by_video_sender", "Histogram of conferences by number of local endpoints sending video.", Arrays.copyOf(dArray, dArray.length));
    }
}

