/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transport.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvesters;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.util.Buffer;
import org.ice4j.util.BufferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.ice.Harvesters;
import org.jitsi.videobridge.ice.IceConfig;
import org.jitsi.videobridge.ice.TransportUtils;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.transport.ice.IceProcessingStateTransition;
import org.jitsi.videobridge.transport.ice.IceStatistics;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.transport.ice.IceTransportKt;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u0000 K2\u00020\u0001:\u0004KLMNB;\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000200J\u001e\u00104\u001a\u0002002\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208J\u0006\u0010:\u001a\u000200J\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u0002002\u0006\u0010>\u001a\u000202J\u001e\u0010?\u001a\u0002082\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010C\u001a\u00020\u0005H\u0002J\u0010\u0010D\u001a\u0002002\u0006\u0010E\u001a\u00020FH\u0002J\u000e\u0010G\u001a\u0002002\u0006\u0010H\u001a\u00020IJ\u0010\u0010J\u001a\u0002002\u0006\u0010E\u001a\u00020FH\u0002R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0019R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u0018\u0010'\u001a\n %*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006O"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport;", "", "id", "", "controlling", "", "useUniquePort", "advertisePrivateAddresses", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;ZZZLorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "getUseUniquePort", "()Z", "logger", "incomingDataHandler", "Lorg/jitsi/videobridge/transport/ice/IceTransport$IncomingDataHandler;", "eventHandler", "Lorg/jitsi/videobridge/transport/ice/IceTransport$EventHandler;", "iceWriteable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "iceConnected", "iceFailed", "iceFailed$1", "hasFailed", "isWriteable", "isConnected", "running", "iceStateChangeListener", "Ljava/beans/PropertyChangeListener;", "iceStreamPairChangedListener", "iceAgent", "Lorg/ice4j/ice/Agent;", "iceStream", "Lorg/ice4j/ice/IceMediaStream;", "kotlin.jvm.PlatformType", "Lorg/ice4j/ice/IceMediaStream;", "iceComponent", "Lorg/ice4j/ice/Component;", "Lorg/ice4j/ice/Component;", "packetStats", "Lorg/jitsi/videobridge/transport/ice/IceTransport$PacketStats;", "icePassword", "getIcePassword", "()Ljava/lang/String;", "startConnectivityEstablishment", "", "transportPacketExtension", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "startReadingData", "send", "data", "", "off", "", "length", "stop", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "describe", "pe", "addRemoteCandidates", "remoteCandidates", "", "Lorg/jitsi/xmpp/extensions/jingle/CandidatePacketExtension;", "iceAgentIsRunning", "iceStateChanged", "ev", "Ljava/beans/PropertyChangeEvent;", "updateStatsOnInitialRtt", "rttMs", "", "iceStreamPairChanged", "Companion", "PacketStats", "IncomingDataHandler", "EventHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nIceTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceTransport.kt\norg/jitsi/videobridge/transport/ice/IceTransport\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,568:1\n63#2,4:569\n63#2,4:573\n63#2,4:577\n63#2,4:581\n63#2,4:585\n63#2,4:589\n63#2,4:597\n1855#3:593\n1856#3:595\n1855#3:596\n1856#3:601\n1#4:594\n*S KotlinDebug\n*F\n+ 1 IceTransport.kt\norg/jitsi/videobridge/transport/ice/IceTransport\n*L\n169#1:569,4\n172#1:573,4\n184#1:577,4\n218#1:581,4\n223#1:585,4\n252#1:589,4\n330#1:597,4\n306#1:593\n306#1:595\n323#1:596\n323#1:601\n*E\n"})
public final class IceTransport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean useUniquePort;
    private final boolean advertisePrivateAddresses;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @JvmField
    @Nullable
    public IncomingDataHandler incomingDataHandler;
    @JvmField
    @Nullable
    public EventHandler eventHandler;
    @NotNull
    private final AtomicBoolean iceWriteable;
    @NotNull
    private final AtomicBoolean iceConnected;
    @NotNull
    private final AtomicBoolean iceFailed$1;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final PropertyChangeListener iceStateChangeListener;
    @NotNull
    private final PropertyChangeListener iceStreamPairChangedListener;
    @NotNull
    private final Agent iceAgent;
    private final IceMediaStream iceStream;
    private final Component iceComponent;
    @NotNull
    private final PacketStats packetStats;
    @NotNull
    private static final CounterMetric iceFailed = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "ice_failed", "Number of times an ICE Agent failed to establish connectivity.", 0L, null, 12, null);
    @NotNull
    private static final CounterMetric iceSucceeded = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "ice_succeeded", "Number of times an ICE Agent succeeded.", 0L, null, 12, null);
    @NotNull
    private static final CounterMetric iceSucceededRelayed = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "ice_succeeded_relayed", "Number of times an ICE Agent succeeded and the selected pair included a relayed candidate.", 0L, null, 12, null);

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public IceTransport(@NotNull String id, boolean controlling, boolean useUniquePort, boolean advertisePrivateAddresses, @NotNull Logger parentLogger, @NotNull Clock clock) {
        void $this$iceComponent_u24lambda_u245;
        Object $this$iceStream_u24lambda_u244;
        Object it;
        Agent $this$iceAgent_u24lambda_u242;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.useUniquePort = useUniquePort;
        this.advertisePrivateAddresses = advertisePrivateAddresses;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.iceWriteable = new AtomicBoolean(false);
        this.iceConnected = new AtomicBoolean(false);
        this.iceFailed$1 = new AtomicBoolean(false);
        this.running = new AtomicBoolean(true);
        this.iceStateChangeListener = arg_0 -> IceTransport.iceStateChangeListener$lambda$0(this, arg_0);
        this.iceStreamPairChangedListener = arg_0 -> IceTransport.iceStreamPairChangedListener$lambda$1(this, arg_0);
        Object object = new Agent(IceConfig.config.getUfragPrefix(), this.logger);
        Agent agent = object;
        IceTransport iceTransport = this;
        boolean bl = false;
        if (this.useUniquePort) {
            $this$iceAgent_u24lambda_u242.setUseDynamicPorts(true);
        } else {
            Companion.appendHarvesters($this$iceAgent_u24lambda_u242);
        }
        $this$iceAgent_u24lambda_u242.setControlling(controlling);
        $this$iceAgent_u24lambda_u242.setPerformConsentFreshness(true);
        $this$iceAgent_u24lambda_u242.setNominationStrategy(IceConfig.config.getNominationStrategy());
        $this$iceAgent_u24lambda_u242.addStateChangeListener(this.iceStateChangeListener);
        $this$iceAgent_u24lambda_u242 = object;
        boolean bl2 = false;
        this.logger.addContext("local_ufrag", ((Agent)it).getLocalUfrag());
        iceTransport.iceAgent = object;
        it = object = this.iceAgent.createMediaStream("stream");
        iceTransport = this;
        boolean bl3 = false;
        ((IceMediaStream)$this$iceStream_u24lambda_u244).addPairChangeListener(this.iceStreamPairChangedListener);
        iceTransport.iceStream = object;
        $this$iceStream_u24lambda_u244 = object = this.iceAgent.createComponent(this.iceStream, IceConfig.config.getKeepAliveStrategy(), false);
        iceTransport = this;
        boolean bl4 = false;
        $this$iceComponent_u24lambda_u245.setBufferCallback(new BufferHandler(this){
            final /* synthetic */ IceTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public void handleBuffer(Buffer buffer) {
                Intrinsics.checkNotNullParameter(buffer, "buffer");
                IncomingDataHandler incomingDataHandler = this.this$0.incomingDataHandler;
                if (incomingDataHandler != null) {
                    incomingDataHandler.dataReceived(buffer);
                } else {
                    iceComponent.1.1 var2_2 = this;
                    IceTransport iceTransport = this.this$0;
                    iceComponent.1.1 $this$handleBuffer_u24lambda_u240 = var2_2;
                    boolean bl = false;
                    IceTransport.access$getPacketStats$p(iceTransport).getNumIncomingPacketsDroppedNoHandler().increment();
                    ByteBufferPool.returnBuffer(buffer.getBuffer());
                }
            }
        });
        iceTransport.iceComponent = object;
        this.packetStats = new PacketStats();
    }

    public /* synthetic */ IceTransport(String string, boolean bl, boolean bl2, boolean bl3, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x20) != 0) {
            clock = Clock.systemUTC();
        }
        this(string, bl, bl2, bl3, logger, clock);
    }

    public final boolean getUseUniquePort() {
        return this.useUniquePort;
    }

    public final boolean hasFailed() {
        return this.iceFailed$1.get();
    }

    public final boolean isWriteable() {
        return this.iceWriteable.get();
    }

    public final boolean isConnected() {
        return this.iceConnected.get();
    }

    @NotNull
    public final String getIcePassword() {
        String string = this.iceAgent.getLocalPassword();
        Intrinsics.checkNotNullExpressionValue(string, "getLocalPassword(...)");
        return string;
    }

    public final void startConnectivityEstablishment(@NotNull IceUdpTransportPacketExtension transportPacketExtension) {
        Logger logger;
        Intrinsics.checkNotNullParameter(transportPacketExtension, "transportPacketExtension");
        if (!this.running.get()) {
            this.logger.warn("Not starting connectivity establishment, transport is not running");
            return;
        }
        if (this.iceAgent.getState().isEstablished()) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger2 = $this$cdebug$iv;
                boolean bl = false;
                logger2.debug("Connection already established");
            }
            return;
        }
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Starting ICE connectivity establishment");
        }
        this.iceStream.setRemoteUfrag(transportPacketExtension.getUfrag());
        this.iceStream.setRemotePassword(transportPacketExtension.getPassword());
        boolean iceAgentStateIsRunning = IceProcessingState.RUNNING == this.iceAgent.getState();
        List<CandidatePacketExtension> remoteCandidates = transportPacketExtension.getChildExtensionsOfType(CandidatePacketExtension.class);
        if (iceAgentStateIsRunning && remoteCandidates.isEmpty()) {
            Logger $this$cdebug$iv2 = this.logger;
            boolean $i$f$cdebug2 = false;
            if ($this$cdebug$iv2.isDebugEnabled()) {
                logger = $this$cdebug$iv2;
                boolean bl = false;
                logger.debug("Ignoring transport extensions with no candidates, the Agent is already running.");
            }
            return;
        }
        Intrinsics.checkNotNull(remoteCandidates);
        int remoteCandidateCount = this.addRemoteCandidates(remoteCandidates, iceAgentStateIsRunning);
        if (iceAgentStateIsRunning) {
            if (remoteCandidateCount != 0) {
                this.iceComponent.updateRemoteCandidates();
            }
        } else if (remoteCandidateCount != 0) {
            if (this.iceComponent.getRemoteCandidateCount() > 0) {
                this.logger.debug("Starting the agent with remote candidates.");
                this.iceAgent.startConnectivityEstablishment();
            }
        } else {
            IceMediaStream iceMediaStream = this.iceStream;
            Intrinsics.checkNotNullExpressionValue(iceMediaStream, "iceStream");
            if (IceTransportKt.access$remoteUfragAndPasswordKnown(iceMediaStream)) {
                this.logger.debug("Starting the Agent without remote candidates.");
                this.iceAgent.startConnectivityEstablishment();
            } else {
                Logger $this$cdebug$iv3 = this.logger;
                boolean $i$f$cdebug3 = false;
                if ($this$cdebug$iv3.isDebugEnabled()) {
                    logger = $this$cdebug$iv3;
                    boolean bl = false;
                    logger.debug("Not starting ICE, no ufrag and pwd yet. " + transportPacketExtension.toXML());
                }
            }
        }
    }

    public final void startReadingData() {
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Starting to read incoming data");
        }
        IceSocketWrapper socket = this.iceComponent.getSelectedPair().getIceSocketWrapper();
        byte[] receiveBuf = new byte[1500];
        DatagramPacket packet = new DatagramPacket(receiveBuf, 0, receiveBuf.length);
        Instant receivedTime = null;
        while (this.running.get()) {
            try {
                socket.receive(packet);
                receivedTime = this.clock.instant();
            }
            catch (IOException e) {
                this.logger.warn("Stopping reader", e);
                break;
            }
            this.packetStats.getNumPacketsReceived().increment();
            try {
                byte[] b = ByteBufferPool.getBuffer(10 + packet.getLength() + 20);
                System.arraycopy(packet.getData(), packet.getOffset(), b, 10, packet.getLength());
                Intrinsics.checkNotNull(b);
                Buffer buffer = new Buffer(b, 10, packet.getLength(), receivedTime, null, null, 48, null);
                IncomingDataHandler incomingDataHandler = this.incomingDataHandler;
                if (incomingDataHandler != null) {
                    incomingDataHandler.dataReceived(buffer);
                    continue;
                }
                IceTransport $this$startReadingData_u24lambda_u2412 = this;
                boolean bl = false;
                Logger $this$cdebug$iv2 = $this$startReadingData_u24lambda_u2412.logger;
                boolean $i$f$cdebug2 = false;
                if ($this$cdebug$iv2.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv2;
                    boolean bl2 = false;
                    logger.debug("Data handler is null, dropping data");
                }
                $this$startReadingData_u24lambda_u2412.packetStats.getNumIncomingPacketsDroppedNoHandler().increment();
            }
            catch (Throwable e) {
                this.logger.error("Uncaught exception processing packet", e);
            }
        }
        this.logger.info("No longer running, stopped reading packets");
    }

    public final void send(@NotNull byte[] data, int off, int length) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (this.running.get()) {
            try {
                this.iceComponent.send(data, off, length);
                this.packetStats.getNumPacketsSent().increment();
            }
            catch (IOException e) {
                this.logger.error("Error sending packet", e);
                throw new RuntimeException();
            }
        } else {
            this.packetStats.getNumOutgoingPacketsDroppedStopped().increment();
        }
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.logger.info("Stopping");
            this.iceAgent.removeStateChangeListener(this.iceStateChangeListener);
            this.iceStream.removePairStateChangeListener(this.iceStreamPairChangedListener);
            this.iceAgent.free();
        }
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2413 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        String string = IceConfig.config.getKeepAliveStrategy().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        $this$getDebugState_u24lambda_u2413.put("keepAliveStrategy", string);
        String string2 = IceConfig.config.getNominationStrategy().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        $this$getDebugState_u24lambda_u2413.put("nominationStrategy", string2);
        $this$getDebugState_u24lambda_u2413.put("advertisePrivateCandidates", (Object)IceConfig.config.getAdvertisePrivateCandidates());
        $this$getDebugState_u24lambda_u2413.put("closed", (Object)(!this.running.get() ? 1 : 0));
        $this$getDebugState_u24lambda_u2413.put("iceWriteable", (Object)this.iceWriteable.get());
        $this$getDebugState_u24lambda_u2413.put("iceConnected", (Object)this.iceConnected.get());
        $this$getDebugState_u24lambda_u2413.put("iceFailed", (Object)this.iceFailed$1.get());
        $this$getDebugState_u24lambda_u2413.putAll(this.packetStats.toJson());
        return orderedJsonObject;
    }

    public final void describe(@NotNull IceUdpTransportPacketExtension pe) {
        Intrinsics.checkNotNullParameter(pe, "pe");
        if (!this.running.get()) {
            this.logger.warn("Not describing, transport is not running");
        }
        IceUdpTransportPacketExtension $this$describe_u24lambda_u2416 = pe;
        boolean bl = false;
        $this$describe_u24lambda_u2416.setPassword(this.iceAgent.getLocalPassword());
        $this$describe_u24lambda_u2416.setUfrag(this.iceAgent.getLocalUfrag());
        List<LocalCandidate> list = this.iceComponent.getLocalCandidates();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CandidatePacketExtension it;
                LocalCandidate cand = (LocalCandidate)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(cand);
                if (IceTransportKt.access$toCandidatePacketExtension(cand, this.advertisePrivateAddresses) == null) continue;
                boolean bl3 = false;
                pe.addChildExtension(it);
            }
        }
        $this$describe_u24lambda_u2416.addChildExtension(new IceRtcpmuxPacketExtension());
    }

    private final int addRemoteCandidates(List<? extends CandidatePacketExtension> remoteCandidates, boolean iceAgentIsRunning) {
        int remoteCandidateCount = 0;
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)remoteCandidates);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RemoteCandidate remoteCandidate;
            CandidatePacketExtension candidate = (CandidatePacketExtension)element$iv;
            boolean bl = false;
            if (candidate.getGeneration() != this.iceAgent.getGeneration()) continue;
            if (IceTransportKt.access$ipNeedsResolution(candidate) && !IceConfig.config.getResolveRemoteCandidates()) {
                Logger $this$cdebug$iv = this.logger;
                boolean $i$f$cdebug = false;
                if (!$this$cdebug$iv.isDebugEnabled()) continue;
                Logger logger = $this$cdebug$iv;
                boolean bl2 = false;
                logger.debug("Ignoring remote candidate with non-literal address: " + candidate.getIP());
                continue;
            }
            Component component = this.iceStream.getComponent(candidate.getComponent());
            if (!TransportUtils.canReach(component, remoteCandidate = new RemoteCandidate(new TransportAddress(candidate.getIP(), candidate.getPort(), Transport.parse(candidate.getProtocol())), component, CandidateType.parse(candidate.getType().toString()), candidate.getFoundation(), candidate.getPriority(), null))) continue;
            if (iceAgentIsRunning) {
                component.addUpdateRemoteCandidates(remoteCandidate);
            } else {
                component.addRemoteCandidate(remoteCandidate);
            }
            ++remoteCandidateCount;
        }
        return remoteCandidateCount;
    }

    private final void iceStateChanged(PropertyChangeEvent ev) {
        Object object = ev.getOldValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.ice4j.ice.IceProcessingState");
        IceProcessingState oldState = (IceProcessingState)((Object)object);
        Object object2 = ev.getNewValue();
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type org.ice4j.ice.IceProcessingState");
        IceProcessingState newState = (IceProcessingState)((Object)object2);
        IceProcessingStateTransition transition = new IceProcessingStateTransition(oldState, newState);
        this.logger.debug("ICE state changed old=" + oldState + " new=" + newState);
        if (transition.completed()) {
            if (this.iceConnected.compareAndSet(false, true)) {
                EventHandler eventHandler = this.eventHandler;
                if (eventHandler != null) {
                    eventHandler.connected();
                }
                if (this.useUniquePort) {
                    TaskPools.IO_POOL.submit(() -> IceTransport.iceStateChanged$lambda$19(this));
                }
                if (this.iceComponent.getSelectedPair().getRemoteCandidate().getType() == CandidateType.RELAYED_CANDIDATE || this.iceComponent.getSelectedPair().getLocalCandidate().getType() == CandidateType.RELAYED_CANDIDATE) {
                    CounterMetric.inc$default(iceSucceededRelayed, null, 1, null);
                }
                CounterMetric.inc$default(iceSucceeded, null, 1, null);
            }
        } else if (transition.failed() && this.iceFailed$1.compareAndSet(false, true)) {
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.failed();
            }
            CounterMetric.inc$default(iceFailed, null, 1, null);
        }
    }

    public final void updateStatsOnInitialRtt(double rttMs) {
        Object object;
        CandidatePair selectedPair = this.iceComponent.getSelectedPair();
        Comparable<CandidatePair> comparable = selectedPair;
        if (comparable == null || (comparable = ((CandidatePair)comparable).getLocalCandidate()) == null) {
            return;
        }
        Comparable<CandidatePair> localCandidate = comparable;
        if (localCandidate instanceof HostCandidate) {
            object = "host";
        } else {
            object = MappingCandidateHarvesters.findHarvesterForAddress(((Candidate)localCandidate).getTransportAddress());
            if (object == null || (object = ((MappingCandidateHarvester)object).getName()) == null) {
                object = "other";
            }
        }
        String harvesterName = object;
        IceStatistics.Companion.getStats().add(harvesterName, rttMs);
    }

    private final void iceStreamPairChanged(PropertyChangeEvent ev) {
        block3: {
            block2: {
                if (!Intrinsics.areEqual("PairValidated", ev.getPropertyName())) break block2;
                if (!this.iceWriteable.compareAndSet(false, true)) break block3;
                EventHandler eventHandler = this.eventHandler;
                if (eventHandler != null) {
                    eventHandler.writeable();
                }
                break block3;
            }
            if (!Intrinsics.areEqual("PairConsentFreshnessChanged", ev.getPropertyName())) break block3;
            Object object = ev.getNewValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Long");
            Instant time = Instant.ofEpochMilli((Long)object);
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                Intrinsics.checkNotNull(time);
                eventHandler.consentUpdated(time);
            }
        }
    }

    @JvmOverloads
    public IceTransport(@NotNull String id, boolean controlling, boolean useUniquePort, boolean advertisePrivateAddresses, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(id, controlling, useUniquePort, advertisePrivateAddresses, parentLogger, null, 32, null);
    }

    private static final void iceStateChangeListener$lambda$0(IceTransport this$0, PropertyChangeEvent ev) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNull(ev);
        this$0.iceStateChanged(ev);
    }

    private static final void iceStreamPairChangedListener$lambda$1(IceTransport this$0, PropertyChangeEvent ev) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNull(ev);
        this$0.iceStreamPairChanged(ev);
    }

    private static final void iceStateChanged$lambda$19(IceTransport this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.startReadingData();
    }

    public static final /* synthetic */ PacketStats access$getPacketStats$p(IceTransport $this) {
        return $this.packetStats;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$Companion;", "", "<init>", "()V", "appendHarvesters", "", "iceAgent", "Lorg/ice4j/ice/Agent;", "iceFailed", "Lorg/jitsi/metrics/CounterMetric;", "getIceFailed", "()Lorg/jitsi/metrics/CounterMetric;", "iceSucceeded", "getIceSucceeded", "iceSucceededRelayed", "getIceSucceededRelayed", "jitsi-videobridge"})
    @SourceDebugExtension(value={"SMAP\nIceTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceTransport.kt\norg/jitsi/videobridge/transport/ice/IceTransport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,568:1\n1855#2,2:569\n*S KotlinDebug\n*F\n+ 1 IceTransport.kt\norg/jitsi/videobridge/transport/ice/IceTransport$Companion\n*L\n427#1:569,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void appendHarvesters(@NotNull Agent iceAgent) {
            Intrinsics.checkNotNullParameter(iceAgent, "iceAgent");
            Iterable $this$forEach$iv = Harvesters.Companion.getINSTANCE().getSinglePortHarvesters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CandidateHarvester p0 = (CandidateHarvester)element$iv;
                boolean bl = false;
                iceAgent.addCandidateHarvester(p0);
            }
        }

        @NotNull
        public final CounterMetric getIceFailed() {
            return iceFailed;
        }

        @NotNull
        public final CounterMetric getIceSucceeded() {
            return iceSucceeded;
        }

        @NotNull
        public final CounterMetric getIceSucceededRelayed() {
            return iceSucceededRelayed;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$EventHandler;", "", "writeable", "", "connected", "failed", "consentUpdated", "time", "Ljava/time/Instant;", "jitsi-videobridge"})
    public static interface EventHandler {
        public void writeable();

        public void connected();

        public void failed();

        public void consentUpdated(@NotNull Instant var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$IncomingDataHandler;", "", "dataReceived", "", "buffer", "Lorg/ice4j/util/Buffer;", "jitsi-videobridge"})
    public static interface IncomingDataHandler {
        public void dataReceived(@NotNull Buffer var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$PacketStats;", "", "<init>", "()V", "numPacketsReceived", "Ljava/util/concurrent/atomic/LongAdder;", "getNumPacketsReceived", "()Ljava/util/concurrent/atomic/LongAdder;", "numIncomingPacketsDroppedNoHandler", "getNumIncomingPacketsDroppedNoHandler", "numPacketsSent", "getNumPacketsSent", "numOutgoingPacketsDroppedStopped", "getNumOutgoingPacketsDroppedStopped", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-videobridge"})
    private static final class PacketStats {
        @NotNull
        private final LongAdder numPacketsReceived = new LongAdder();
        @NotNull
        private final LongAdder numIncomingPacketsDroppedNoHandler = new LongAdder();
        @NotNull
        private final LongAdder numPacketsSent = new LongAdder();
        @NotNull
        private final LongAdder numOutgoingPacketsDroppedStopped = new LongAdder();

        @NotNull
        public final LongAdder getNumPacketsReceived() {
            return this.numPacketsReceived;
        }

        @NotNull
        public final LongAdder getNumIncomingPacketsDroppedNoHandler() {
            return this.numIncomingPacketsDroppedNoHandler;
        }

        @NotNull
        public final LongAdder getNumPacketsSent() {
            return this.numPacketsSent;
        }

        @NotNull
        public final LongAdder getNumOutgoingPacketsDroppedStopped() {
            return this.numOutgoingPacketsDroppedStopped;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u240.put("num_packets_received", (Object)this.numPacketsReceived.sum());
            $this$toJson_u24lambda_u240.put("num_incoming_packets_dropped_no_handler", (Object)this.numIncomingPacketsDroppedNoHandler.sum());
            $this$toJson_u24lambda_u240.put("num_packets_sent", (Object)this.numPacketsSent.sum());
            $this$toJson_u24lambda_u240.put("num_outgoing_packets_dropped_stopped", (Object)this.numOutgoingPacketsDroppedStopped.sum());
            return orderedJsonObject;
        }
    }
}

