/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp;

import org.jxmpp.stringprep.XmppStringprep;
import org.jxmpp.stringprep.simple.SimpleXmppStringprep;
import org.jxmpp.util.Objects;

public final class JxmppContext {
    private static JxmppContext defaultContext;
    private static XmppStringprep defaultXmppStringprep;
    private final boolean cachingEnabled;
    public final XmppStringprep xmppStringprep;

    public static JxmppContext getDefaultContext() {
        return defaultContext;
    }

    public static void setDefaultXmppStringprep(XmppStringprep defaultXmppStringprep) {
        JxmppContext.defaultXmppStringprep = Objects.requireNonNull(defaultXmppStringprep, "defaultXmppStringprep");
        JxmppContext.updateDefaultContext();
    }

    private static void updateDefaultContext() {
        defaultContext = JxmppContext.builder().enableCaching().withXmppStringprep(defaultXmppStringprep).build();
    }

    private JxmppContext(Builder builder2) {
        this.cachingEnabled = builder2.cachingEnabled;
        this.xmppStringprep = Objects.requireNonNull(builder2.xmppStringprep, "xmppStringprep");
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        SimpleXmppStringprep.setup();
    }

    public static class Builder {
        private boolean cachingEnabled;
        private XmppStringprep xmppStringprep;

        public Builder enableCaching() {
            this.cachingEnabled = true;
            return this;
        }

        public Builder withXmppStringprep(XmppStringprep xmppStringprep) {
            this.xmppStringprep = Objects.requireNonNull(xmppStringprep, "xmppStringprep");
            return this;
        }

        public JxmppContext build() {
            return new JxmppContext(this);
        }
    }
}

