/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import liquibase.util.MD5Util;
import liquibase.util.StringUtils;

public class CheckSum {
    private int version;
    private String checksum;

    private CheckSum(String checksum, int version) {
        this.checksum = checksum;
        this.version = version;
    }

    public static CheckSum parse(String checksumValue) {
        if (checksumValue == null) {
            return null;
        }
        if (checksumValue.matches("^\\d:.*")) {
            return new CheckSum(checksumValue.substring(2), Integer.parseInt(checksumValue.substring(0, 1)));
        }
        return new CheckSum(checksumValue, 1);
    }

    public static int getCurrentVersion() {
        return 7;
    }

    public static CheckSum compute(String valueToChecksum) {
        return new CheckSum(MD5Util.computeMD5(Normalizer.normalize(StringUtils.standardizeLineEndings(valueToChecksum).replaceAll("\\uFFFD", ""), Normalizer.Form.NFC)), CheckSum.getCurrentVersion());
    }

    public static CheckSum compute(final InputStream stream, boolean standardizeLineEndings) {
        InputStream newStream = stream;
        if (standardizeLineEndings) {
            newStream = new InputStream(){
                int lastChar = 88;

                @Override
                public int read() throws IOException {
                    int read = stream.read();
                    int returnChar = read;
                    if (returnChar == 13) {
                        returnChar = 10;
                    }
                    if (this.lastChar == 13 && returnChar == 10) {
                        returnChar = stream.read();
                    }
                    this.lastChar = read;
                    return returnChar;
                }
            };
        }
        return new CheckSum(MD5Util.computeMD5(newStream), CheckSum.getCurrentVersion());
    }

    public String toString() {
        return this.version + ":" + this.checksum;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CheckSum && this.toString().equals(obj.toString());
    }
}

